<?php
/*
Officity - Web application platform - Version 6.0 - 2011-07-05

François Dispaux, Boris Verdeyen, Thomas Hermant,
Jérémie Roy, Grégory Meurice, Abdelila Harbi, 
Marc Mignonsin, Jonathan Sanchez, Julien Gonzalez, Pierre Fouchez

Sushee and Officity is © Copyright 2011 Nectil SA.

`/var/www/installer/public_html/officity-source/apps/system/css/load-css.php` is part of Officity.

Sushee is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

Officity and Sushee are distributed in the hope that they will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Sushee. If not, see <http://www.gnu.org/licenses/>.
*/
	require_once(dirname(__FILE__).'/../system.include.php');

	/* *** */

	function compress($buffer)
	{ 
		/* remove comments */
		$buffer = preg_replace('!/\*[^*]*\*+([^/][^*]*\*+)*/!', '', $buffer);
		
		/* remove tabs, spaces, newlines, etc. */
		$buffer = str_replace(array("\r\n", "\r", "\n", "\t", '  ', '	', '	'), '', $buffer);

		return $buffer;
	}

	function loadCSS($css_dir, $required_files)
	{
		$dir_handle = opendir($css_dir);

		$css_files = $required_files;

		while ($current_file = readdir($dir_handle))
		{
			if (is_file($css_dir.$current_file))
			{
				$file_ext = pathinfo($current_file, PATHINFO_EXTENSION);

				if ($file_ext == 'css')
				{
					if (!in_array($current_file, $css_files))
					{
						$css_files[] = $current_file;
					}
				}
			}
		}

		//var_export($css_files);
		//return;

		/* *** */

		header('Content-type: text/css');

		$files_count = count($css_files);

		ob_start('compress');

		for ($i=0; $i<$files_count; $i++)
		{
			include($css_dir.$css_files[$i]);
		}

		ob_end_flush();
	}

	/* *** */

	$CSS_DIR = dirname(__FILE__).'/';
	
	// the 1st ones must be :
	$CSS_FILES = array(
		'common.css',
		'jquery-ui-1.7.2.custom.css',
		'jquery.ui.autocomplete.css',
		'officity.css'
	);
	
	loadCSS($CSS_DIR, $CSS_FILES);
?>
