/**
 * jQuery UI : shell
 *
 * @author  Marc Mignonsin
 * @version 2010-12-01
 *
 */

(function( $ ) {
	$.widget("ui.shell", {
		// default options
		options: {		
			show				:	false,
			background			:	{
				type		:	'image',
				url			:	'../../system/images/shell/wallpapers/default.jpg',				
				position	:	'0 0',				
				repeat		:	'repeat-x',
				color		:	'#EEEEEE'
			}
		},
		
		_create: function() {
			//window.log('ui.shell._create', this.options);
			
			// --- internal configuration ---
			
			this.shellBarSelector = '#shell-bar';
			this.desktopSelector = '#desktop';

			this.windowSelector = '#window';
			this.sliderSelector = '#slider';
			this.menuBarSelector = '#menu-bar';
			this.menuBarMaskSelector='#mask';
			this.historySelector = '#history';
			this.newTabSelector = '#new-tab';
			
			this.scrollSpeed = 500; // ms
			this.scrollEasing = 'easeOutExpo';
						
			// --- state variables ---
			
			this.uiShell = this.element;
			
			var initialDesktopHeight = parseInt($(this.sliderSelector).css('height'));
			initialDesktopHeight -= parseInt($(this.shellBarSelector).css('height'));
			
			this.state = {
				desktopHeight : initialDesktopHeight,
				prevSliderColsCount : $(this.sliderSelector).panelslider('getColumnsCount')
			};
		
			// ---- init ---
			
			this._bindShellEvents();
			
			this.setBackground(this.options.background);
			
			// initial layout
			this.uiShell.find(this.desktopSelector).css({ 
				height : this.state.desktopHeight+'px'
			});
			
			if (this.options.show == true)
			{
				$(this.windowSelector).hide();
				this.uiShell.css('top', 0).show().trigger('shell-layout');
			}
		},
		
		_bindShellEvents: function() {
			//window.log('uishell._bindShellEvents');
			
			// viewport size change
			$(window).bind('resize orientationchange', delegate(this, this._doLayout)); 
			
			// layout
			this.uiShell.bind('shell-layout', delegate(this, this._doLayout));
			
			this.uiShell.find(this.desktopSelector).jScrollTouch();
			
			// shell destruction
			this.uiShell.bind('shell-destroy', delegate(this, function(eventObject){
				this.destroy();
			}));
		},
		
		_doLayout: function() {
			//window.log('uishell._doLayout', arguments);
			if (this.uiShell.is(':hidden'))
			{
				//window.warn('Shell layout discarded (hidden)');
				return false;
			}
			
			this.state.desktopHeight = parseInt($(this.sliderSelector).css('height'));
			this.state.desktopHeight -= parseInt($(this.shellBarSelector).css('height'));
			
			this.uiShell.find(this.desktopSelector).css({ 
				height : this.state.desktopHeight+'px'
			});
			
			$(this.windowSelector).css('top', $(this.sliderSelector).css('height'));
		},
		
		toggle : function() {
			//window.log('uishell.toggle', this.state.visible, this.state.desktopHeight);
			
			if ($(this.windowSelector).is(':animated') || this.uiShell.is(':animated'))
			{
				window.warn('Shell toggle discarded (animation in progress)');
				return false;
			}
			
			if (this.uiShell.is(':hidden'))
			{
				// save this to ensure slider layout will be fine when exiting shell mode
				this.state.prevSliderColsCount = $(this.sliderSelector).panelslider('getColumnsCount');
			
				$(this.historySelector).trigger('history-disable');
				$(this.windowSelector).animate(
						{ top: '+='+$(this.sliderSelector).css('height') }, 
						this.scrollSpeed, 
						this.scrollEasing, 
						delegate(this, function() {
							$(this.sliderSelector).hide();
						})
				);
							
				this.uiShell.show().trigger('shell-layout');
				this.uiShell.animate(
						{ top: '0' }, 
						this.scrollSpeed, 
						this.scrollEasing, 
						delegate(this, function() {

						})
				);
			}
			else
			{
				this.uiShell.animate(
						{ top: '-100%' }, 
						this.scrollSpeed, 
						this.scrollEasing, 
						delegate(this, function() {
							this.uiShell.hide();
						})
				);
				
				$(this.historySelector).trigger('history-enable');
				// restore slider columns count :
				// should the window has been resize in shell mode, this will trigger the 
				// expand/reduce strategy according the new columns count (see uislider._doLayout)
				$(this.sliderSelector).show().trigger('slider-layout', [this.state.prevSliderColsCount]);
				$(this.windowSelector).animate(
						{ top: '-='+$(this.sliderSelector).css('height') }, 
						this.scrollSpeed, 
						this.scrollEasing, 
						delegate(this, function() {
														
						})
				);
			}
		},
		
		openApp: function(srcElem, panelID, panelURI, title, params, docTitle, maskTitleAttr, appURL)
		{
			//window.log('uishell.openApp');
			document.title = docTitle;
			
			if (panelID)
			{
				$(this.sliderSelector).show();
				$(this.sliderSelector).panelslider('replacePanel', panelID, panelURI, title, params);
			}
			else
			{
				$(this.windowSelector).show();
				$(this.sliderSelector).show().trigger('slider-layout');
				
				this._doLayout();
				
				var config = {
					title: title
				};
				
				$(this.sliderSelector).panelslider('loadPanel', panelURI, config, params);
			}
			
			this.uiShell.find('a.app-denomination.active').removeClass('active');
			$(srcElem).addClass('active');
			
			$(this.menuBarSelector).find(this.menuBarMaskSelector).attr('title', maskTitleAttr);
			$(this.menuBarSelector).find(this.newTabSelector).removeAttr('onclick').unbind('click').click(function(){
				window.open(appURL, '');	
			});
			
			this.toggle();
		},
		
		setBackground: function(config)
		{
			//window.log('uishell.setBackground', arguments);
			var cssConfig = { };
			
			switch (config.type)
			{
				case 'image':
					cssConfig['background-image'] = 'url('+config.url+')';
					cssConfig['background-position'] = config.position;
					cssConfig['background-repeat'] = config.repeat;
					cssConfig['background-color'] = config.color;
					$(this.desktopSelector).css(cssConfig);
					break;
					
				case 'color':
					cssConfig['background-image'] = 'url()';
					cssConfig['background-repeat'] = 'no-repeat';
					cssConfig['background-color'] = config.color;
					$(this.desktopSelector).css(cssConfig);
					break;
					
				default:
					break;
			}
		},
		
		destroy: function() {
			window.log('uishell.destroy');
			
			this._trigger('beforeDestroy', 0, this);
			
			// custom cleanup	
			this.uiShell.unbind();
			
			// call default
			$.Widget.prototype.destroy.apply(this, arguments); 
						
			this._trigger('afterDestroy', 0, this);
		}
	});
})(jQuery);