<?php
/*
Officity - Web application platform - Version 6.0 - 2011-07-05

François Dispaux, Boris Verdeyen, Thomas Hermant,
Jérémie Roy, Grégory Meurice, Abdelila Harbi, 
Marc Mignonsin, Jonathan Sanchez, Julien Gonzalez, Pierre Fouchez

Sushee and Officity is © Copyright 2011 Nectil SA.

`/var/www/installer/public_html/officity-source/apps/system/load-panel.php` is part of Officity.

Sushee is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

Officity and Sushee are distributed in the hope that they will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Sushee. If not, see <http://www.gnu.org/licenses/>.
*/
    require_once(dirname(__FILE__).'/system.include.php');

    /* *** */
    
    try
    {
	    $EDITOR_FOLDER = $_GET['editor'];
		if (empty($EDITOR_FOLDER))
		{
			throw new MissingEditorException();
		}
	
	    $APP_FOLDER = $_GET['app'];
		if (empty($APP_FOLDER))
		{
			throw new MissingAppException();
		}
	
		$PANEL_URI = $_GET['panelURI'];
		if (empty($PANEL_URI))
		{
	        throw new MissingPanelURIException();
		}
		
		/* *** */
	
		$SCRIPT_PATH = APPS_PATH.$EDITOR_FOLDER.'/'.$APP_FOLDER.'/'.$PANEL_URI.'.php';
		
		if (!file_exists($SCRIPT_PATH))
		{	
	        throw OfficityException::scriptNotFound($PANEL_URI, $SCRIPT_PATH);
		}
	
		session_write_close(); // optim: unlock session data and allow concurrent accesses to this script
		include($SCRIPT_PATH);	
    }
    catch (MissingEditorException $e)
    {
    	$e->displayErrorPanel();	
    }
    catch (MissingAppException $e)
    {
    	$e->displayErrorPanel();	
    }
    catch (MissingPanelURIException $e)
    {
    	$e->displayErrorPanel();	
    }
    catch (ScriptNotFoundException $e)
    {
    	$e->displayErrorPanel();	
    }
    catch (ParamException $e)
    {
    	$e->displayErrorPanel();
    }
    catch (OfficityAppException $e)
    {
    	$e->displayErrorPanel();
    }
    catch (OfficityException $e)
    {
    	$e->displayErrorPanel();
    }
    catch (SusheeProcessorException $e)
    {
    	$msg = '<h1>Unexpected XSLT error!</h1>'.$e->getMessage();
    	die($mg);
    	//displayErrorPanel($e->getMessage(), 'Unexpected XSLT error!');
    }
    catch (SusheeException $e)
    {
    	$msg = '<h1>Unexpected Sushee error!</h1>'.$e->getMessage();
    	die($mg);
    	//displayErrorPanel($e->getMessage(), 'Unexpected Sushee error!');
    }
    catch (Exception $e)
    {
    	$msg = '<h1>Unexpected error!</h1>'.$e->getMessage();
    	die($msg);
    	//displayErrorPanel($e->getMessage(), 'Unexpected error!');
    }
?>