<?xml version="1.0"?>
<!--

Officity - Web application platform - Version 6.0 - 2011-07-05

François Dispaux, Boris Verdeyen, Thomas Hermant,
Jérémie Roy, Grégory Meurice, Abdelila Harbi, 
Marc Mignonsin, Jonathan Sanchez, Julien Gonzalez, Pierre Fouchez

Sushee and Officity is © Copyright 2011 Nectil SA.

`/var/www/installer/public_html/officity-source/apps/system/tools/field/functions.xsl` is part of Officity.

Sushee is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

Officity and Sushee are distributed in the hope that they will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Sushee. If not, see <http://www.gnu.org/licenses/>.

-->
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0" xmlns:OFFICITY="http://officity.com">
	<xsl:template name="is-sushee-field">
		<xsl:param name="fieldName" />
		<xsl:value-of select="boolean(($fieldName='ID') or
								($fieldName='ACTIVITY') or
								($fieldName='ISLOCKED') or
								($fieldName='CREATORID') or
								($fieldName='OWNERID') or
								($fieldName='GROUPID') or
								($fieldName='MODIFIERID') or
								($fieldName='CREATIONDATE') or
								($fieldName='MODIFICATIONDATE') or
								($fieldName='SEARCHTEXT') or
								($fieldName='CREATOR') or
								($fieldName='MODIFIER') or
								($fieldName='OWNER') or
								($fieldName='OWNERS') or
								($fieldName='GROUPS'))" />
	</xsl:template>
	
	<xsl:template match="FIELD" mode="is-sushee-field">
		<xsl:value-of select="boolean((INFO/DENOMINATION='ID') or
								(INFO/DENOMINATION='ACTIVITY') or
								(INFO/DENOMINATION='ISLOCKED') or
								(INFO/DENOMINATION='CREATORID') or
								(INFO/DENOMINATION='OWNERID') or
								(INFO/DENOMINATION='GROUPID') or
								(INFO/DENOMINATION='MODIFIERID') or
								(INFO/DENOMINATION='CREATIONDATE') or
								(INFO/DENOMINATION='MODIFICATIONDATE') or
								(INFO/DENOMINATION='SEARCHTEXT') or
								(INFO/DENOMINATION='CREATOR') or
								(INFO/DENOMINATION='MODIFIER') or
								(INFO/DENOMINATION='OWNER') or
								(INFO/DENOMINATION='OWNERS') or
								(INFO/DENOMINATION='GROUPS'))" />
	</xsl:template>

	<!-- utils : info inputs names/IDs -->
	<xsl:template name="gen-info-input-name">
		<xsl:param name="moduleName" />
		<xsl:param name="fieldName" />
		<xsl:param name="type" />
		
      	<xsl:text>info-</xsl:text>
        <xsl:call-template name="translate-namespace-name">
    		<xsl:with-param name="name" select="$moduleName"/>
        </xsl:call-template>
      	<xsl:text>-</xsl:text>
        <xsl:call-template name="translate-namespace-name">
    		<xsl:with-param name="name" select="$fieldName"/>
        </xsl:call-template>
        <xsl:if test="$type">
        	<xsl:text>-</xsl:text>
        	<xsl:value-of select="$type" />
        </xsl:if>
	</xsl:template>
	
	<xsl:template match="FIELD" mode="gen-info-input-name">
		<xsl:call-template name="gen-info-input-name">
			<xsl:with-param name="moduleName" select="INFO/MODULE" />
			<xsl:with-param name="fieldName" select="INFO/DENOMINATION" />
			<xsl:with-param name="type" select="INFO/TYPE" />
		</xsl:call-template>
	</xsl:template>
	
	<xsl:template name="gen-info-input-ID">
		<xsl:param name="moduleName" />
		<xsl:param name="fieldName" />
		<xsl:param name="type" />
		
      	<xsl:call-template name="gen-info-input-name">
			<xsl:with-param name="moduleName" select="$moduleName" />
			<xsl:with-param name="fieldName" select="$fieldName"/>
			<xsl:with-param name="type" select="$type"/>
		</xsl:call-template>
       	<xsl:text>-</xsl:text>
       	<xsl:value-of select="$panelID" />
	</xsl:template>
	
	<xsl:template match="FIELD" mode="gen-info-input-ID">
		<xsl:call-template name="gen-info-input-ID">
			<xsl:with-param name="moduleName" select="INFO/MODULE" />
			<xsl:with-param name="fieldName" select="INFO/DENOMINATION" />
			<xsl:with-param name="type" select="INFO/TYPE" />
		</xsl:call-template>
	</xsl:template>
	
	<xsl:template match="INFO/*" mode="gen-info-input-name">
		<xsl:apply-templates select="$fields[INFO/DENOMINATION=name(current())]" mode="gen-info-input-name" />
	</xsl:template>
	
	<xsl:template match="INFO/*" mode="gen-info-input-ID">
		<xsl:apply-templates select="$fields[INFO/DENOMINATION=name(current())]" mode="gen-info-input-ID" />
	</xsl:template>
	
	<!-- utils : categ inputs names/IDs -->
	<xsl:template name="gen-categ-input-name">
		<xsl:param name="moduleName" />
		<xsl:param name="categName" />
		
      	<xsl:text>category-</xsl:text>
        <xsl:call-template name="translate-namespace-name">
    		<xsl:with-param name="name" select="$moduleName"/>
        </xsl:call-template>
      	<xsl:text>-</xsl:text>
       	<xsl:value-of select="$categName" />
	</xsl:template>
	
	<xsl:template name="gen-categ-input-ID">
		<xsl:param name="moduleName" />
		<xsl:param name="categName" />
		
      	<xsl:call-template name="gen-categ-input-name">
			<xsl:with-param name="moduleName" select="$moduleName" />
			<xsl:with-param name="categName" select="$categName"/>
		</xsl:call-template>
       	<xsl:text>-</xsl:text>
       	<xsl:value-of select="$panelID" />
	</xsl:template>
	
	<!-- utils : description inputs names/IDs -->
	<xsl:template name="gen-desc-input-name">
		<xsl:param name="languageID" />
		<xsl:param name="moduleName" />
		<xsl:param name="fieldName" />
		<xsl:param name="type" />
		
      	<xsl:text>description-</xsl:text>
      	<xsl:value-of select="$languageID"/>
      	<xsl:text>-</xsl:text>
        <xsl:call-template name="translate-namespace-name">
    		<xsl:with-param name="name" select="$moduleName"/>
        </xsl:call-template>
      	<xsl:text>-</xsl:text>
        <xsl:value-of select="$fieldName" />
        <xsl:if test="$type">
        	<xsl:text>-</xsl:text>
        	<xsl:value-of select="$type" />
        </xsl:if>
	</xsl:template>
	
	<xsl:template name="gen-desc-input-ID">
		<xsl:param name="languageID" />
		<xsl:param name="moduleName" />
		<xsl:param name="fieldName" />
		<xsl:param name="type" />
		
      	<xsl:call-template name="gen-desc-input-name">
			<xsl:with-param name="languageID" select="$languageID" />
			<xsl:with-param name="moduleName" select="$moduleName"/>
			<xsl:with-param name="fieldName" select="$fieldName"/>
			<xsl:with-param name="type" select="$type"/>
		</xsl:call-template>
       	<xsl:text>-</xsl:text>
       	<xsl:value-of select="$panelID" />
	</xsl:template>
	
	<!-- utils : info inputs names/IDs for elements in dependency -->
	<xsl:template name="gen-dep-input-name">
		<xsl:param name="dependencyType" />
		<xsl:param name="moduleName" />
		<xsl:param name="serviceName" select="'info'" />
		<xsl:param name="fieldName" />
		<xsl:param name="type" />
		
      	<xsl:text>dependency-</xsl:text>
        <xsl:call-template name="replace-string">
            <xsl:with-param name="text" select="$dependencyType"/>
            <xsl:with-param name="from">:</xsl:with-param>
            <xsl:with-param name="to">__</xsl:with-param>
        </xsl:call-template>
      	<xsl:text>-</xsl:text>
        <xsl:call-template name="translate-namespace-name">
    		<xsl:with-param name="name" select="$moduleName"/>
        </xsl:call-template>
      	<xsl:text>-</xsl:text>
        <xsl:value-of select="$serviceName" />
      	<xsl:text>-</xsl:text>
        <xsl:call-template name="translate-namespace-name">
    		<xsl:with-param name="name" select="$fieldName"/>
        </xsl:call-template>
        <xsl:if test="$type">
        	<xsl:text>-</xsl:text>
        	<xsl:value-of select="$type" />
        </xsl:if>
	</xsl:template>
	
	<xsl:template name="gen-dep-input-ID">
		<xsl:param name="dependencyType" />
		<xsl:param name="moduleName" />
		<xsl:param name="serviceName" select="'info'" />
		<xsl:param name="fieldName" />
		<xsl:param name="type" />
		
      	<xsl:call-template name="gen-dep-input-name">
			<xsl:with-param name="dependencyType" select="$dependencyType" />
			<xsl:with-param name="moduleName" select="$moduleName"/>
			<xsl:with-param name="serviceName" select="$serviceName"/>
			<xsl:with-param name="fieldName" select="$fieldName"/>
			<xsl:with-param name="type" select="$type"/>
		</xsl:call-template>
       	<xsl:text>-</xsl:text>
       	<xsl:value-of select="$panelID" />
	</xsl:template>

	<!-- FIELD VALUE (for overviews tabs) -->
    <xsl:template name="field-value">
        <xsl:param name="field" />
        <xsl:param name="node" />

        <xsl:choose>
        	<xsl:when test="$field/INFO/DENOMINATION='CREATORID' and $item">
        		<xsl:value-of select="$node" />
        		<xsl:text> (</xsl:text>
        		<xsl:apply-templates select="$item/INFO/CREATOR/*" mode="element-label"/>
        		<xsl:text>)</xsl:text>
        	</xsl:when>
        	<xsl:when test="$field/INFO/DENOMINATION='MODIFIERID' and $item">
        		<xsl:value-of select="$node" />
        		<xsl:text> (</xsl:text>
        		<xsl:apply-templates select="$item/INFO/MODIFIER/*" mode="element-label"/>
        		<xsl:text>)</xsl:text>
        	</xsl:when>
        	<xsl:when test="$field/INFO/DENOMINATION='OWNERID' and $item">
        		<xsl:value-of select="$node" />
        		<xsl:text> (</xsl:text>
        		<xsl:apply-templates select="$item/INFO/OWNER/*" mode="element-label"/>
        		<xsl:text>)</xsl:text>
        	</xsl:when>
            <xsl:when test="$field/INFO/TYPE='list'">
                <xsl:variable name="list" select="/RESPONSE/RESULTS/LIST[@name=$field/INFO/LISTNAME]"/>
                <xsl:value-of select="$list/*[@value=$node/text()]/@label"/>
            </xsl:when>
            <xsl:when test="$field/INFO/TYPE='systemList'">
                <xsl:variable name="list" select="/RESPONSE/RESULTS[@name=$field/INFO/LISTNAME]"/>
                <xsl:value-of select="$list/*[@ID=$node/text()]/LABEL"/>
            </xsl:when>
            <xsl:when test="$field/INFO/TYPE='date'">
                <xsl:apply-templates select="$node" mode="date"/>
            </xsl:when>
            <xsl:when test="$field/INFO/TYPE='datetime'">
                <xsl:apply-templates select="$node" mode="datetime"/>
            </xsl:when>
            <xsl:when test="$field/INFO/TYPE='boolean'">
                <xsl:choose>
                    <xsl:when test="$node/text()='1'">
                        <xsl:text>Yes</xsl:text>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:text>No</xsl:text>
                    </xsl:otherwise>
                </xsl:choose>
            </xsl:when>
            <xsl:when test="contains($field/INFO/DENOMINATION, 'XML') or 
            				$field/INFO/DENOMINATION = 'OWNERS' or 
            				$field/INFO/DENOMINATION = 'GROUPS' or 
            				contains($field/INFO/DENOMINATION, 'SECURITYTEMPLATE') or 
            				contains($field/INFO/DENOMINATION, 'PROFILE') or 
            				contains($field/INFO/DENOMINATION, 'PERMISSION') or
            				contains($field/INFO/DENOMINATION, 'RESPONSE') or
            				contains($field/INFO/DENOMINATION, 'COMMAND') or
            				contains($field/INFO/DENOMINATION, 'CALLBACK') or 
            				contains($field/INFO/DENOMINATION, 'FIELDS') or
            				contains($field/INFO/DENOMINATION, 'DEPENDENC') or
            				contains($field/INFO/DENOMINATION, 'SERVICE') or
            				contains($field/INFO/DENOMINATION, 'CONFIG')">
                <!--a href="#" class="view" title="View XML" onclick="$('#{$panelID}.panel').find('#fieldxml-{$field/@ID}').show(); $(this).hide();" />
                <textarea id="fieldxml-{$field/@ID}" class="input-textarea" style="overflow-y:auto !important; display:none; width:100%; height:80px;">
                    <xsl:copy-of select="$node/*" />
                </textarea-->
                <xsl:apply-templates select="$node/*" mode="display-xml" />
            </xsl:when>
            <xsl:when test="contains($field/INFO/DENOMINATION, 'TEXT') or 
            				contains($field/INFO/DENOMINATION, 'BODY') or  
            				contains($field/INFO/DENOMINATION, 'SIGNATURE') or  
            				contains($field/INFO/DENOMINATION, 'DESCRIPTION')">
                <a href="#" class="view" title="View full text" onclick="$('#{$panelID}.panel').find('#fieldtext-{$field/@ID}').show(); $(this).hide();" />
                <span id="fieldtext-{$field/@ID}" style="display:none; width:100%; height:80px;">
                    <xsl:apply-templates select="$node" />
                </span>
            </xsl:when>
            <xsl:when test="($field/INFO/TYPE='file') or 
            				($field/INFO/DENOMINATION='PREVIEW')">
                <a href="#" title="{$node}">
                    <xsl:attribute name="onclick">
                        <xsl:text>window.location.replace('</xsl:text>
                        <xsl:value-of select="$systemToolsURL"/>
                        <xsl:text>file_download.php?target=</xsl:text>
                        <xsl:value-of select="$node"/>
                        <xsl:text>');</xsl:text>
                    </xsl:attribute>
					<xsl:text>View/Download</xsl:text>
                </a>
            </xsl:when>
            <xsl:when test="($field/INFO/DENOMINATION!='EMAILINVALID') and 
            					($field/INFO/DENOMINATION!='EMAILPACKET') and 
            					contains($field/INFO/DENOMINATION, 'EMAIL')">
                <a href="mailto:{$node}" title="Send an e-mail">
                     <xsl:value-of select="$node"/>
                 </a>
            </xsl:when>
            <xsl:when test="(contains($field/INFO/DENOMINATION, 'WEBSITE') or 
            					contains($field/INFO/DENOMINATION, 'URL') or 
            					contains($field/INFO/DENOMINATION, 'URI')) and 
            				($field/INFO/DENOMINATION!='MAILINGCURINTERVAL')">
                <a href="{$node}" title="Visit" target="_blank">
                     <xsl:value-of select="$node"/>
                 </a>
            </xsl:when>
			<xsl:when test="count($node/*) &gt; 1">
				<xsl:apply-templates select="$node" mode="multiline"/>
			</xsl:when>
            <xsl:otherwise>
                <xsl:value-of select="$node"/>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>

	<!-- FIELD INPUT : info -->
    <xsl:template name="field-input">
        <xsl:param name="field" />
        <xsl:param name="type" select="$field/INFO/TYPE"/>
        <xsl:param name="node" />
        <xsl:param name="inputValue" />
        <xsl:param name="inputID">
	      	<xsl:call-template name="gen-info-input-ID">
				<xsl:with-param name="moduleName" select="$field/INFO/MODULE" />
				<xsl:with-param name="fieldName" select="$field/INFO/DENOMINATION"/>
				<xsl:with-param name="type" select="$type" />
	      	</xsl:call-template>
        </xsl:param>
        <xsl:param name="inputName">
	      	<xsl:call-template name="gen-info-input-name">
				<xsl:with-param name="moduleName" select="$field/INFO/MODULE" />
				<xsl:with-param name="fieldName" select="$field/INFO/DENOMINATION"/>
				<xsl:with-param name="type" select="$type" />
	      	</xsl:call-template>
        </xsl:param>
        <xsl:param name="defaultOption" select="'(Choose an option)'" />
        <xsl:param name="cssclass" />
        <xsl:param name="required" select="false()" />
        
        <xsl:variable name="requiredclass">
        	<xsl:if test="$required=true()">
       			<xsl:text>required</xsl:text>
     		</xsl:if>
        </xsl:variable>        
        
        <xsl:variable name="value">
        	<xsl:choose>
				<xsl:when test="$inputValue">
					<xsl:copy-of select="$inputValue" />
				</xsl:when>
				<xsl:otherwise>
					<xsl:copy-of select="$node" />
				</xsl:otherwise>
			</xsl:choose>
        </xsl:variable>

        <xsl:choose>
            <xsl:when test="$type='list'">
                <select id="{$inputID}" name="{$inputName}" class="input-select {$cssclass} {$requiredclass}">
                    <option value="">
                        <xsl:value-of select="$defaultOption" />
                    </option>
                    <xsl:for-each select="/RESPONSE/RESULTS/LIST[@name=$field/INFO/LISTNAME]/*">
                        <xsl:sort select="@label" />
                        <option value="{@value}">
                            <xsl:if test="$value = @value">
                                <xsl:attribute name="selected">selected</xsl:attribute>
                            </xsl:if>
                            <xsl:value-of select="@label"/>
                        </option>
                    </xsl:for-each>
                </select>
            </xsl:when>
            <xsl:when test="$type='systemList'">
                <select id="{$inputID}" name="{$inputName}" class="input-select {$cssclass} {$requiredclass}">
                    <option value="">
                        <xsl:value-of select="$defaultOption" />
                    </option>
                    <xsl:for-each select="/RESPONSE/RESULTS[@name=$field/INFO/LISTNAME]/*">
                        <xsl:sort select="LABEL" />
                        <option value="{@ID}">
                            <xsl:if test="$value = @ID">
                                <xsl:attribute name="selected">selected</xsl:attribute>
                            </xsl:if>
                            <xsl:value-of select="LABEL"/>
                        </option>
                    </xsl:for-each>
                </select>
            </xsl:when>
            <xsl:when test="$type='date'">
                <input type="text" id="{$inputID}" name="{$inputName}" class="input-date {$cssclass} {$requiredclass}">
                    <xsl:attribute name="value">
                        <xsl:call-template name="format-date">
                        	<xsl:with-param name="rawdate" select="$value" />
                        </xsl:call-template>
                    </xsl:attribute>
                </input>
            </xsl:when>
            <xsl:when test="$type='datetime'">
                <input type="text" id="{$inputID}" name="{$inputName}" class="input-date {$cssclass} {$requiredclass}">
                    <xsl:attribute name="value">
                        <xsl:call-template name="format-datetime">
                        	<xsl:with-param name="rawdate" select="$value" />
                        </xsl:call-template>
                    </xsl:attribute>
                </input>
            </xsl:when>
            <xsl:when test="$type='boolean'">
                <input type="checkbox" id="{$inputID}" name="{$inputName}" value="1" class="input-checkbox {$cssclass} {$requiredclass}">
                    <xsl:if test="$value = 1">
                        <xsl:attribute name="checked">checked</xsl:attribute>
                    </xsl:if>
                </input>
            </xsl:when>
            <xsl:when test="$type='file'">
                <input type="file" id="{$inputID}" name="{$inputName}" class="input-file {$cssclass} {$requiredclass}" />
                <br /><br />
                <a href="#" title="{$node}">
                    <xsl:attribute name="onclick">
                        <xsl:text>window.location.replace('</xsl:text>
                        <xsl:value-of select="$systemToolsURL"/>
                        <xsl:text>file_download.php?target=</xsl:text>
                        <xsl:value-of select="$node"/>
                        <xsl:text>');</xsl:text>
                    </xsl:attribute>
                    <xsl:text>View/Download</xsl:text>
                </a>
            </xsl:when>
            <xsl:when test="$type='textarea'">
               <textarea id="{$inputID}" name="{$inputName}" class="input-textarea {$cssclass} {$requiredclass}">
                   <xsl:value-of select="$value" />
               </textarea>
            </xsl:when>
            <xsl:when test="$type='styled'">
               <textarea id="{$inputID}" name="{$inputName}" class="input-textarea {$cssclass} {$requiredclass}">
		        	<xsl:choose>
						<xsl:when test="$inputValue">
							<xsl:apply-templates select="$inputValue" />
						</xsl:when>
						<xsl:otherwise>
							<xsl:apply-templates select="$node" />
						</xsl:otherwise>
					</xsl:choose>
               </textarea>
            </xsl:when>
            <xsl:when test="($field/INFO/DENOMINATION='SEARCHTEXT') or 
            				($field/INFO/DENOMINATION='DESCRIPTION') or 
            				($field/INFO/DENOMINATION='NOTES')">
               <textarea id="{$inputID}" name="{$inputName}" class="input-textarea {$cssclass} {$requiredclass}">
                   <xsl:value-of select="$value" />
               </textarea>
            </xsl:when>
            <xsl:when test="($type='xml') or
            				contains($field/INFO/DENOMINATION, 'XML') or 
            				$field/INFO/DENOMINATION = 'OWNERS' or 
            				$field/INFO/DENOMINATION = 'GROUPS' or 
            				contains($field/INFO/DENOMINATION, 'TEXT') or 
            				contains($field/INFO/DENOMINATION, 'COMMENT') or 
            				contains($field/INFO/DENOMINATION, 'SIGNATURE') or 
            				contains($field/INFO/DENOMINATION, 'BODY') or 
            				contains($field/INFO/DENOMINATION, 'NOTE') or 
            				contains($field/INFO/DENOMINATION, 'SECURITYTEMPLATE') or 
            				contains($field/INFO/DENOMINATION, 'PROFILE') or 
            				contains($field/INFO/DENOMINATION, 'PERMISSION') or
            				contains($field/INFO/DENOMINATION, 'RESPONSE') or
            				contains($field/INFO/DENOMINATION, 'COMMAND') or
            				contains($field/INFO/DENOMINATION, 'CALLBACK') or
            				contains($field/INFO/DENOMINATION, 'FIELDS') or
            				contains($field/INFO/DENOMINATION, 'DEPENDENC') or
            				contains($field/INFO/DENOMINATION, 'SERVICE') or
            				contains($field/INFO/DENOMINATION, 'CONFIG')">
               <textarea id="{$inputID}" name="{$inputName}" class="input-textarea {$cssclass} {$requiredclass}">
		        	<!--xsl:choose>
						<xsl:when test="$inputValue">
							<xsl:copy-of select="$inputValue" />
						</xsl:when>
						<xsl:otherwise-->
							<xsl:apply-templates select="$node/*" mode="strip-xml-namespaces" />
						<!--/xsl:otherwise>
					</xsl:choose-->
               </textarea>
            </xsl:when>
            <xsl:otherwise>
                <input type="text" id="{$inputID}" name="{$inputName}" class="input-text {$cssclass} {$requiredclass}">
                    <xsl:attribute name="value">
                        <xsl:value-of select="$value" />
                    </xsl:attribute>
                </input>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    
	<!-- FIELD INPUT : category -->
    <xsl:template name="categ-input">
        <xsl:param name="moduleName" />
        <xsl:param name="elementCategsNode" />
        <xsl:param name="categoryNode" />
        <xsl:param name="checked" select="boolean($elementCategsNode/CATEGORY[@ID=$categoryNode/@ID])" />
        <xsl:param name="inputName">
	      	<xsl:call-template name="gen-categ-input-name">
				<xsl:with-param name="moduleName" select="$moduleName" />
				<xsl:with-param name="categName" select="$categoryNode/UNIQUENAME"/>
	      	</xsl:call-template>
        </xsl:param>
        <xsl:param name="inputID">
	      	<xsl:call-template name="gen-categ-input-ID">
				<xsl:with-param name="moduleName" select="$moduleName" />
				<xsl:with-param name="categName" select="$categoryNode/UNIQUENAME"/>
	      	</xsl:call-template>
        </xsl:param>
        <xsl:param name="cssclass" />    

        <input type="checkbox" id="{$inputID}" name="{$inputName}" value="1" class="input-checkbox {$cssclass}">
            <xsl:if test="$checked = true()">
                <xsl:attribute name="checked">checked</xsl:attribute>
            </xsl:if>
        </input>
    </xsl:template>
    
    <!-- FIELD INPUT : description -->
     <xsl:template name="desc-field-input">	      
		<xsl:param name="node" />
		<xsl:param name="inputValue" />
		<xsl:param name="moduleName" />
		<xsl:param name="fieldName" />
		<xsl:param name="type" select="'textarea'" />
		<xsl:param name="languageID" select="$node/parent::DESCRIPTION/@languageID" />
	   	<xsl:param name="cssclass" />
	  	<xsl:param name="required" select="false()" />
		  
		<xsl:variable name="requiredclass">
			<xsl:if test="$required=true()">
				<xsl:text>required</xsl:text>
			</xsl:if>
		</xsl:variable>
		     
		<xsl:variable name="inputID">
			<xsl:call-template name="gen-desc-input-ID">
				<xsl:with-param name="languageID" select="$languageID" />
				<xsl:with-param name="moduleName">
					<xsl:choose>
						<xsl:when test="$node">
							<xsl:value-of
								select="name($node/parent::DESCRIPTION/parent::DESCRIPTIONS/parent::*[1])" />
						</xsl:when>
						<xsl:otherwise>
							<xsl:value-of select="$moduleName" />
						</xsl:otherwise>
					</xsl:choose>
				</xsl:with-param>
				<xsl:with-param name="fieldName">
					<xsl:choose>
						<xsl:when test="$node">
							<xsl:value-of select="name($node)" />
						</xsl:when>
						<xsl:otherwise>
							<xsl:value-of select="$fieldName" />
						</xsl:otherwise>
					</xsl:choose>
				</xsl:with-param>
				<xsl:with-param name="type" select="$type" />
			</xsl:call-template>
		</xsl:variable>
		<xsl:variable name="inputName">
			<xsl:call-template name="gen-desc-input-name">
				<xsl:with-param name="languageID" select="$languageID" />
				<xsl:with-param name="moduleName">
					<xsl:choose>
						<xsl:when test="$node">
							<xsl:value-of
								select="name($node/parent::DESCRIPTION/parent::DESCRIPTIONS/parent::*[1])" />
						</xsl:when>
						<xsl:otherwise>
							<xsl:value-of select="$moduleName" />
						</xsl:otherwise>
					</xsl:choose>
				</xsl:with-param>
				<xsl:with-param name="fieldName">
					<xsl:choose>
						<xsl:when test="$node">
							<xsl:value-of select="name($node)" />
						</xsl:when>
						<xsl:otherwise>
							<xsl:value-of select="$fieldName" />
						</xsl:otherwise>
					</xsl:choose>
				</xsl:with-param>
				<xsl:with-param name="type" select="$type" />
			</xsl:call-template>
		</xsl:variable>

		<xsl:choose>
            <xsl:when test="$type='file'">
                <input type="file" id="{$inputID}" name="{$inputName}" class="input-file {$cssclass} {$requiredclass}" />
            </xsl:when>
			<xsl:when test="$type='styled'">
				<textarea id="{$inputID}" name="{$inputName}" class="input-textarea {$cssclass} {$requiredclass}">
		        	<xsl:choose>
						<xsl:when test="$inputValue">
							<xsl:apply-templates select="$inputValue" />
						</xsl:when>
						<xsl:when test="$node">
							<xsl:apply-templates select="$node" />
						</xsl:when>
					</xsl:choose>
				</textarea>
			</xsl:when>
			<xsl:when test="$type='textarea'">
				<textarea id="{$inputID}" name="{$inputName}" class="input-textarea {$cssclass} {$requiredclass}">
		        	<xsl:choose>
						<xsl:when test="$inputValue">
							<xsl:copy-of select="$inputValue" />
						</xsl:when>
						<xsl:when test="$node">
							<xsl:copy-of select="$node/node()" />
						</xsl:when>
					</xsl:choose>
				</textarea>
			</xsl:when>
			<xsl:otherwise>
                <input type="text" id="{$inputID}" name="{$inputName}" class="input-text {$cssclass} {$requiredclass}">
                    <xsl:attribute name="value">
			        	<xsl:choose>
							<xsl:when test="$inputValue">
								<xsl:value-of select="$inputValue" />
							</xsl:when>
							<xsl:when test="$node">
								<xsl:value-of select="$node" />
							</xsl:when>
						</xsl:choose>
                    </xsl:attribute>
                </input>
			</xsl:otherwise>
		</xsl:choose>	      
   	</xsl:template>
   	
    <!--                         -->
    <!-- FORMS INPUTS GENERATION -->
    <!--                         -->

    <xsl:template name="form-input-text">
        <xsl:param name="node" select="." />
        <xsl:param name="inputValue" />       
		<xsl:param name="moduleName" select="name($node/parent::node()/parent::node())" />
		<xsl:param name="fieldName" select="name($node)"/>
        <xsl:param name="inputID">
	      	<xsl:call-template name="gen-info-input-ID">
				<xsl:with-param name="moduleName" select="$moduleName" />
				<xsl:with-param name="fieldName" select="$fieldName"/>
				<xsl:with-param name="type" select="'text'" />
	      	</xsl:call-template>
        </xsl:param>
        <xsl:param name="inputName">
	      	<xsl:call-template name="gen-info-input-name">
				<xsl:with-param name="moduleName" select="$moduleName" />
				<xsl:with-param name="fieldName" select="$fieldName"/>
				<xsl:with-param name="type" select="'text'" />
	      	</xsl:call-template>
        </xsl:param>
         <xsl:param name="cssclass" />
        <xsl:param name="required" select="false()" />
        
        <xsl:variable name="requiredclass">
        	<xsl:if test="$required=true()">
       			<xsl:text>required</xsl:text>
     		</xsl:if>
        </xsl:variable> 
        <xsl:variable name="value">
        	<xsl:choose>
				<xsl:when test="$inputValue">
					<xsl:copy-of select="$inputValue" />
				</xsl:when>
				<xsl:otherwise>
					<xsl:copy-of select="$node" />
				</xsl:otherwise>
			</xsl:choose>
        </xsl:variable>

        <input type="text" class="input-text {$cssclass} {$requiredclass}" id="{$inputID}" name="{$inputName}">
            <xsl:attribute name="value">
                <xsl:value-of select="$value" />
            </xsl:attribute>
        </input>
    </xsl:template>

    <xsl:template name="form-input-textarea">
        <xsl:param name="node" select="." /> 
        <xsl:param name="inputValue" />       
		<xsl:param name="moduleName" select="name($node/parent::node()/parent::node())" />
		<xsl:param name="fieldName" select="name($node)"/>
        <xsl:param name="inputID">
	      	<xsl:call-template name="gen-info-input-ID">
				<xsl:with-param name="moduleName" select="$moduleName" />
				<xsl:with-param name="fieldName" select="$fieldName"/>
				<xsl:with-param name="type">
					<xsl:choose>
						<xsl:when test="contains($fieldName, 'XML')">
							<xsl:text>xml</xsl:text>
						</xsl:when>
						<xsl:otherwise>
							<xsl:text>textarea</xsl:text>
						</xsl:otherwise>
					</xsl:choose>
				</xsl:with-param>
	      	</xsl:call-template>
        </xsl:param>
        <xsl:param name="inputName">
	      	<xsl:call-template name="gen-info-input-name">
				<xsl:with-param name="moduleName" select="$moduleName" />
				<xsl:with-param name="fieldName" select="$fieldName"/>
				<xsl:with-param name="type">
					<xsl:choose>
						<xsl:when test="contains($fieldName, 'XML')">
							<xsl:text>xml</xsl:text>
						</xsl:when>
						<xsl:otherwise>
							<xsl:text>textarea</xsl:text>
						</xsl:otherwise>
					</xsl:choose>
				</xsl:with-param>
	      	</xsl:call-template>
        </xsl:param>
        <xsl:param name="cssclass" />
        <xsl:param name="required" select="false()" />
        
        <xsl:variable name="requiredclass">
        	<xsl:if test="$required=true()">
       			<xsl:text>required</xsl:text>
     		</xsl:if>
        </xsl:variable> 
        <xsl:variable name="value">
        	<xsl:choose>
				<xsl:when test="$inputValue">
					<xsl:copy-of select="$inputValue" />
				</xsl:when>
				<xsl:otherwise>
					<xsl:copy-of select="$node" />
				</xsl:otherwise>
			</xsl:choose>
        </xsl:variable>

        <textarea class="input-textarea {$cssclass} {$requiredclass}" id="{$inputID}" name="{$inputName}">
            <xsl:value-of select="$node"/>
       </textarea>
    </xsl:template>

    <xsl:template name="form-input-date">
        <xsl:param name="node" select="." /> 
        <xsl:param name="inputValue" />       
		<xsl:param name="moduleName" select="name($node/parent::node()/parent::node())" />
		<xsl:param name="fieldName" select="name($node)"/>
        <xsl:param name="inputID">
	      	<xsl:call-template name="gen-info-input-ID">
				<xsl:with-param name="moduleName" select="$moduleName" />
				<xsl:with-param name="fieldName" select="$fieldName"/>
				<xsl:with-param name="type" select="'date'" />
	      	</xsl:call-template>
        </xsl:param>
        <xsl:param name="inputName">
	      	<xsl:call-template name="gen-info-input-name">
				<xsl:with-param name="moduleName" select="$moduleName" />
				<xsl:with-param name="fieldName" select="$fieldName"/>
				<xsl:with-param name="type" select="'date'" />
	      	</xsl:call-template>
        </xsl:param>
        <xsl:param name="cssclass" />
        <xsl:param name="required" select="false()" />
        
        <xsl:variable name="requiredclass">
        	<xsl:if test="$required=true()">
       			<xsl:text>required</xsl:text>
     		</xsl:if>
        </xsl:variable> 
        <xsl:variable name="value">
        	<xsl:choose>
				<xsl:when test="$inputValue">
					<xsl:value-of select="$inputValue" />
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="$node" />
				</xsl:otherwise>
			</xsl:choose>
        </xsl:variable>

        <input type="text" class="input-date {$cssclass} {$requiredclass}" id="{$inputID}" name="{$inputName}">
            <xsl:attribute name="value">
                <xsl:apply-templates select="$value" mode="date"/>
            </xsl:attribute>
        </input>
    </xsl:template>

    <xsl:template name="form-input-file">
        <xsl:param name="node" select="." />      
		<xsl:param name="moduleName" select="name($node/parent::node()/parent::node())" />
		<xsl:param name="fieldName" select="name($node)"/>
        <xsl:param name="inputID">
	      	<xsl:call-template name="gen-info-input-ID">
				<xsl:with-param name="moduleName" select="$moduleName" />
				<xsl:with-param name="fieldName" select="$fieldName"/>
				<xsl:with-param name="type" select="'file'" />
	      	</xsl:call-template>
        </xsl:param>
        <xsl:param name="inputName">
	      	<xsl:call-template name="gen-info-input-name">
				<xsl:with-param name="moduleName" select="$moduleName" />
				<xsl:with-param name="fieldName" select="$fieldName"/>
				<xsl:with-param name="type" select="'file'" />
	      	</xsl:call-template>
        </xsl:param>
        <xsl:param name="cssclass" />
        <xsl:param name="required" select="false()" />
        
        <xsl:variable name="requiredclass">
        	<xsl:if test="$required=true()">
       			<xsl:text>required</xsl:text>
     		</xsl:if>
        </xsl:variable> 

        <input type="file" class="input-file {$cssclass} {$requiredclass}" id="{$inputID}" name="{$inputName}" />
    </xsl:template>

    <xsl:template name="form-input-check">
        <xsl:param name="node" select="." /> 
        <xsl:param name="inputValue" />       
		<xsl:param name="moduleName" select="name($node/parent::node()/parent::node())" />
		<xsl:param name="fieldName" select="name($node)"/>
        <xsl:param name="inputID">
	      	<xsl:call-template name="gen-info-input-ID">
				<xsl:with-param name="moduleName" select="$moduleName" />
				<xsl:with-param name="fieldName" select="$fieldName"/>
				<xsl:with-param name="type" select="'check'" />
	      	</xsl:call-template>
        </xsl:param>
        <xsl:param name="inputName">
	      	<xsl:call-template name="gen-info-input-name">
				<xsl:with-param name="moduleName" select="$moduleName" />
				<xsl:with-param name="fieldName" select="$fieldName"/>
				<xsl:with-param name="type" select="'check'" />
	      	</xsl:call-template>
        </xsl:param>
        <xsl:param name="cssclass" />
        <xsl:param name="required" select="false()" />
        
        <xsl:variable name="requiredclass">
        	<xsl:if test="$required=true()">
       			<xsl:text>required</xsl:text>
     		</xsl:if>
        </xsl:variable> 
        <xsl:variable name="value">
        	<xsl:choose>
				<xsl:when test="$inputValue">
					<xsl:value-of select="$inputValue" />
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="$node" />
				</xsl:otherwise>
			</xsl:choose>
        </xsl:variable>

        <input type="checkbox" class="input-checkbox {$cssclass} {$requiredclass}" id="{$inputID}" name="{$inputName}" value="1">
            <xsl:if test="$value = 1">
                <xsl:attribute name="checked">checked</xsl:attribute>
            </xsl:if>
        </input>
    </xsl:template>

    <xsl:template name="form-input-select-list">
        <xsl:param name="node" select="." />
        <xsl:param name="listname" />
        <xsl:param name="defaultOption" select="'(Choose an option)'" />
        <xsl:param name="inputValue" />      
		<xsl:param name="moduleName" select="name($node/parent::node()/parent::node())" />
		<xsl:param name="fieldName" select="name($node)"/>
        <xsl:param name="inputID">
	      	<xsl:call-template name="gen-info-input-ID">
				<xsl:with-param name="moduleName" select="$moduleName" />
				<xsl:with-param name="fieldName" select="$fieldName"/>
				<xsl:with-param name="type" select="'list'" />
	      	</xsl:call-template>
        </xsl:param>
        <xsl:param name="inputName">
	      	<xsl:call-template name="gen-info-input-name">
				<xsl:with-param name="moduleName" select="$moduleName" />
				<xsl:with-param name="fieldName" select="$fieldName"/>
				<xsl:with-param name="type" select="'list'" />
	      	</xsl:call-template>
        </xsl:param>
        <xsl:param name="cssclass" />
        <xsl:param name="required" select="false()" />
        <xsl:param name="sort" select="'label'" />
        
        <xsl:variable name="requiredclass">
        	<xsl:if test="$required=true()">
       			<xsl:text>required</xsl:text>
     		</xsl:if>
        </xsl:variable> 
        <xsl:variable name="value">
        	<xsl:choose>
				<xsl:when test="$inputValue">
					<xsl:value-of select="$inputValue" />
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="$node" />
				</xsl:otherwise>
			</xsl:choose>
        </xsl:variable>

        <select class="input-select {$cssclass} {$requiredclass}" id="{$inputID}" name="{$inputName}">
            <option value="">
                <xsl:value-of select="$defaultOption" />
            </option>
            <xsl:choose>
            	<xsl:when test="$sort='label'">
		            <xsl:for-each select="/RESPONSE/RESULTS/LIST[@name=$listname]/ITEM">
		                <xsl:sort select="@label" />
		                <option value="{@value}">
		                    <xsl:if test="$value = @value">
		                        <xsl:attribute name="selected">selected</xsl:attribute>
		                    </xsl:if>
		                    <xsl:value-of select="@label"/>
		                </option>
		            </xsl:for-each>
	            </xsl:when>
	            <xsl:otherwise>
		            <xsl:for-each select="/RESPONSE/RESULTS/LIST[@name=$listname]/ITEM">
		                <xsl:sort select="@value" />
		                <option value="{@value}">
		                    <xsl:if test="$value = @value">
		                        <xsl:attribute name="selected">selected</xsl:attribute>
		                    </xsl:if>
		                    <xsl:value-of select="@label"/>
		                </option>
		            </xsl:for-each>
	            </xsl:otherwise>
            </xsl:choose>
        </select>
    </xsl:template>

    <xsl:template name="form-input-select-systemlist">
        <xsl:param name="node" select="." />        
        <xsl:param name="listname" />
        <xsl:param name="defaultOption" select="'(Choose an option)'" />
        <xsl:param name="inputValue" />
		<xsl:param name="moduleName" select="name($node/parent::node()/parent::node())" />
		<xsl:param name="fieldName" select="name($node)"/>
        <xsl:param name="inputID">
	      	<xsl:call-template name="gen-info-input-ID">
				<xsl:with-param name="moduleName" select="$moduleName" />
				<xsl:with-param name="fieldName" select="$fieldName"/>
				<xsl:with-param name="type" select="'systemlist'" />
	      	</xsl:call-template>
        </xsl:param>
        <xsl:param name="inputName">
	      	<xsl:call-template name="gen-info-input-name">
				<xsl:with-param name="moduleName" select="$moduleName" />
				<xsl:with-param name="fieldName" select="$fieldName"/>
				<xsl:with-param name="type" select="'systemlist'" />
	      	</xsl:call-template>
        </xsl:param>
        <xsl:param name="cssclass" />
        <xsl:param name="required" select="false()" />
        <xsl:param name="sort" select="'label'" />
        
        <xsl:variable name="requiredclass">
        	<xsl:if test="$required=true()">
       			<xsl:text>required</xsl:text>
     		</xsl:if>
        </xsl:variable> 
        <xsl:variable name="value">
        	<xsl:choose>
				<xsl:when test="$inputValue">
					<xsl:value-of select="$inputValue" />
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="$node" />
				</xsl:otherwise>
			</xsl:choose>
        </xsl:variable>

        <select class="input-select {$cssclass} {$requiredclass}" id="{$inputID}" name="{$inputName}">
            <option value="">
                <xsl:value-of select="$defaultOption" />
            </option>
             <xsl:choose>
            	<xsl:when test="$sort='label'">
		            <xsl:for-each select="/RESPONSE/RESULTS[@name=$listname]/*">
		                <xsl:sort select="LABEL"/>
		                <option value="{@ID}">
		                    <xsl:if test="$value = @ID">
		                        <xsl:attribute name="selected">selected</xsl:attribute>
		                    </xsl:if>
		                    <xsl:value-of select="LABEL"/>
		                </option>
		            </xsl:for-each>
	            </xsl:when>
	            <xsl:otherwise>
		            <xsl:for-each select="/RESPONSE/RESULTS[@name=$listname]/*">
		                <xsl:sort select="@ID"/>
		                <option value="{@ID}">
		                    <xsl:if test="$value = @ID">
		                        <xsl:attribute name="selected">selected</xsl:attribute>
		                    </xsl:if>
		                    <xsl:value-of select="LABEL"/>
		                </option>
		            </xsl:for-each>
	            </xsl:otherwise>
            </xsl:choose>
        </select>
    </xsl:template>
</xsl:stylesheet>