<?xml version="1.0"?>
<!--

Officity - Web application platform - Version 6.0 - 2011-07-05

François Dispaux, Boris Verdeyen, Thomas Hermant,
Jérémie Roy, Grégory Meurice, Abdelila Harbi, 
Marc Mignonsin, Jonathan Sanchez, Julien Gonzalez, Pierre Fouchez

Sushee and Officity is © Copyright 2011 Nectil SA.

`/var/www/installer/public_html/officity-source/apps/system/tools/file/Folder.xsl` is part of Officity.

Sushee is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

Officity and Sushee are distributed in the hope that they will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Sushee. If not, see <http://www.gnu.org/licenses/>.

-->
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0" xmlns:OFFICITY="http://officity.com">
    <xsl:import href="include.xsl"/>
    <xsl:output encoding="UTF-8" method="xml" indent="no"/>
    <xsl:strip-space elements="*"/>

	<!-- parameters -->
    <xsl:param name="list" select="/RESPONSE/TREE[@name='list']"/>

	<xsl:template match="/RESPONSE">
    	<xsl:call-template name="panel-navigation" />
    </xsl:template>
    
    <xsl:template name="panel-title">
		<xsl:call-template name="truncate-phrase">
			<xsl:with-param name="phrase">
                <xsl:choose>
                    <xsl:when test="/RESPONSE/URL/name/text()">
                        <xsl:value-of select="/RESPONSE/URL/name"/>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:text>/Files</xsl:text>
                        <xsl:value-of select="/RESPONSE/URL/path"/>
                    </xsl:otherwise>
                </xsl:choose>
			</xsl:with-param>
		</xsl:call-template>
    </xsl:template> 

	<xsl:template name="panel-body-navigation">
	    <xsl:choose>
	       <xsl:when test="count($list/*[INFO/PATH]) > 0">
	           <xsl:choose>
	               <xsl:when test="/RESPONSE/URL/sort='date'">
	                   <xsl:for-each select="$list/*[INFO/PATH]">
	                       <xsl:sort select="@modificationDate" data-type="text" order="descending"/>
	                       <xsl:apply-templates select="." mode="element-navitem"/>
	                   </xsl:for-each>
	               </xsl:when>
	               <xsl:otherwise>
	                   <xsl:for-each select="$list/*[INFO/PATH]">
	                       <xsl:sort select="name()" data-type="text" order="ascending"/>
	                       <xsl:sort select="INFO/NAME" data-type="text" order="ascending"/>
	                       <xsl:apply-templates select="." mode="element-navitem"/>
	                   </xsl:for-each>                                
	               </xsl:otherwise>
	           </xsl:choose>
	       </xsl:when>
	       <xsl:otherwise>
	           <div class="no-result">No files</div>
	       </xsl:otherwise>
	   </xsl:choose>
	</xsl:template>
</xsl:stylesheet>
