<?xml version="1.0"?>
<!--

Officity - Web application platform - Version 6.0 - 2011-07-05

François Dispaux, Boris Verdeyen, Thomas Hermant,
Jérémie Roy, Grégory Meurice, Abdelila Harbi, 
Marc Mignonsin, Jonathan Sanchez, Julien Gonzalez, Pierre Fouchez

Sushee and Officity is © Copyright 2011 Nectil SA.

`/var/www/installer/public_html/officity-source/apps/system/tools/list/New.xsl` is part of Officity.

Sushee is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

Officity and Sushee are distributed in the hope that they will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Sushee. If not, see <http://www.gnu.org/licenses/>.

-->
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
    <xsl:import href="include.xsl"/>    
    <xsl:output encoding="UTF-8" method="xml" indent="no"/>
    <xsl:strip-space elements="*"/>

	<!-- parameters -->
	<xsl:param name="domain" select="/RESPONSE/URL/domain" />
	<xsl:param name="list" select="/RESPONSE/URL/list" />
	<xsl:param name="label" select="/RESPONSE/URL/label" />
	<xsl:param name="value" select="/RESPONSE/URL/value" />
	<xsl:param name="languageID" select="/RESPONSE/URL/languageID" />

    <xsl:param name="tabsID">
        <xsl:text>tabs-details-</xsl:text><xsl:value-of select="$panelID"/>
    </xsl:param>
    <xsl:param name="labvalFormID">
        <xsl:text>form-labval-</xsl:text><xsl:value-of select="$panelID"/>
    </xsl:param>
    <xsl:param name="CSVFormID">
        <xsl:text>form-csv-</xsl:text><xsl:value-of select="$panelID"/>
    </xsl:param>

	<xsl:template match="/RESPONSE">
    	<xsl:call-template name="panel" />
    </xsl:template>
	
	<xsl:template name="panel-block-details"> 
		<xsl:attribute name="class">
			<xsl:text>block block-details extra-wide</xsl:text>
		</xsl:attribute>
		 
        <h2 class="list-item">
        	<xsl:if test="$domain/text() != ''">
	        	<xsl:value-of select="$domain" />
	        	<xsl:text> &gt; </xsl:text>
        	</xsl:if>
        	<xsl:if test="$list/text() != ''">        		
        		<xsl:value-of select="$list" />
        		<xsl:text> &gt; </xsl:text>
        	</xsl:if>
        	<xsl:text>New list item</xsl:text>
        </h2>
                        
        <!-- TABS -->
        <div id="{$tabsID}" class="tab">
	        <!-- TABS LIST -->
			<ul>
				<li>
					<a href="#{$labvalFormID}">Label/Value(s)</a>
				</li>
				<li>
					<a href="#{$CSVFormID}">CSV</a>
				</li>
			</ul>
            <!-- LABEL/VALUE FORM -->
            <form id="{$labvalFormID}" name="{$labvalFormID}" enctype="multipart/form-data">
				<xsl:call-template name="labval-content" />
            </form>
            <!-- CSV FORM -->
            <form id="{$CSVFormID}" name="{$CSVFormID}" enctype="multipart/form-data">
                <xsl:call-template name="csv-content" />
            </form>
        </div>
	</xsl:template>

    <xsl:template name="labval-content">
        <table class="fields">
            <tr>
                <td class="field-name">Domain:</td>
                <td class="field-value">
                    <input type="text" class="input-text" id="domain" name="domain" value="{/RESPONSE/URL/domain}" />
                </td>
            </tr>
            <tr>
                <td class="field-name">List:</td>
                <td class="field-value">
                    <input type="text" class="input-text" id="list" name="list" value="{/RESPONSE/URL/list}" />
                </td>
            </tr>
            <tr>
                <td class="field-name">Language:</td>
                <td class="field-value">
                    <select class="input-select-small" id="languageID" name="languageID">
                        <option value="shared">Shared</option>
                        <xsl:for-each select="/RESPONSE/RESULTS[@name='published_languages']/LANGUAGE">
                            <option value="{@ID}">
                                <xsl:if test="@ID=/RESPONSE/URL/languageID">
                                    <xsl:attribute name="selected">
                                        <xsl:text>selected</xsl:text>
                                    </xsl:attribute>
                                </xsl:if>
                                <xsl:value-of select="LABEL"/>
                            </option>
                        </xsl:for-each>
                    </select>
                </td>
            </tr>
            <tr>
                <td class="field-name">Label:</td>
                <td class="field-value">
                    <input type="text" class="input-text" id="label" name="label" value="{/RESPONSE/URL/label}" />
                </td>
            </tr>
            <tr>
                <td class="field-name">Value:</td>
                <td class="field-value">
                    <input type="text" class="input-text" id="value" name="value" value="{/RESPONSE/URL/value}" />
                </td>
            </tr>
            <tr>
                <td class="field-name">&#160;</td>
                <td class="field-value">
                    <input type="submit" name="submit" class="input-submit-save" value="Add"/>
                </td>
            </tr>
        </table>
    </xsl:template>

    <xsl:template name="csv-content">
        <table class="fields">
            <tr>
                <td colspan="2" align="left">
                    <strong>[domain],[list name],[language ID],[label],[value]</strong>
                </td>
            </tr>
            <tr>
                <td colspan="2" align="left">
                    <textarea class="input-textarea" id="csv-values" name="csv-values"></textarea>
                </td>
            </tr>
            <tr>
                <td colspan="2" align="left">
                    <input type="submit" name="submit" class="input-submit-save" value="Import"/>
                </td>
            </tr>
        </table>
    </xsl:template>

    <xsl:template name="panel-js">
    	<xsl:call-template name="js-init-autoresize" />
		<xsl:call-template name="js-init-tabs" />

           <!-- PROCESS -->
		$('#<xsl:value-of select="$labvalFormID" />').submit(delegate(this, function() {
               	fm = new FormManager(<xsl:value-of select="$panelID"/>, AppController);

				fm.onSuccess(function(response){
	               <xsl:text>$(AppController).panelslider('replacePanel', </xsl:text>
	                   <xsl:value-of select="$panelID"/>
	                   <xsl:text>,'../../system/tools/list/New','New list item',</xsl:text>
	                   <xsl:text>{domain:response.domain,list:response.list,languageID:response.languageID,title:'New list item'}</xsl:text>
	               <xsl:text>, 1);</xsl:text>
				});

               	fm.displayProcess('Adding list item...');
               	fm.setScript('../../system/tools/list/ops.php?action=create');
				fm.parseAndSend('#<xsl:value-of select="$labvalFormID" />');

				return false;
		}));

		$('#<xsl:value-of select="$CSVFormID" />').submit(delegate(this, function() {
               	fm = new FormManager(<xsl:value-of select="$panelID"/>, AppController);
               
				fm.onSuccess(function(response){
	               <xsl:text>$(AppController).panelslider('replacePanel', </xsl:text>
	                   <xsl:value-of select="$panelID"/>
	                   <xsl:text>,'../../system/tools/list/New','New list item',</xsl:text>
	                   <xsl:text>{domain:response.domain,list:response.list,title:'New list item'}</xsl:text>
	               <xsl:text>, 1);</xsl:text>
				});

               	fm.displayProcess('Importing list items from CSV...');
               	fm.setScript('../../system/tools/list/ops.php?action=import');
				fm.parseAndSend('#<xsl:value-of select="$CSVFormID" />');
				
				return false;
		}));
    </xsl:template>
</xsl:stylesheet>