<?php
/*
Officity - Web application platform - Version 6.0 - 2011-07-05

François Dispaux, Boris Verdeyen, Thomas Hermant,
Jérémie Roy, Grégory Meurice, Abdelila Harbi, 
Marc Mignonsin, Jonathan Sanchez, Julien Gonzalez, Pierre Fouchez

Sushee and Officity is © Copyright 2011 Nectil SA.

`/var/www/installer/public_html/officity-source/apps/system/tools/module/ops.php` is part of Officity.

Sushee is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

Officity and Sushee are distributed in the hope that they will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Sushee. If not, see <http://www.gnu.org/licenses/>.
*/
	require_once(dirname(__FILE__).'/include.php');

    /* *** */

    define('SAVE',      true);
    define('LOG_NQL',   false);

    /* *** */

    $response = new JSONResponse();

    $ACTION = $_GET['action'];
    $response->set('action', $ACTION);

    $result = false;
    $output_message = '';
    $element = new Element();

    switch ($ACTION)
    {
        case 'create':
            $element->parse($_POST);
            $result = $element->create(SAVE);
            
            if ($result == true)
            {
                $response->set('ID', $element->getID());
            }
            break;

        case 'update':
            $ITEM_ID = $_POST['ID'];
            if (empty($ITEM_ID))
            {
                $response->outputError('No module ID!');
            }
            $response->set('ID', $ITEM_ID);

            $element->setID($ITEM_ID);
            $element->parse($_POST);
            $result = $element->update(SAVE);
            break;

        case 'link':
            $ITEM_ID = $_POST['ID'];
            if (empty($ITEM_ID))
            {
                $response->outputError('No module ID!');
            }
            $response->set('ID', $ITEM_ID);

            $DEPENDENCY_TYPE = $_POST['dependency'];
            if (empty($DEPENDENCY_TYPE))
            {
                $response->outputError('No dependency type!');
            }
            $response->set('dependency', $DEPENDENCY_TYPE);

            $TARGET_MODULE = strtoupper($_POST['targetModule']);
            if (empty($TARGET_MODULE))
            {
                $response->outputError('No target module!');
            }
            $response->set('targetModule', $TARGET_MODULE);

            $TARGET_ID = $_POST['targetID'];
            if (empty($TARGET_ID))
            {
                $response->outputError('No target ID!');
            }
            $response->set('targetID', $TARGET_ID);

            $element->setID($ITEM_ID);
            $element->setDependencyByName($DEPENDENCY_TYPE, $TARGET_MODULE, $TARGET_ID, 'reverse', 'append');
            $result = $element->update(SAVE);
            break;

        case 'unlink':
            $ITEM_ID = $_POST['ID'];
            if (empty($ITEM_ID))
            {
                $response->outputError('No module ID!');
            }
            $response->set('ID', $ITEM_ID);

            $DEPENDENCY_TYPE = $_POST['dependency'];
            if (empty($DEPENDENCY_TYPE))
            {
                $response->outputError('No dependency type!');
            }
            $response->set('dependency', $DEPENDENCY_TYPE);

            $TARGET_MODULE = strtoupper($_POST['targetModule']);
            if (empty($TARGET_MODULE))
            {
                $response->outputError('No target module!');
            }
            $response->set('targetModule', $TARGET_MODULE);

            $TARGET_ID = $_POST['targetID'];
            if (empty($TARGET_ID))
            {
                $response->outputError('No target ID!');
            }
            $response->set('targetID', $TARGET_ID);

            $element->setID($ITEM_ID);
            $element->setDependencyByName($DEPENDENCY_TYPE, $TARGET_MODULE, $TARGET_ID, 'reverse', 'remove');
            $result = $element->update(SAVE);
            break;

        case 'delete':
            $ITEM_ID = $_POST['ID'];
            if (empty($ITEM_ID))
            {
                $response->outputError('No module ID!');
            }
            $response->set('ID', $ITEM_ID);

            $element->setID($ITEM_ID);
            $result = $element->destroy(SAVE);
            break;

        case 'count':
            $hits = $element->count(SAVE);

            if ($hits !== false)
            {
                $result = true;
                $output_message = $hits;
            }
            break;

        default:
        	$response->outputError('Invalid action "'.$ACTION.'"!');
            break;
    }

    if ((LOG_NQL == TRUE) || (SAVE == false) || ($result == false))
    {
        $response->set('NQL', $element->getNQLCommand());
    }

	if ($result === true)
	{
        $response->outputSuccess($output_message);
	}
    else
	{
        $response->outputError('Action failed: '.$element->getLastError());
	}
?>