<?xml version="1.0" encoding="utf-8"?>
<!--

Officity - Web application platform - Version 6.0 - 2011-07-05

François Dispaux, Boris Verdeyen, Thomas Hermant,
Jérémie Roy, Grégory Meurice, Abdelila Harbi, 
Marc Mignonsin, Jonathan Sanchez, Julien Gonzalez, Pierre Fouchez

Sushee and Officity is © Copyright 2011 Nectil SA.

`/var/www/installer/public_html/officity-source/apps/system/tools/panel/panel.elementnew.layout.xsl` is part of Officity.

Sushee is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

Officity and Sushee are distributed in the hope that they will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Sushee. If not, see <http://www.gnu.org/licenses/>.

-->
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0" xmlns:OFFICITY="http://officity.com">
	<xsl:import href="include.xsl"/>
   	
	<!--  NEW ELEMENT PANEL -->
	<xsl:template name="panel-newelement">
		<xsl:param name="optimalWidth" />
		<xsl:param name="fixedHeaderHeight" />
		<xsl:param name="fixedBodyHeight" />
		<xsl:param name="element" />
		<xsl:param name="title">
			<xsl:text>New </xsl:text>
			<xsl:value-of select="name($element)" />
			<xsl:text> element</xsl:text>
		</xsl:param>
		<xsl:param name="displaySusheeTab" select="false()" />
		<xsl:param name="tabsList">
			<xsl:text>info,Details;</xsl:text>
			<xsl:if test="$displaySusheeTab=true()">
				<xsl:text>sushee-info,Sushee;</xsl:text>
			</xsl:if>
		</xsl:param>		
		<xsl:param name="displayNavDetails" select="false()"/>
		<xsl:param name="panelcssclass">
			<xsl:apply-templates select="$element" mode="element-panel-new-class"/>
		</xsl:param>
		<xsl:param name="blockcssclass" select="'extra-wide'" />
		<xsl:param name="titlecssclass">
    		<xsl:call-template name="translate-namespace-name">
        		<xsl:with-param name="name" select="name($element)"/>
        	</xsl:call-template>
		</xsl:param>

	    <xsl:call-template name="panel-elementdetails">
	    	<xsl:with-param name="optimalWidth" select="$optimalWidth" />
	    	<xsl:with-param name="fixedHeaderHeight" select="$fixedHeaderHeight" />
	    	<xsl:with-param name="fixedBodyHeight" select="$fixedBodyHeight" />
	    	<xsl:with-param name="element" select="$element"/>
	    	<xsl:with-param name="title" select="$title"/>
	    	<xsl:with-param name="tabsList" select="$tabsList"/>
	    	<xsl:with-param name="newElement" select="true()"/>
   		    <xsl:with-param name="displayOverviewTab" select="false()" />
   		    <xsl:with-param name="displaySusheeTab" select="$displaySusheeTab" />
	    	<xsl:with-param name="displayAdminTab" select="false()" />
	    	<xsl:with-param name="displayNavDetails" select="$displayNavDetails" />
	    	<xsl:with-param name="panelcssclass" select="$panelcssclass"/>
	    	<xsl:with-param name="blockcssclass" select="$blockcssclass"/>
	    	<xsl:with-param name="titlecssclass" select="$titlecssclass"/>
	    </xsl:call-template>
    </xsl:template>
</xsl:stylesheet>