<?xml version="1.0" encoding="utf-8"?>
<!--

Officity - Web application platform - Version 6.0 - 2011-07-05

François Dispaux, Boris Verdeyen, Thomas Hermant,
Jérémie Roy, Grégory Meurice, Abdelila Harbi, 
Marc Mignonsin, Jonathan Sanchez, Julien Gonzalez, Pierre Fouchez

Sushee and Officity is © Copyright 2011 Nectil SA.

`/var/www/installer/public_html/officity-source/apps/system/tools/panel/panel.link.layout.xsl` is part of Officity.

Sushee is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

Officity and Sushee are distributed in the hope that they will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Sushee. If not, see <http://www.gnu.org/licenses/>.

-->
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0" xmlns:OFFICITY="http://officity.com">
	<xsl:import href="include.xsl"/>
	
	<!--  DEPENDENCY (UN)LINK PANEL -->
	<xsl:template name="panel-link">
		<xsl:param name="optimalWidth" />
		<xsl:param name="fixedHeaderHeight" select="''" />
		<xsl:param name="fixedBodyHeight" select="''" />
		<xsl:param name="list" select="/RESPONSE/RESULTS[@name='list']"/>
		<xsl:param name="module" select="/RESPONSE/URL/module"/>
		<xsl:param name="originID" select="/RESPONSE/URL/originID"/>
		<xsl:param name="dependency" select="/RESPONSE/URL/dependency"/>
		<xsl:param name="targetModule" select="/RESPONSE/URL/targetModule"/>
        <xsl:param name="addNew" select="true()" />        
        <xsl:param name="addNewScript">
	        <xsl:choose>
				<xsl:when test="$list/*[1]">
					<xsl:apply-templates select="$list/*[1]" mode="element-script-new" />
				</xsl:when>
				<xsl:otherwise>
					<xsl:text>../../system/tools/element/New</xsl:text>
				</xsl:otherwise>
			</xsl:choose>        	
        </xsl:param>
        <xsl:param name="pagingStyle" select="'browser'"/>
        <xsl:param name="params" />
        <xsl:param name="searchText">
        	<xsl:text>Link to </xsl:text>
        	<xsl:value-of select="$targetModule" />
        	<xsl:text> elements...</xsl:text>
        </xsl:param>
        <xsl:param name="panelcssclass" />
        
        <xsl:choose>
            <xsl:when test="/RESPONSE/URL/page">
                <xsl:call-template name="panel-body-link">
                	<xsl:with-param name="list" select="$list" />
                	<xsl:with-param name="module" select="$module" />
                	<xsl:with-param name="originID" select="$originID" />
                	<xsl:with-param name="dependency" select="$dependency" />
                	<xsl:with-param name="targetModule" select="$targetModule" />
                	<xsl:with-param name="addNew" select="$addNew" />
                	<xsl:with-param name="addNewScript" select="$addNewScript" />
                	<xsl:with-param name="pagingStyle" select="$pagingStyle" />
               	</xsl:call-template>       
            </xsl:when>
            <xsl:otherwise>
				<div class="panel-title-bar">
					<xsl:call-template name="panel-title-bar"/>
				</div>
		        <div class="panel-header header-toolbar">
		        	<xsl:if test="$fixedHeaderHeight!=''">
		        		<xsl:attribute name="style">
		        			<xsl:text>height:</xsl:text>
		        			<xsl:value-of select="$fixedHeaderHeight" />
		        			<xsl:text> !important;overflow:hidden !important;max-height:'' !important;</xsl:text>
		        		</xsl:attribute>
		        	</xsl:if>
		        	<xsl:call-template name="panel-header-link">
		        		<xsl:with-param name="searchText" select="$searchText" />
		        	</xsl:call-template>
		       	</div>
		       	<div class="panel-body" optimal-width="{$optimalWidth}">
		        	<xsl:if test="$fixedBodyHeight!=''">
		        		<xsl:attribute name="style">
		        			<xsl:text>height:</xsl:text>
		        			<xsl:value-of select="$fixedBodyHeight" />
		        			<xsl:text> !important;overflow:hidden !important;max-height:'' !important;</xsl:text>
		        		</xsl:attribute>
		        	</xsl:if>
		        	<xsl:call-template name="panel-body-loader"/>
					<div class="block block-nav">
		                <xsl:call-template name="panel-body-link">
		                	<xsl:with-param name="list" select="$list" />
		                	<xsl:with-param name="module" select="$module" />
		                	<xsl:with-param name="originID" select="$originID" />
		                	<xsl:with-param name="dependency" select="$dependency" />
		                	<xsl:with-param name="targetModule" select="$targetModule" />
		                	<xsl:with-param name="addNew" select="$addNew" />
		                	<xsl:with-param name="addNewScript" select="$addNewScript" />
		                	<xsl:with-param name="pagingStyle" select="$pagingStyle" />
		               	</xsl:call-template>
					</div>
		        </div>
                <script type="text/javascript">
					<xsl:call-template name="panel-js-link">
						<xsl:with-param name="module" select="$module" />
						<xsl:with-param name="originID" select="$originID" />
						<xsl:with-param name="dependency" select="$dependency" />
						<xsl:with-param name="targetModule" select="$targetModule" />
						<xsl:with-param name="params" select="$params" />
						<xsl:with-param name="panelcssclass" select="$panelcssclass"/>
					</xsl:call-template>
					<xsl:call-template name="panel-add-js"/>
                </script>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    
    <!-- link header -->
	<xsl:template name="panel-header-link">
		<xsl:param name="searchText" />
		<form id="quichsearch-form" onsubmit="return false;" style="width:98%">
			<xsl:call-template name="header-quicksearch-input">
				<xsl:with-param name="ID">
					<xsl:text>quicksearch-text</xsl:text>
				</xsl:with-param>
				<xsl:with-param name="searchText" select="$searchText" />
				<xsl:with-param name="resetID">
					<xsl:text>quicksearch-reset</xsl:text>
				</xsl:with-param>
			</xsl:call-template>
		</form>
	</xsl:template>
	
	<!-- link body -->
	<xsl:template name="panel-body-link">
        <xsl:param name="list" />
		<xsl:param name="module" />
		<xsl:param name="originID" />
		<xsl:param name="dependency" />
		<xsl:param name="targetModule" />
        <xsl:param name="depsList" />
        <xsl:param name="addNew" />
        <xsl:param name="addNewScript" />
        <xsl:param name="pagingStyle" />
        
        <xsl:choose>
	        <xsl:when test="$pagingStyle='browser'">
		        <xsl:call-template name="list-browser">
		            <xsl:with-param name="list" select="$list"/>
		            <xsl:with-param name="event" select="'loadpage'"/>
		        </xsl:call-template>
	        </xsl:when>
	        <xsl:when test="$pagingStyle='pager'">
		        <xsl:call-template name="list-pager">
		            <xsl:with-param name="list" select="$list"/>
		            <xsl:with-param name="event" select="'loadpage'"/>
		        </xsl:call-template>
	        </xsl:when>
        </xsl:choose>
        
		<xsl:call-template name="panel-list-header-link">
	        <xsl:with-param name="list" select="$list" />
	        <xsl:with-param name="module" select="$module" />
	        <xsl:with-param name="originID" select="$originID" />
	        <xsl:with-param name="dependency" select="$dependency" />
	        <xsl:with-param name="targetModule" select="$targetModule" />
	        <xsl:with-param name="addNew" select="$addNew" />
	        <xsl:with-param name="addNewScript" select="$addNewScript" />
		</xsl:call-template>
        
		<xsl:call-template name="panel-list-link">
			<xsl:with-param name="list" select="$list" />
		</xsl:call-template>

        <xsl:choose>
	        <xsl:when test="$pagingStyle='browser'">
		        <xsl:call-template name="list-browser">
		            <xsl:with-param name="list" select="$list"/>
		            <xsl:with-param name="event" select="'loadpage'"/>
		        </xsl:call-template>
	        </xsl:when>
	        <xsl:when test="$pagingStyle='pager'">
		        <xsl:call-template name="list-pager">
		            <xsl:with-param name="list" select="$list"/>
		            <xsl:with-param name="event" select="'loadpage'"/>
		        </xsl:call-template>
	        </xsl:when>
        </xsl:choose>
	</xsl:template>
	
	<!-- link list header -->
	<xsl:template name="panel-list-header-link">
        <xsl:param name="list" />
        <xsl:param name="module" />
        <xsl:param name="originID" />
        <xsl:param name="dependency" />
        <xsl:param name="targetModule" />
        <xsl:param name="addNew" />
        <xsl:param name="addNewScript" />
        
		<xsl:if test="(boolean($addNew)=true()) and (/RESPONSE/URL/quicksearch-text/text())">
	        <xsl:call-template name="nav-new">
	            <xsl:with-param name="title">Create new...</xsl:with-param>
	            <xsl:with-param name="module" select="$targetModule" />
	            <xsl:with-param name="panelURI" select="$addNewScript" />
	            <xsl:with-param name="params">
		            <xsl:text>searchText:'</xsl:text>
		            <xsl:value-of select="/RESPONSE/URL/quicksearch-text" />
		            <xsl:text>',targetID:</xsl:text><xsl:value-of select="$originID"/>
		            <xsl:text>,targetModule:'</xsl:text>
		            <xsl:value-of select="$targetModule"/>
		            <xsl:text>', dependency:'</xsl:text>
		            <xsl:value-of select="$dependency"/>
		            <xsl:text>'</xsl:text>
	            </xsl:with-param>
	            <xsl:with-param name="cssclass" select="'grey-bkgnd'" />
	        </xsl:call-template>
        </xsl:if>
	</xsl:template>
	
	<!-- link list -->
	<xsl:template name="panel-list-link">
		<xsl:param name="list" />
		
        <xsl:choose>
            <xsl:when test="$list/@hits > 0">
                <xsl:for-each select="$list/*">
                    <xsl:apply-templates select="." mode="element-navitem-link" />
                </xsl:for-each>
            </xsl:when>
            <xsl:otherwise>
                <div class="no-result">No hits</div>
            </xsl:otherwise>
        </xsl:choose>
	</xsl:template>	
	
	<!-- link navigation item : NOT in dependency -->
    <xsl:template match="*[not(/RESPONSE/RESULTS[@name='depsList']/*/@ID=@ID)]" mode="element-navitem-link">
		<xsl:apply-templates select="." mode="element-navitem-depadd" />
    </xsl:template>

	<!-- link navigation item : IN dependency -->
    <xsl:template match="*[/RESPONSE/RESULTS[@name='depsList']/*/@ID=@ID]" mode="element-navitem-link">
		<xsl:apply-templates select="." mode="element-navitem-depremove" />
    </xsl:template>
	
	<!-- link js -->
	<xsl:template name="panel-js-link">
		<xsl:param name="module" />
		<xsl:param name="originID" />
		<xsl:param name="dependency" />
		<xsl:param name="targetModule" />
		<xsl:param name="params" />
		<xsl:param name="panelcssclass" />
		
		$('#<xsl:value-of select="$panelID"/>.panel').addClass('<xsl:value-of select="$panelcssclass"/>');
	
	     var quickSearcher<xsl:value-of select="$panelID"/> = new QuickSearcher(
	         <xsl:value-of select="$panelID"/>,
	         AppController,
	         '../../<xsl:value-of select="/RESPONSE/URL/editor"/>/<xsl:value-of select="/RESPONSE/URL/app"/>/<xsl:value-of select="/RESPONSE/URL/panelURI"/>.php',
	         'quicksearch-text',
	         'quicksearch-reset'
	     );
	
	     quickSearcher<xsl:value-of select="$panelID"/>.setDefaultParms({
	         panelID : <xsl:value-of select="$panelID"/>,
	         app : '<xsl:value-of select="/RESPONSE/URL/app" />',
	         editor : '<xsl:value-of select="/RESPONSE/URL/editor" />',
	         module : '<xsl:value-of select="$module"/>',
	         originID : '<xsl:value-of select="$originID"/>',
	         dependency : '<xsl:value-of select="$dependency"/>',
	         targetModule : '<xsl:value-of select="$targetModule"/>'
             <xsl:if test="$params">
             	<xsl:text>,</xsl:text>
             	<xsl:value-of select="$params" />
             </xsl:if>
	     });
	     
	    $('#<xsl:value-of select="$panelID"/>.panel').panel({
	    	onRefresh: function(panelElem){
	    		quickSearcher<xsl:value-of select="$panelID"/>.reset(false);
	    		quickSearcher<xsl:value-of select="$panelID"/>.refresh();
	    	}
    	});
	
	     $('#<xsl:value-of select="$panelID"/>.panel').bind('loadpage', function(eventObject, page){
	         quickSearcher<xsl:value-of select="$panelID"/>.loadPage(page);
	         return false;
	     });
    	
     	<xsl:call-template name="panel-bind-dependency-event">	
			<xsl:with-param name="dependency" select="$dependency" />
			<xsl:with-param name="targetModule" select="$module" />
			<xsl:with-param name="targetID" select="$originID" />
		</xsl:call-template>
	</xsl:template>
</xsl:stylesheet>