<?xml version="1.0" encoding="UTF-8" ?>
<!--

Officity - Web application platform - Version 6.0 - 2011-07-05

François Dispaux, Boris Verdeyen, Thomas Hermant,
Jérémie Roy, Grégory Meurice, Abdelila Harbi, 
Marc Mignonsin, Jonathan Sanchez, Julien Gonzalez, Pierre Fouchez

Sushee and Officity is © Copyright 2011 Nectil SA.

`/var/www/installer/public_html/officity-source/apps/system/tools/report/pdf/html2fo.xsl` is part of Officity.

Sushee is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

Officity and Sushee are distributed in the hope that they will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Sushee. If not, see <http://www.gnu.org/licenses/>.

-->
<xsl:stylesheet version="1.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:fo="http://www.w3.org/1999/XSL/Format">

	<xsl:output encoding="UTF-8" indent="no" method="xml" />
	
	<!-- STYLED TEXT (DESCRIPTIONS) -->
	
	<xsl:template match="CSS//p">
	  <fo:block space-after="0.2cm">
	    <xsl:apply-templates select="*|text()"/>
	  </fo:block>
	</xsl:template>
	
	<xsl:template match="CSS//br">
		<fo:block> </fo:block>
	</xsl:template>
	
	<xsl:template match="CSS//img">
		<fo:external-graphic src="{@src}"/>
	</xsl:template>

	<xsl:template match="CSS//a">
	  <xsl:choose>
	    <xsl:when test="@name">
	      <xsl:if test="not(name(following-sibling::*[1]) = 'h1')">
	        <fo:block line-height="0" space-after="0pt" 
	          font-size="0pt" id="{@name}"/>
	      </xsl:if>
	    </xsl:when>
	    <xsl:when test="@href">
	      <fo:basic-link color="blue">
	        <xsl:choose>
	          <xsl:when test="starts-with(@href, '#')">
	            <xsl:attribute name="internal-destination">
	              <xsl:value-of select="substring(@href, 2)"/>
	            </xsl:attribute>
	          </xsl:when>
	          <xsl:otherwise>
	            <xsl:attribute name="external-destination">
	              <xsl:value-of select="@href"/>
	            </xsl:attribute>
	          </xsl:otherwise>
	        </xsl:choose>
	        <xsl:apply-templates select="*|text()"/>
	      </fo:basic-link>
	      <xsl:if test="starts-with(@href, '#')">
	        <xsl:text> on page </xsl:text>
	        <fo:page-number-citation ref-id="{substring(@href, 2)}"/>
	      </xsl:if>
	    </xsl:when>
	  </xsl:choose>
	</xsl:template>
	
	<xsl:template match="CSS//em | CSS/i">
		<fo:inline font-style="italic">
			<xsl:apply-templates select="*|text()"/>
		</fo:inline>
	</xsl:template>
	
	<xsl:template match="CSS//strong | CSS//b">
		<fo:inline font-weight="bold">
			<xsl:apply-templates select="*|text()"/>
		</fo:inline>
	</xsl:template>
	
	<xsl:template match="CSS//u">
		<fo:inline text-decoration="underline">
			<xsl:apply-templates select="*|text()"/>
		</fo:inline>
	</xsl:template>
	
	<xsl:template match="CSS//span">
		<fo:inline>
			<xsl:choose>
				<xsl:when test="contains(@style,'underline')">
					<xsl:attribute name="text-decoration">
						<xsl:text>underline</xsl:text>
					</xsl:attribute>
				</xsl:when>
				<xsl:otherwise>
				</xsl:otherwise>
			</xsl:choose>
			<xsl:apply-templates select="*|text()"/>
		</fo:inline>
	</xsl:template>
	
	<xsl:template match="CSS//address">
	  <fo:block font-style="italic">
	    <xsl:apply-templates select="*|text()"/>
	  </fo:block>
	</xsl:template>
	
	<xsl:template match="CSS//blockquote">
	  <fo:block start-indent="1.5cm" end-indent="1.5cm">
	    <xsl:apply-templates select="*|text()"/>
	  </fo:block>
	</xsl:template>

	<xsl:template match="CSS//code">
	  <fo:inline font-family="monospace">
	    <xsl:apply-templates select="*|text()"/>
	  </fo:inline>
	</xsl:template>
	
	<xsl:template match="CSS//pre">
	  <fo:block font-family="monospace"
	    white-space-collapse="false"
	    wrap-option="no-wrap">
	    <xsl:apply-templates select="*|text()"/>
	  </fo:block>
	</xsl:template>
	
	<xsl:template match="CSS//strike">
	  <fo:inline text-decoration="line-through">
	    <xsl:apply-templates select="*|text()"/>
	  </fo:inline>
	</xsl:template>
	
	<xsl:template match="CSS//sub">
	  <fo:inline vertical-align="sub"
	        font-size="75%">
	    <xsl:apply-templates select="*|text()"/>
	  </fo:inline>
	</xsl:template>

	<xsl:template match="CSS//sup">
	  <fo:inline vertical-align="super"
	        font-size="75%">
	    <xsl:apply-templates select="*|text()"/>
	  </fo:inline>
	</xsl:template>
	
	<xsl:template match="CSS//hr">
	  <fo:block>
	    <fo:leader leader-pattern="rule"/>
	  </fo:block>
	</xsl:template>

	<xsl:template match="CSS//h1">
	  <!--fo:block break-before="page">
	    <fo:leader leader-pattern="rule"/>
	  </fo:block--> 
	  <fo:block font-size="28pt" line-height="32pt"
	      keep-with-next="always"
	      space-after="22pt" font-family="serif">
	    <xsl:attribute name="id">
	      <xsl:choose>
	        <xsl:when test="@id">
	          <xsl:value-of select="@id"/>
	        </xsl:when>
	        <xsl:when test="name(preceding-sibling::*[1]) = 'a' and
	                         preceding-sibling::*[1][@name]">
	          <xsl:value-of select="preceding-sibling::*[1]/@name"/>
	        </xsl:when>
	        <xsl:otherwise>
	          <xsl:value-of select="generate-id()"/>
	        </xsl:otherwise>
	      </xsl:choose>
	    </xsl:attribute>
	    <xsl:apply-templates select="*|text()"/>
	  </fo:block>
	</xsl:template>
	
	<xsl:template match="CSS//h2">
	  <fo:block font-size="24pt" line-height="28pt"
	      keep-with-next="always" space-after="18pt"
	      font-family="serif">
	    <xsl:attribute name="id">
	      <xsl:choose>
	        <xsl:when test="@id">
	          <xsl:value-of select="@id"/>
	        </xsl:when>
	        <xsl:otherwise>
	          <xsl:value-of select="generate-id()"/>
	        </xsl:otherwise>
	      </xsl:choose>
	    </xsl:attribute>
	    <xsl:apply-templates select="*|text()"/>
	  </fo:block>
	</xsl:template>
	
	<xsl:template match="CSS//h3">
	  <fo:block font-size="21pt" line-height="24pt"
	      keep-with-next="always" space-after="14pt"
	      font-family="serif">
	    <xsl:attribute name="id">
	      <xsl:choose>
	        <xsl:when test="@id">
	          <xsl:value-of select="@id"/>
	        </xsl:when>
	        <xsl:otherwise>
	          <xsl:value-of select="generate-id()"/>
	        </xsl:otherwise>
	      </xsl:choose>
	    </xsl:attribute>
	    <xsl:apply-templates select="*|text()"/>
	  </fo:block>
	</xsl:template>
	
	<xsl:template match="CSS//h4">
	  <fo:block font-size="18pt" line-height="21pt"
	      keep-with-next="always" space-after="12pt"
	      font-family="serif">
	    <xsl:attribute name="id">
	      <xsl:choose>
	        <xsl:when test="@id">
	          <xsl:value-of select="@id"/>
	        </xsl:when>
	        <xsl:otherwise>
	          <xsl:value-of select="generate-id()"/>
	        </xsl:otherwise>
	      </xsl:choose>
	    </xsl:attribute>
	    <xsl:apply-templates select="*|text()"/>
	  </fo:block>
	</xsl:template>
	
	<xsl:template match="CSS//h5">
	  <fo:block font-size="16pt" line-height="19pt"
	      keep-with-next="always" space-after="12pt"
	      font-family="serif"
	      text-decoration="underline">
	    <xsl:attribute name="id">
	      <xsl:choose>
	        <xsl:when test="@id">
	          <xsl:value-of select="@id"/>
	        </xsl:when>
	        <xsl:otherwise>
	          <xsl:value-of select="generate-id()"/>
	        </xsl:otherwise>
	      </xsl:choose>
	    </xsl:attribute>
	    <xsl:apply-templates select="*|text()"/>
	  </fo:block>
	</xsl:template>
	
	<xsl:template match="CSS//h6">
	  <fo:block font-size="14pt" line-height="17pt"
	      keep-with-next="always" space-after="12pt"
	      font-family="serif" font-style="italic"
	      text-decoration="underline">
	    <xsl:attribute name="id">
	      <xsl:choose>
	        <xsl:when test="@id">
	          <xsl:value-of select="@id"/>
	        </xsl:when>
	        <xsl:otherwise>
	          <xsl:value-of select="generate-id()"/>
	        </xsl:otherwise>
	      </xsl:choose>
	    </xsl:attribute>
	    <xsl:apply-templates select="*|text()"/>
	  </fo:block>
	</xsl:template>
	
	<xsl:template match="CSS//ol">
	  <fo:list-block provisional-distance-between-starts="1cm"
	    provisional-label-separation="0.5cm">
	    <xsl:attribute name="space-after">
	      <xsl:choose>
	        <xsl:when test="ancestor::ul or ancestor::ol">
	          <xsl:text>0pt</xsl:text>
	        </xsl:when>
	        <xsl:otherwise>
	          <xsl:text>12pt</xsl:text>
	          </xsl:otherwise>
	      </xsl:choose>
	    </xsl:attribute>
	    <xsl:attribute name="start-indent">
	      <xsl:variable name="ancestors">
	        <xsl:choose>
	          <xsl:when test="count(ancestor::ol) or count(ancestor::ul)">
	            <xsl:value-of select="1 + 
	                                  (count(ancestor::ol) + 
	                                   count(ancestor::ul)) * 
	                                  1.25"/>
	          </xsl:when>
	          <xsl:otherwise>
	            <xsl:text>1</xsl:text>
	          </xsl:otherwise>
	        </xsl:choose>
	      </xsl:variable>
	      <xsl:value-of select="concat($ancestors, 'cm')"/>
	    </xsl:attribute>
	    <xsl:apply-templates select="*"/>
	  </fo:list-block>
	</xsl:template>
	
	<xsl:template match="CSS//ol/li">
	  <fo:list-item>
	    <fo:list-item-label end-indent="label-end()">
	      <fo:block>
	        <xsl:variable name="value-attr">
	          <xsl:choose>
	            <xsl:when test="../@start">
	              <xsl:number value="position() + ../@start - 1"/>
	            </xsl:when>
	            <xsl:otherwise>
	              <xsl:number value="position()"/>
	            </xsl:otherwise>
	          </xsl:choose>
	        </xsl:variable>
	        <xsl:choose>
	          <xsl:when test="../@type='i'">
	            <xsl:number value="$value-attr" format="i. "/>
	          </xsl:when>
	          <xsl:when test="../@type='I'">
	            <xsl:number value="$value-attr" format="I. "/>
	          </xsl:when>
	          <xsl:when test="../@type='a'">
	            <xsl:number value="$value-attr" format="a. "/>
	          </xsl:when>
	          <xsl:when test="../@type='A'">
	            <xsl:number value="$value-attr" format="A. "/>
	          </xsl:when>
	          <xsl:otherwise>
	            <xsl:number value="$value-attr" format="1. "/>
	          </xsl:otherwise>
	        </xsl:choose>
	      </fo:block>
	    </fo:list-item-label>
	    <fo:list-item-body start-indent="body-start()">
	      <fo:block>
	        <xsl:apply-templates select="*|text()"/>
	      </fo:block>
	    </fo:list-item-body>
	  </fo:list-item>
	</xsl:template>

	<xsl:template match="CSS//ul">
	  <fo:list-block provisional-distance-between-starts="1cm"
	    provisional-label-separation="0.5cm">
	    <xsl:attribute name="space-after">
	      <xsl:choose>
	        <xsl:when test="ancestor::ul or ancestor::ol">
	          <xsl:text>0pt</xsl:text>
	        </xsl:when>
	        <xsl:otherwise>
	          <xsl:text>12pt</xsl:text>
	        </xsl:otherwise>
	      </xsl:choose>
	    </xsl:attribute>
	    <xsl:attribute name="start-indent">
	      <xsl:variable name="ancestors">
	        <xsl:choose>
	          <xsl:when test="count(ancestor::ol) or count(ancestor::ul)">
	            <xsl:value-of select="1 + 
	                                  (count(ancestor::ol) + 
	                                   count(ancestor::ul)) * 
	                                  1.25"/>
	          </xsl:when>
	          <xsl:otherwise>
	            <xsl:text>1</xsl:text>
	          </xsl:otherwise>
	        </xsl:choose>
	      </xsl:variable>
	      <xsl:value-of select="concat($ancestors, 'cm')"/>
	    </xsl:attribute>
	    <xsl:apply-templates select="*"/>
	  </fo:list-block>
	</xsl:template>
	
	<xsl:template match="CSS//ul/li">
	  <fo:list-item>
	    <fo:list-item-label end-indent="label-end()">
	      <fo:block>&#8226;</fo:block>
	    </fo:list-item-label>
	    <fo:list-item-body start-indent="body-start()">
	      <fo:block>
	        <xsl:apply-templates select="*|text()"/>
	      </fo:block>
	    </fo:list-item-body>
	  </fo:list-item>
	</xsl:template>
</xsl:stylesheet>