<?xml version="1.0" encoding="utf-8"?>
<!--

Officity - Web application platform - Version 6.0 - 2011-07-05

François Dispaux, Boris Verdeyen, Thomas Hermant,
Jérémie Roy, Grégory Meurice, Abdelila Harbi, 
Marc Mignonsin, Jonathan Sanchez, Julien Gonzalez, Pierre Fouchez

Sushee and Officity is © Copyright 2011 Nectil SA.

`/var/www/installer/public_html/officity-source/apps/system/tools/report/report.definitions.xsl` is part of Officity.

Sushee is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

Officity and Sushee are distributed in the hope that they will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Sushee. If not, see <http://www.gnu.org/licenses/>.

-->
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0" xmlns:OFFICITY="http://officity.com">
	<!-- LABEL(s) -->
	<xsl:template match="OFFICITY:REPORT" mode="element-label">
		<xsl:apply-templates select="INFO/TITLE"/>
	</xsl:template>

	<!-- ICON(s) -->
    <xsl:template match="OFFICITY:REPORT[INFO/TYPE = 'pdf']" mode="element-icon">
        <xsl:text>../system/images/icons/documents/pdf-16.png</xsl:text>
    </xsl:template>

    <xsl:template match="OFFICITY:REPORT[INFO/TYPE = 'csv']" mode="element-icon">
        <xsl:text>../system/images/icons/documents/excel-16.png</xsl:text>
    </xsl:template>

	<!-- INFO LABEL(s) -->
	<xsl:template match="OFFICITY:REPORT" mode="element-info">
        <xsl:value-of select="INFO/ORIENTATION"/>
        <xsl:text> / </xsl:text>
        <xsl:value-of select="INFO/FORMAT"/>
	</xsl:template>

	<!-- NAVIGATION ITEM(s) -->
	<xsl:template match="OFFICITY:REPORT" mode="element-navitem">
        <xsl:variable name="module">
    		<xsl:call-template name="translate-namespace-name">
        		<xsl:with-param name="name" select="name(.)"/>
        	</xsl:call-template>
        </xsl:variable>
		<xsl:call-template name="staticitem-action">
			<xsl:with-param name="id">
                <xsl:value-of select="$module" />
                <xsl:text>-</xsl:text>
                <xsl:value-of select="@ID"/>
            </xsl:with-param>
			<xsl:with-param name="title">
				<xsl:apply-templates select="." mode="element-label"/>
			</xsl:with-param>
            <xsl:with-param name="callback">
                <xsl:apply-templates select="." mode="callback"/>
            </xsl:with-param>
            <xsl:with-param name="params">
                <xsl:apply-templates select="." mode="callback-params"/>
            </xsl:with-param>
			<xsl:with-param name="icon">
				<xsl:apply-templates select="." mode="element-icon"/>
			</xsl:with-param>
			<xsl:with-param name="info">
				<xsl:apply-templates select="." mode="element-info"/>
			</xsl:with-param>
		</xsl:call-template>
	</xsl:template>

    <xsl:template match="OFFICITY:REPORT[INFO/TYPE = 'pdf']" mode="callback">
        <xsl:text>displayPDFDialog</xsl:text>
    </xsl:template>

    <xsl:template match="OFFICITY:REPORT[INFO/TYPE = 'pdf']" mode="callback-params">
        <xsl:value-of select="INFO/ID"/>
        <xsl:text>,</xsl:text>
        <xsl:value-of select="INFO/FIXED"/>
        <xsl:text>,'</xsl:text>
        <xsl:value-of select="INFO/TITLE"/>
        <xsl:text>','</xsl:text>
        <xsl:value-of select="INFO/HEADER"/>
        <xsl:text>','</xsl:text>
        <xsl:value-of select="INFO/FOOTER"/>'
    </xsl:template>

    <xsl:template match="OFFICITY:REPORT[INFO/TYPE = 'csv']" mode="callback">
        <xsl:text>displayCSVDialog</xsl:text>
    </xsl:template>

    <xsl:template match="OFFICITY:REPORT[INFO/TYPE = 'csv']" mode="callback-params">
        <xsl:value-of select="INFO/ID"/>
        <xsl:text>,</xsl:text>
        <xsl:value-of select="INFO/FIXED"/>
    </xsl:template>
    
    <!-- TITLE(s) -->
    
    <!-- SCRIPTS -->
</xsl:stylesheet>
