<!--

Officity - Web application platform - Version 6.0 - 2011-07-05

François Dispaux, Boris Verdeyen, Thomas Hermant,
Jérémie Roy, Grégory Meurice, Abdelila Harbi, 
Marc Mignonsin, Jonathan Sanchez, Julien Gonzalez, Pierre Fouchez

Sushee and Officity is © Copyright 2011 Nectil SA.

`/var/www/installer/public_html/officity-source/apps/system/tools/search/newsearch-resources-cmds.xsl` is part of Officity.

Sushee is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

Officity and Sushee are distributed in the hope that they will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Sushee. If not, see <http://www.gnu.org/licenses/>.

-->
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
	<xsl:output encoding="UTF-8" method="xml" indent="no" omit-xml-declaration="yes"/>
	<xsl:strip-space elements="*"/>

	<xsl:param name="search-config" select="/RESPONSE/RESULTS[@name='search-config']/CONFIGXML"/>
	<xsl:param name="search-filter" select="/RESPONSE/RESULTS[@name='search-filter']"/>
	<xsl:param name="filter-fields" select="$search-filter/INFO/QUERYXML//INFO/*"/>
	
	<xsl:param name="fields" select="/RESPONSE/RESULTS[@name='fields']/FIELD"/>

	<xsl:template match="/RESPONSE">
        <!-- step 1 : config default fields -->
        <xsl:apply-templates select="$search-config//DEFAULTFIELD"/>
        <!-- step 2 : loaded filter fields -->
        <xsl:apply-templates select="$filter-fields" mode="loaded-filter"/>
        <!-- step 3 : categories -->
        <xsl:apply-templates select="$search-config/CATEGORIES/CATEGORY"/>
	</xsl:template>

    <xsl:template match="DEFAULTFIELD">
        <xsl:variable name="name" select="."/>
        <xsl:variable name="module" select="../MODULE"/>
        <xsl:apply-templates select="$fields[INFO/MODULE=$module and INFO/DENOMINATION=$name]"/>
    </xsl:template>

    <xsl:template match="*" mode="loaded-filter">
        <xsl:variable name="name" select="name(.)"/>
        <xsl:variable name="module" select="translate(name(../..),'ABCDEFGHIJKLMNOPQRSTUVWXYZ','abcdefghijklmnopqrstuvwxyz')"/>
        <xsl:apply-templates select="$fields[INFO/MODULE=$module and INFO/DENOMINATION=$name]"/>
    </xsl:template>

	<!-- FIELDS -->
	<xsl:template match="FIELD[(INFO/TYPE='elementsList') and (INFO/TARGETMODULE/text()) and (INFO/TARGETFIELD/text())]">
		<xsl:variable name="up-module" select="translate(INFO/TARGETMODULE,'abcdefghijklmnopqrstuvwxyz','ABCDEFGHIJKLMNOPQRSTUVWXYZ')"/>
		<xsl:variable name="up-field" select="translate(INFO/TARGETFIELD,'abcdefghijklmnopqrstuvwxyz','ABCDEFGHIJKLMNOPQRSTUVWXYZ')"/>

        <SEARCH name="{INFO/TARGETMODULE}" refresh="daily">
            <xsl:element name="{$up-module}"/>
            <RETURN>
                <INFO>
                    <xsl:element name="{$up-field}"/>
                </INFO>
            </RETURN>
        </SEARCH>
	</xsl:template>
	
	<xsl:template match="FIELD[INFO/TYPE='list']">
        <GET refresh="daily" name="{INFO/LISTNAME}">
            <LIST name="{INFO/LISTNAME}"/>
        </GET>
	</xsl:template>

	<xsl:template match="FIELD[INFO/TYPE='systemList' and INFO/LISTNAME='Countries']">
        <GET name="Countries" refresh="monthly">
            <COUNTRIES/>
        </GET>
	</xsl:template>

	<xsl:template match="FIELD[INFO/TYPE='systemList' and INFO/LISTNAME='Languages']">
        <GET name="Languages" refresh="monthly">
            <LANGUAGES profile="SmallList"/>
        </GET>
	</xsl:template>

	<xsl:template match="FIELD"/>
	
	<!-- CATEGORIES -->
	<xsl:template match="CATEGORY[@name]">
		<GET refresh="daily" name="{@name}">
			<CATEGORY name="{@name}" />				
			<RETURN depth="all"/>
		</GET>
	</xsl:template>
	
	<xsl:template match="CATEGORY[@path]">
		<GET refresh="daily" name="{@path}">
			<CATEGORY path="{@path}" />				
			<RETURN depth="all"/>
		</GET>
	</xsl:template>
</xsl:stylesheet>