<?xml version="1.0"?>
<!--

Officity - Web application platform - Version 6.0 - 2011-07-05

François Dispaux, Boris Verdeyen, Thomas Hermant,
Jérémie Roy, Grégory Meurice, Abdelila Harbi, 
Marc Mignonsin, Jonathan Sanchez, Julien Gonzalez, Pierre Fouchez

Sushee and Officity is © Copyright 2011 Nectil SA.

`/var/www/installer/public_html/officity-source/apps/system/tools/security/ApplyPermissions.xsl` is part of Officity.

Sushee is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

Officity and Sushee are distributed in the hope that they will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Sushee. If not, see <http://www.gnu.org/licenses/>.

-->
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0" xmlns:OFFICITY="http://officity.com">
    <xsl:import href="include.xsl"/>
    <xsl:output encoding="UTF-8" method="xml" indent="no"/>
    <xsl:strip-space elements="*"/>
    
    <xsl:param name="item" select="/RESPONSE/RESULTS[@name='item']/*[1]" />
    
    <!-- IDs -->
    <xsl:param name="formID">
    	<xsl:text>permission-form-</xsl:text>
    	<xsl:value-of select="$panelID" />
    </xsl:param>

	<xsl:template match="/RESPONSE">
    	<xsl:call-template name="panel" />
    </xsl:template>
    
	<!--  custom : body -->
	<xsl:template name="panel-body">
		<div class="block block-details">
			<xsl:call-template name="panel-block-details"/>
		</div>
	</xsl:template>
	
	<xsl:template name="panel-block-details">  
		<h2 class="apply-permissions">Apply permissions on: <xsl:value-of select="$item/INFO/TITLE" /></h2>
      	
      	<form style="font-size:1.3em;" name="{$formID}" id="{$formID}">
      		<input type="hidden" name="ID" value="{$item/@ID}" />
      		<input type="hidden" name="module" value="{/RESPONSE/URL/module}" />
      		
	      	<table class="fields">
	      		<xsl:call-template name="form-info-line">
	      			<xsl:with-param name="label" select="'Depth:'" />
	      			<xsl:with-param name="input">
	      				<select class="input-select" name="apply-depth" id="apply-depth">
		                    <xsl:for-each select="/RESPONSE/RESULTS/LIST[@name='PermissionsDepths']/*">
		                        <xsl:sort select="@label" />
		                        <option value="{@value}">
				                    <xsl:value-of select="@label"/>
		                        </option>
		                    </xsl:for-each>
	      				</select>
	      			</xsl:with-param>
	      		</xsl:call-template>
	      		<xsl:call-template name="form-info-line">
	      			<xsl:with-param name="label" select="'Type:'" />
	      			<xsl:with-param name="input">
	      				<select class="input-select" name="apply-type" id="apply-type">
		                    <xsl:for-each select="/RESPONSE/RESULTS/LIST[@name='PermissionsTargetsTypes']/*">
		                        <xsl:sort select="@label" />
		                        <option value="{@value}">
				                    <xsl:value-of select="@label"/>
		                        </option>
		                    </xsl:for-each>
	      				</select>
	      			</xsl:with-param>
	      		</xsl:call-template>      		
	      		<xsl:call-template name="form-empty-line" />
	      		
	   			<xsl:call-template name="form-info-line">
	      			<xsl:with-param name="label" select="'Permissions:'" />
	      			<xsl:with-param name="input">
						<input type="checkbox" class="input-checkbox" value="1" name="apply-allusers" id="apply-allusers" checked="checked"/>
						<label>All Users</label>
		  			</xsl:with-param>
	      		</xsl:call-template>
	   			<xsl:call-template name="form-info-line">
	      			<xsl:with-param name="label" select="''" />
	      			<xsl:with-param name="input">
						<input type="checkbox" class="input-checkbox" value="1" name="apply-allgroups" id="apply-allgroups" checked="checked"/>
						<label>All Groups</label>
		  			</xsl:with-param>
	      		</xsl:call-template>
	      		<xsl:call-template name="form-empty-line" />
	      		
	   			<xsl:call-template name="form-info-line">
	      			<xsl:with-param name="label" select="'Security:'" />
	      			<xsl:with-param name="input">
						<input type="checkbox" class="input-checkbox" value="1" name="apply-mainowner" id="apply-mainowner" checked="checked"/>
						<label>Main Owner</label>
		  			</xsl:with-param>
	      		</xsl:call-template>
	   			<xsl:call-template name="form-info-line">
	      			<xsl:with-param name="label" select="''" />
	      			<xsl:with-param name="input">
						<input type="checkbox" class="input-checkbox" value="1" name="apply-maingroup" id="apply-maingroup" checked="checked"/>
						<label>Main Group</label>
		  			</xsl:with-param>
	      		</xsl:call-template>
	      		<xsl:call-template name="form-empty-line" />
	      		
	   			<!--xsl:call-template name="form-info-line">
	      			<xsl:with-param name="label" select="'Options:'" />
	      			<xsl:with-param name="input">
						<input type="checkbox" class="input-checkbox" value="1" name="apply-aliased" id="apply-aliased"/>
						<label>Apply to aliased items</label>
		  			</xsl:with-param>
	      		</xsl:call-template>
	   			<xsl:call-template name="form-info-line">
	      			<xsl:with-param name="label" select="''" />
	      			<xsl:with-param name="input">
						<input type="checkbox" class="input-checkbox" value="1" name="apply-public" id="apply-public"/>
						<label>Apply to public items</label>
		  			</xsl:with-param>
	      		</xsl:call-template-->
	      		<xsl:call-template name="form-info-line">
	      			<xsl:with-param name="label" select="'Apply to:'" />
	      			<xsl:with-param name="input">
	      				<select class="input-select" name="apply-to" id="apply-to">
		                    <xsl:for-each select="/RESPONSE/RESULTS/LIST[@name='PermissionsTargets']/*">
		                        <xsl:sort select="@label" />
		                        <option value="{@value}">
		                        	<xsl:if test="@value='secureditems'">
		                        		<xsl:attribute name="selected">selected</xsl:attribute>
		                        	</xsl:if>
				                    <xsl:value-of select="@label"/>
		                        </option>
		                    </xsl:for-each>
	      				</select>
	      			</xsl:with-param>
	      		</xsl:call-template>
	      		<xsl:call-template name="form-empty-line" />
	      		
		       	<xsl:call-template name="form-info-line-submit">
		       		<xsl:with-param name="buttonLabel" select="'Apply'"/>
		       	</xsl:call-template>
	      	</table>
      	</form>
    </xsl:template>
    
    <xsl:template name="panel-add-js">
        $('#<xsl:value-of select="$formID" />').submit(function() {
          	fm = new FormManager(<xsl:value-of select="$panelID"/>, AppController);

			fm.onSuccess(function(response){
				<!-- status may be "info" -->
				if (response.status == 'success')
				{
					var statusDialog = new NotificationDialog('');	
					statusDialog.setTitle('<strong>Operation successful!</strong>');
					statusDialog.setStatusMessage('Security settings successfully applied on <strong>'+response.hits+'</strong> element(s).', 'Ok');
					statusDialog.show();
				}
			});
			
			fm.setScript('<xsl:apply-templates select="$item" mode="element-script-apply-security"/>');
		
			fm.displayProcess('Applying permissions...');		    
			fm.parseAndSend(this);
		
			return false;
        });
    </xsl:template>
</xsl:stylesheet>