<?php
/*
Officity - Web application platform - Version 6.0 - 2011-07-05

François Dispaux, Boris Verdeyen, Thomas Hermant,
Jérémie Roy, Grégory Meurice, Abdelila Harbi, 
Marc Mignonsin, Jonathan Sanchez, Julien Gonzalez, Pierre Fouchez

Sushee and Officity is © Copyright 2011 Nectil SA.

`/sushee-source/sushee/common/fastxml.class.php` is part of Officity.

Sushee is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

Officity and Sushee are distributed in the hope that they will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Sushee. If not, see <http://www.gnu.org/licenses/>.
*/
require_once(dirname(__FILE__)."/../common/nectil_object.class.php");

class FastXMLParser extends SusheeObject{
	var $xml_str;
	var $start_openingtag_pos = false;
	var $end_openingtag_pos = false;
	var $start_closingtag_pos = false;
	var $end_closingtag_pos = false;
	
	function FastXMLParser($xml_str){
		$this->xml_str = $xml_str;
	}
	
	function getNextElement($tagname){
		$this->logFunction('FastXMLParser.getNextElement ');
		$start_openingtag_pos = strpos($this->xml_str,'<'.$tagname.'>',$this->end_closingtag_pos);
		if($start_openingtag_pos===false){
			$start_openingtag_pos = strpos($this->xml_str,'<'.$tagname.' ',$this->end_closingtag_pos);
		}
		if($start_openingtag_pos !== false){
			$end_openingtag_pos = strpos($this->xml_str,'>',$start_openingtag_pos);
			if($end_openingtag_pos !== false){
				$end_openingtag_pos++;
				$start_closingtag_pos = strpos($this->xml_str,'</'.$tagname,$start_openingtag_pos);
				if($start_closingtag_pos !== false){
					$end_closingtag_pos = strpos($this->xml_str,'>',$start_openingtag_pos);
					if($end_closingtag_pos !== false){
						$end_closingtag_pos++;
						
						$this->start_openingtag_pos = $start_openingtag_pos;
						$this->end_openingtag_pos = $end_openingtag_pos;
						$this->start_closingtag_pos = $start_closingtag_pos;
						$this->end_closingtag_pos = $end_closingtag_pos;
						
						$content = substr($this->xml_str,$this->end_openingtag_pos,$this->start_closingtag_pos - $this->end_openingtag_pos);
						
						return new FastXMLParser($content);
						return true;
					}
				}
			}
			
			
		}
		return false;
	}
	
	function toString(){
		$this->logFunction('FastXMLParser.toString');
		return $this->xml_str;
	}
	
}


?>