<?php
/*
Officity - Web application platform - Version 6.0 - 2011-07-05

François Dispaux, Boris Verdeyen, Thomas Hermant,
Jérémie Roy, Grégory Meurice, Abdelila Harbi, 
Marc Mignonsin, Jonathan Sanchez, Julien Gonzalez, Pierre Fouchez

Sushee and Officity is © Copyright 2011 Nectil SA.

`/sushee-source/sushee/common/nectil_user.class.php` is part of Officity.

Sushee is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

Officity and Sushee are distributed in the hope that they will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Sushee. If not, see <http://www.gnu.org/licenses/>.
*/
require_once(dirname(__FILE__)."/../common/common_functions.inc.php");
require_once(dirname(__FILE__)."/../common/nectil_object.class.php");
require_once(dirname(__FILE__)."/../common/nectil_element.class.php");



class NectilUser extends SusheeObject{
	
	
	var $keyring = false;
	var $contactElt = false;
	
	function NectilUser(){
		
	}
	
	function hasModule($module){
		if($module->getActionSecurity("SEARCH")!==false){
			return true;
		}else{
			return false;
		}
	}
	
	function hasApplication($application){
		if(!is_object($application)){
			return false;
		}
		if($application->className()=='customapplication'){
			return true;
		}
		$db_conn = db_connect();
		$applicationID = $application->getID();
		if(!$applicationID){
			return false;
		}
		$sql = 'SELECT perm. * FROM `applicationkeys` AS perm, `dependencies` AS ksetUsers, `dependencies` AS ksetKeys WHERE ksetUsers.`DependencyTypeID` =3 AND ksetKeys.`DependencyTypeID` =5 AND ksetUsers.`TargetID` =\''.$this->getID().'\' AND ksetKeys.`OriginID` = ksetUsers.`OriginID` AND ksetKeys.`TargetID` = perm.`ID` AND perm.`ApplicationToID` =\''.$applicationID.'\';';
		$this->logSQL($sql);
		$count_sql = "SELECT COUNT(*) AS ct FROM `applicationkeys` WHERE `ApplicationToID`='".$applicationID."';";
		$this->logSQL($count_sql);
		$count_row = $db_conn->GetRow($count_sql);
		
		$security_row = $db_conn->GetRow($sql);
		
		$keyring = $this->getKeyring();
		if(!$keyring)
			return false;
		$keyringID = $keyring->getID();
		if ($this->getID() && ($security_row || ($count_row['ct']=='0' && $keyringID==2)) )
			return true;
		return false;
	}
	
	function getApplicationKey($application){
		$db_conn = db_connect();
		$applicationID = $application->getID();
		if(!$applicationID){
			return false;
		}
		$sql = 'SELECT perm. * FROM `applicationkeys` AS perm, `dependencies` AS ksetUsers, `dependencies` AS ksetKeys WHERE ksetUsers.`DependencyTypeID` =3 AND ksetKeys.`DependencyTypeID` =5 AND ksetUsers.`TargetID` =\''.$this->getID().'\' AND ksetKeys.`OriginID` = ksetUsers.`OriginID` AND ksetKeys.`TargetID` = perm.`ID` AND perm.`ApplicationToID` =\''.$applicationID.'\';';
		$this->logSQL($sql);
		$security_row = $db_conn->GetRow($sql);
		if($security_row){
			$key = new ApplicationKey($security_row);
			return $key;
		}
		return false;
	}
	
	function getKeyring(){
		if($this->keyring===false){
			$db_conn = db_connect();
			$keyring_sql = 'SELECT `OriginID` FROM `dependencies` WHERE `TargetID`=\''.$this->getID().'\' AND `DependencyTypeID`=\'3\'';
			$this->logSQL($keyring_sql);
			$keyring_row = $db_conn->GetRow($keyring_sql);
			if(!$keyring_row){
				return false;
			}
			$keyringID = $keyring_row['OriginID'];
			$this->keyring = new Keyring($keyringID);
		}
		return $this->keyring;
	}
	
	function setID($ID){
		session_start();
		$_SESSION[$GLOBALS["nectil_url"]]['SESSIONuserID'] = $ID;
		session_write_close();
		return $_SESSION[$GLOBALS["nectil_url"]]['SESSIONuserID'];
	}
	
	function isAuthentified(){
		return isset($_SESSION[$GLOBALS["nectil_url"]]['SESSIONuserID']);
	}
	
	function isAuthenticated(){
		return $this->isAuthentified();
	}
	
	
	static function getID(){
		return $_SESSION[$GLOBALS["nectil_url"]]['SESSIONuserID'];
	}
	
	function setSessionPassword($password){
		session_start();
		$_SESSION[$GLOBALS["nectil_url"]]['password'] = $new_crypt_password = sha1($password);
		session_write_close();
		return $new_crypt_password;
	}
	
	function getSessionPassword(){
		if(!isset($_SESSION[$GLOBALS["nectil_url"]]['password']))
			return false;
		return $_SESSION[$GLOBALS["nectil_url"]]['password'];
	}
	
	function loadContactElement(){
		if($this->contactElt==false){
			$this->contactElt = new Contact($this->getID());
			$this->contactElt->loadFields();
		}
	}
	
	function getField($name){
		$this->loadContactElement();
		if($this->contactElt){
			return $this->contactElt->getField($name);
		}else
			return false;
	}
	
	function getIP(){
		return $_SERVER['REMOTE_ADDR'];
	}
	
	function getCountryID(){
		$ip = $this->getIP();
		
		if(!$ip){
			return false;
		}
		
		$num_ip = str_replace('.','',$ip);
		if(!is_numeric($num_ip)){
			return false;
		}
		$db_conn = db_connect(true);
		$slots = explode(".",$ip);
		$ipsolved = $slots[0] * 16777216 + $slots[1] * 65536 + $slots[2] * 256 + $slots[3];

		$sql = "SELECT `iso3` FROM `ipv4` WHERE /*".$ip."*/  `from` < " . ($ipsolved+1) . " AND `to` > " . ($ipsolved-1) . " LIMIT 0,1;";
		$this->log($sql);
		
		$row = $db_conn->getRow($sql);
		if(!$row)
			return false;
		return $row['iso3'];
	}
	
	function getProvider(){
		return $_SERVER['REMOTE_HOST'];
	}
	
	function getUserAgent(){
		return $_SERVER['HTTP_USER_AGENT'];
	}
	
	function getSushee_Request(){
		return new Sushee_Request();
	}
	
	function authenticate($login,$password){
		login($login,$password);
		if($_SESSION[$GLOBALS["nectil_url"]]['SESSIONuserID']){
			return true;
		}
		return false;
	}
	
	function connect($login,$password){
		$this->authenticate($login,$password);
	}
	
	function logout(){
		logout();
	}
	
	function disconnect(){
		$this->logout();
	}
	
	function isInTeam($groupID){
		$groupModuleInfo = moduleInfo('group');
		$teamIDs = $groupModuleInfo->teamIDs;
		
		if(in_array($groupID,$teamIDs)){
			return true;
		}
		return false;
	}
	
	function registerLoginObject($loginObject){
		if(is_object($loginObject)){
			session_start();
			$_SESSION[$GLOBALS["nectil_url"]]['loginObjectID'] = $loginObject->getID();
			session_write_close();
		}
	}
	
	function getLoginObject(){
		if(isset($_SESSION[$GLOBALS["nectil_url"]]['loginObjectID'])){
			return new LoginModuleElement($_SESSION[$GLOBALS["nectil_url"]]['loginObjectID']);
		}
		return false;
	}
}

class OfficityUser extends NectilUser{
	
}

class Sushee_User extends NectilUser{
	
}

class Sushee_Request extends SusheeObject{
	function Sushee_Request(){
		;
	}
	
	function getDate(){
		require_once(dirname(__FILE__)."/../common/date.class.php");
		return new Date($GLOBALS["sushee_today"]); 
	}
	
	function getDateSQL(){
		return $GLOBALS["sushee_today"];
	}
	
	function getUser(){
		return new NectilUser();
	}
	
	function getResident(){
		require_once(dirname(__FILE__)."/../common/nectil_element.class.php");
		return new Resident($GLOBALS['residentID']);
	}
	
	function getDatabase(){
		require_once(dirname(__FILE__)."/../common/db_manip.class.php");
		return new Database($GLOBALS['db_name']);
	}
	
	function getResidentName(){
		return $GLOBALS['resident_name'];
	}
	
	function isOsRequest(){
		return ($GLOBALS['php_request']!==true);
	}
	
	function isProjectRequest(){
		return ($GLOBALS['php_request']==true);
	}
	
	static function isSecured(){
		return (!$GLOBALS["dev_request"]===TRUE);
	}
	
	function getLanguage(){
		return $GLOBALS["NectilLanguage"];
	}
	
	function isLanguageRestricted(){
		return ($GLOBALS["restrict_language"] && $GLOBALS['php_request']==true);
	}
	
	function isOnSharedModules(){
		$db_conn = db_connect();
		if(!isset($GLOBALS['shared_modules'])){
			// first trying in specific table then only in generic table
			$row = $db_conn->GetRow('SELECT `ID` FROM `modules` LIMIT 0,1');
			if($row){
				$GLOBALS['shared_modules']=false;
			}else{
				$GLOBALS['shared_modules']=true;
			}
		}
		return $GLOBALS['shared_modules'];
	}
	
	function isOnSharedApplications(){
		$db_conn = db_connect();
		if(!isset($GLOBALS['shared_applications'])){
			// first trying in specific table then only in generic table
			$row = $db_conn->GetRow('SELECT `ID` FROM `applications` LIMIT 0,1');
			if($row){
				$GLOBALS['shared_applications']=false;
			}else{
				$GLOBALS['shared_applications']=true;
			}
		}
		return $GLOBALS['shared_applications'];
	}
	
	function getModuleDbConn(){
		if($this->isOnSharedModules()){
			$db_conn = db_connect(TRUE);
		}else{
			$db_conn = db_connect();
		}
		return $db_conn;
	}
	
	function getApplicationDbConn(){
		if($this->isOnSharedApplications()){
			$db_conn = db_connect(TRUE);
		}else{
			$db_conn = db_connect();
		}
		return $db_conn;
	}
	
	function useCache(){
		if($_GET['cache']!=='false' && $_GET['cache']!=='refresh'){
			return true;
		}
		return false;
	}
	
	function refreshCache(){
		if($_GET['cache']=='refresh'){
			return true;
		}
		return false;
	}
}
?>