<?php
/*
Officity - Web application platform - Version 6.0 - 2011-07-05

François Dispaux, Boris Verdeyen, Thomas Hermant,
Jérémie Roy, Grégory Meurice, Abdelila Harbi, 
Marc Mignonsin, Jonathan Sanchez, Julien Gonzalez, Pierre Fouchez

Sushee and Officity is © Copyright 2011 Nectil SA.

`/sushee-source/sushee/common/registers.class.php` is part of Officity.

Sushee is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

Officity and Sushee are distributed in the hope that they will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Sushee. If not, see <http://www.gnu.org/licenses/>.
*/
require_once(dirname(__FILE__)."/../common/nectil_object.class.php");
require_once(dirname(__FILE__)."/../common/datas_structure.class.php");

class Register extends SusheeObject{
	var $name = false;
	var $vect = false;
	function Register($name){
		if(isset($GLOBALS['register'][$name])){
			$this->vect = &$GLOBALS['register'][$name];
		}else{
			$vect = &new Vector();
			$this->vect = &$vect;
			$GLOBALS['register'][$name] = &$vect;
		}
	}
	
	function add($ID,&$element){
		$this->vect->add($ID,$element);
	}
	
	function &getElement($ID){
		$elt = &$this->vect->getElement($ID);
		return $elt;
	}
	
	function exists($ID){
		return $this->vect->exists($ID);
	}
	function &next(){
		$elt = &$this->vect->next();
		return $elt;
	}
	
	function reset(){
		$this->vect->reset();
	}
}

class MailsAccountRegister extends Register{
	
	function MailsAccountRegister(){
		Register::Register('MailsAccountRegister');
	}
	
	function &getElement($ID){
		if(!$this->vect->exists($ID)){
			$elt = &new MailsAccount(array('ID'=>$ID));
			$elt->loadFields();
			$this->add($ID,$elt);
			return $elt;
		}else{
			$elt = &$this->vect->getElement($ID);
			return $elt;
		}
	}
}

?>