<?php
/*
Officity - Web application platform - Version 6.0 - 2011-07-05

François Dispaux, Boris Verdeyen, Thomas Hermant,
Jérémie Roy, Grégory Meurice, Abdelila Harbi, 
Marc Mignonsin, Jonathan Sanchez, Julien Gonzalez, Pierre Fouchez

Sushee and Officity is © Copyright 2011 Nectil SA.

`/sushee-source/sushee/common/url.class.php` is part of Officity.

Sushee is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

Officity and Sushee are distributed in the hope that they will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Sushee. If not, see <http://www.gnu.org/licenses/>.
*/
require_once(dirname(__FILE__)."/../common/nectil_object.class.php");
class URL extends SusheeObject{
	var $url;
	var $output;
	var $method='GET';
	var $params = array();

	function URL($url){
		$this->url = $url;
	}
	
	function getFilename(){
		$pos_last_slash = strrpos($this->url,'/');
		if($pos_last_slash!==false){
			return substr($this->url,$pos_last_slash+1);
		}else{
			return false;
		}
	}
	
	function setMethod($method){
		if(strtolower($method)=='get'){
			$this->method = 'get';
			return true;
		}else if(strtolower($method)=='post'){
			$this->method = 'post';
			return true;
		}
	}
	
	function addParam($name,$value){
		$this->params[$name]=$value;
	}
	
	function getParamString(){
		$separator = '';
		$params_str = '';
		foreach($this->params as $name=>$value){
			$params_str.=$separator;
			$params_str.=$name.'='.urlencode($value);
			$separator = '&';
		}
		if($params_str && $this->method=='get' && strpos($this->url,'?')===false){
			return '?'.$params_str;
		}
		return $params_str;
	}

	function execute(){
		$response = false;
		
		$params_str = $this->getParamString();
		
		if(extension_loaded('curl')){
			$curl = curl_init();

			// Setup headers - I used the same headers from Firefox version 2.0.0.6
			// below was split up because php.net said the line was too long. :/
			$header[0] = "Accept: text/xml,application/xml,application/xhtml+xml,";
			$header[0] .= "text/html;q=0.9,text/plain;q=0.8,image/png,*/*;q=0.5";
			$header[] = "Cache-Control: max-age=0";
			$header[] = "Connection: keep-alive";
			$header[] = "Keep-Alive: 300";
			$header[] = "Accept-Charset: ISO-8859-1,utf-8;q=0.7,*;q=0.7";
			$header[] = "Accept-Language: en-us,en;q=0.5";
			$header[] = "Pragma: "; // browsers keep this blank.

			curl_setopt($curl, CURLOPT_URL, $this->url);
			curl_setopt($curl, CURLOPT_USERAGENT, 'Sushee (+http://www.sushee.eu)');
			curl_setopt($curl, CURLOPT_HTTPHEADER, $header);
			curl_setopt($curl, CURLOPT_REFERER, 'http://www.sushee.eu');
			curl_setopt($curl, CURLOPT_ENCODING, 'gzip,deflate');
			curl_setopt($curl, CURLOPT_AUTOREFERER, true);
			curl_setopt($curl, CURLOPT_RETURNTRANSFER, 1);
			curl_setopt($curl, CURLOPT_TIMEOUT, 900);
			curl_setopt($curl, CURLOPT_CONNECTTIMEOUT, 30);
			curl_setopt($curl, CURLOPT_FAILONERROR, false);
			if($this->method=='post'){
				curl_setopt($curl, CURLOPT_POST,1);
				if($params_str){
					curl_setopt($curl,CURLOPT_POSTFIELDS,$params_str);
				}
			}else if($params_str){
				curl_setopt($curl, CURLOPT_URL, $this->url.$params_str);
			}
			$this->log($this->url.$params_str);
			$response = curl_exec($curl);
			if($response===false)
				$this->log(curl_error($curl));
			curl_close($curl);
		}else{
			$this->log($this->url.$params_str);
			$fp = @fopen($this->url.$params_str,'r');
			if($fp){
				while (!feof ($fp)) {
					$buffer = fgets($fp, 64);
					$response.=$buffer;
				  }
				  fclose ($fp);
			}else{
				return false;
			}
		}


		$this->output = $response;
		return $response;
	}

	function getOutput(){
		return $this->output;
	}
}

?>