<?php
/*
Officity - Web application platform - Version 6.0 - 2011-07-05

François Dispaux, Boris Verdeyen, Thomas Hermant,
Jérémie Roy, Grégory Meurice, Abdelila Harbi, 
Marc Mignonsin, Jonathan Sanchez, Julien Gonzalez, Pierre Fouchez

Sushee and Officity is © Copyright 2011 Nectil SA.

`/sushee-source/sushee/private/backupModule.inc.php` is part of Officity.

Sushee is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

Officity and Sushee are distributed in the hope that they will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Sushee. If not, see <http://www.gnu.org/licenses/>.
*/
require_once(dirname(__FILE__).'/../common/nqlOperation.class.php');
require_once(dirname(__FILE__).'/../common/db_manip.class.php');
require_once(dirname(__FILE__).'/../common/nectil_user.class.php');

/*
Backup the table of a module (only INFO at the moment)

<BACKUP>
	<MODULE ID="" />
</BACKUP>

<BACKUP>
	<MODULE denomination="" />
</BACKUP>

<BACKUP>
	<MODULE>
		<INFO>
			<DENOMINATION></DENOMINATION>
		</INFO>
	</MODULE>
</BACKUP>

*/

class sushee_backupModule extends NQLOperation{
	
	var $moduleID = false;
	
	function setModule($moduleInfo){
		$this->moduleID = $moduleInfo->getID();
	}
	
	function getModule(){
		return moduleInfo($this->moduleID);
	}
	
	function parse(){
		$ID = $this->firstNode->getAttribute('ID');
		if($ID){
			$moduleInfo = moduleInfo($ID);
		}else{
			$denomination = $this->firstNode->getAttribute('denomination');
			if(!$denomination){
				$denomination = $this->firstNode->valueOf('INFO/DENOMINATION');
			}
			if($denomination){
				$moduleInfo = moduleInfo($denomination);
			}
		}
		if($moduleInfo){
			
			if(!$moduleInfo->loaded){
				$this->setError('Module `'.$moduleInfo->getName().'` does not exist or is forbidden to you');
				return false;
			}
			$this->setModule($moduleInfo);
			return true;
		}
		$this->setError('Please give the ID or the denomination of the module to backup');
		return false;
	}
	
	function operate(){
		$moduleInfo = $this->getModule();
		
		$table = new DatabaseTable(false,$moduleInfo->getTableName());
		$backup_name = $moduleInfo->getTableName().'-'.date('Ymd').'-'.date('H').'h'.date('i').'-'.Sushee_User::getID();
		$res = $table->duplicate($backup_name);
		if(!$res){
			$this->setError('Table duplication failed : '.$table->getError());
			return false;
		}
		
		$this->setSuccess('`'.$moduleInfo->getTableName().'` copied to `'.$backup_name.'`');
		
		return true;
	}
	
}



?>