<?php
/*
Officity - Web application platform - Version 6.0 - 2011-07-05

François Dispaux, Boris Verdeyen, Thomas Hermant,
Jérémie Roy, Grégory Meurice, Abdelila Harbi, 
Marc Mignonsin, Jonathan Sanchez, Julien Gonzalez, Pierre Fouchez

Sushee and Officity is © Copyright 2011 Nectil SA.

`/sushee-source/sushee/private/distinctField.inc.php` is part of Officity.

Sushee is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

Officity and Sushee are distributed in the hope that they will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Sushee. If not, see <http://www.gnu.org/licenses/>.
*/
require_once(dirname(__FILE__).'/../common/nqlOperation.class.php');
require_once(dirname(__FILE__)."/../private/metaSearch.inc.php");

/*

<DISTINCT>
	<CONTACT>
		<INFO>
			<CONTACTTYPE/>
		</INFO>
		[<WHERE><!-- pas encore implémenté -->
			...
		</WHERE>]
	</CONTACT>
</DISTINCT>

*/

class sushee_distinctField extends RetrieveOperation{
	
	function parse(){
		$moduleInfo = moduleInfo($this->firstNode->nodename());
		if(!$moduleInfo->loaded){
			$this->setError('Forbidden or unknown module name `'.$this->firstNode->nodename().'`');
			return false;
		}
		
		if(!$this->firstNode->exists('INFO/*')){
			$this->setError('Missing the field to distinct <INFO><fieldname/></INFO>');
			return false;
		}
		
		
		return true;
	}
	
	function operate(){
		$firstNode = $this->firstNode->nodename();
		$moduleInfo = moduleInfo($this->firstNode->nodename());
		
		// field to distinct
		$fieldname = $this->firstNode->getElement('INFO/*')->nodeName();
		$field = $moduleInfo->getField($fieldname);
		if(!$field){
			$this->setError('Field `'.$fieldname.'` doesnt exist in `'.$moduleInfo->getName().'`');
			return false;
		}
		
		// distinct on a selection of elements
		$where_node = $this->firstNode->getElement("WHERE[1]");
		$where_sql = '';
		if( $where_node ){
			
			
			// composing a smaller XML with only a SEARCH command with the content of the WHERE
			$small_xml = new XML(
				'<SEARCH><'.$firstNode.'>'.$where_node->toString().'</'.$firstNode.'><RETURN><NOTHING/></RETURN></SEARCH>');
			// we apply preprocessing to have the extension boolean added
			$preprocess = $moduleInfo->preProcess('SEARCH',false,$small_xml->getElement('/SEARCH'),$former_values,$new_values,$return_values);	
				
			$where_sql = "";
			$where_rs = getResultSet($moduleInfo,$small_xml,'/SEARCH[1]',$where_sql);
			// the SQL request in order to resolve the WHERE failed : we return the error to the user
			if (is_string($where_rs)){
				$this->setError($where_rs);
				return false;
			}
				
			if (!$where_rs){
				$this->setError($db_conn->ErrorMsg().$where_sql);
				return false;
			}
			
			// we have the elements IDs, checking all of them can be deleted (no locked or private elements)
			$IDs = '-1';
			while($search_row = $where_rs->FetchRow()){
				$IDs.=',';
				$IDs.=$search_row['ID'];
			}
			$where_sql = 'WHERE `ID` IN('.$IDs.')';
		}
		
		$sql = 'SELECT `'.$field->getName().'`,COUNT(*) as hits FROM `'.$moduleInfo->getTableName().'` '.$where_sql.' GROUP BY `'.$field->getName().'`';
		$db_conn = db_connect();
		$rs = $db_conn->execute($sql);
		if(!$rs){
			$this->setError($db_conn->ErrorMsg());
			return false;
		}
		$xml='<RESULTS '.$this->getOperationAttributes().'>';
		while($row = $rs->FetchRow()){
			$xml.=$field->encodeForNQL($row[$field->getName()],' hits="'.$row['hits'].'"');
		}
		$xml.='</RESULTS>';
		$this->setXML($xml);
		return true;
	}
	
}

?>