<?php
/*
Officity - Web application platform - Version 6.0 - 2011-07-05

François Dispaux, Boris Verdeyen, Thomas Hermant,
Jérémie Roy, Grégory Meurice, Abdelila Harbi, 
Marc Mignonsin, Jonathan Sanchez, Julien Gonzalez, Pierre Fouchez

Sushee and Officity is © Copyright 2011 Nectil SA.

`/sushee-source/sushee/private/media_processing.class.php` is part of Officity.

Sushee is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

Officity and Sushee are distributed in the hope that they will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Sushee. If not, see <http://www.gnu.org/licenses/>.
*/

class sushee_friendlyTitleBuilder{
	
	function encode($str){
		$to_replace = array('.','&','?','#',' ','%','/',':',',',"'",'"',';','+');
		$replacment = '-';
		$str = decode_from_xml($str);
		$str = removeaccents($str);
		$str = strtolower($str);
		$str = trim($str);
		// replacing special chars by dashes
		$str = str_replace($to_replace,$replacment,$str);
		// removing duplicate dashes
		$str = preg_replace('{(-)\1+}','$1',$str);
		// removing last dash if at end
		if(substr($str,-1)=='-'){
			$str = substr($str,0,-1);
		}
		return $str;
	}
	
	function preprocess($data){
		$node = $data->getNode();
		if($node && $node->exists('*[1]/DESCRIPTIONS/DESCRIPTION/TITLE')){
			$descriptions = $node->getElements('*[1]/DESCRIPTIONS/DESCRIPTION');
			foreach($descriptions as $description){
				$title = $description->valueOf('TITLE');
				//$friendlytitle = $description->valueOf('FRIENDLYTITLE'); // would allow update of the frirendly separately but is not compatible with Officity OS
				if($title /*&& !$friendlytitle*/){
					$friendlytitle = $this->encode($title);
					if($description->exists('FRIENDLYTITLE')){
						$friendlyNode = $description->getElement('FRIENDLYTITLE');
						$friendlyNode->setValue($friendlytitle);
					}else{
						$description->appendChild('<FRIENDLYTITLE>'.encode_to_xml($friendlytitle).'</FRIENDLYTITLE>');
					}
					return new SusheeProcessorMessage('Friendly title is `'.$friendlytitle.'`');
				}
			}
			
		}
		return new SusheeProcessorMessage('No new friendly title generated');
		return true;
	}
	
	function postprocess($data){
		return true;
	}
}

class sushee_CREATE_MEDIA_processor extends sushee_friendlyTitleBuilder{
	
}

class sushee_UPDATE_MEDIA_processor extends sushee_friendlyTitleBuilder{
	
}


?>