<?php
/*
Officity - Web application platform - Version 6.0 - 2011-07-05

François Dispaux, Boris Verdeyen, Thomas Hermant,
Jérémie Roy, Grégory Meurice, Abdelila Harbi, 
Marc Mignonsin, Jonathan Sanchez, Julien Gonzalez, Pierre Fouchez

Sushee and Officity is © Copyright 2011 Nectil SA.

`/sushee-source/sushee/private/searchLabels.inc.php` is part of Officity.

Sushee is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

Officity and Sushee are distributed in the hope that they will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Sushee. If not, see <http://www.gnu.org/licenses/>.
*/
require_once(dirname(__FILE__).'/../private/metaSearch.inc.php');

class sushee_searchLabels extends RetrieveOperation{
	
	function parse(){
		
		return true;
	}
	
	function operate(){
		$db_conn = db_connect();

		$languageID = $this->firstNode->valueOf('@languageID');
		if(!$languageID)
			$languageID = $GLOBALS["NectilLanguage"];

		// forcing the attributes to be transformed as node in INFO, WHERE to be removed, etc, to have a clean NQL request
		canonicalizeNQL($this->firstNode->getDocument(),$this->firstNode->getPath());

		$condition = ''; // all labels
		$search_nodes = $this->firstNode->getElements('INFO/*');

		// vector with nodenames and their matching fieldname
		$fieldnames = array('NAME'=>'Denomination','DENOMINATION'=>'Denomination','VALUE'=>'Text','TEXT'=>'Text');

		// foreach nodes, adding a corresponding sql crit
		foreach($search_nodes as $node){
			// matching the nodename with the real fieldname
			$nodename = $node->nodename();
			$fieldname = false;
			if(isset($fieldnames[$nodename])){
				$fieldname = $fieldnames[$nodename];

				// handling operators
				$operator = $node->getxSusheeOperator();
				// user can add ' number' at the end of the operator to force the field to be treated as a number
				$casttonumber = false;
				if(substr($operator,-7)==' number'){
					$operator = substr($operator,0,-7);
					$casttonumber = '+0 ';
				}
				$value = encode_for_db($node->valueOf());

				// composing the sql
				$condition.=' AND `'.$fieldname.'`'.$casttonumber.' ';
				switch($operator){
					case '=':
						$condition.='= "'.$value.'"';
						break;
					case 'starts-with':
						$condition.='LIKE "'.$value.'%"';
						break;
					case 'ends-with':
						$condition.='LIKE "%'.$value.'"';
						break;
					case 'GT':
						$condition.='> "'.$value.'"';
						break;
					case 'GT=':
						$condition.='>= "'.$value.'"';
						break;
					case 'LT':
						$condition.='< "'.$value.'"';
						break;
					case 'LT=':
						$condition.='<= "'.$value.'"';
						break;
					default:
						$condition.='LIKE "%'.$value.'%"';
				}
			}

		}

		$sql = 'SELECT * FROM `labels` WHERE ';
		if($languageID!=='all'){
			$sql.='`LanguageID` IN ("'.$languageID.'","shared")';
		}else{
			$sql.='1 = 1';
		}
		$sql.=' '.$condition;
		sql_log($sql);
		$rs = $db_conn->Execute($sql);
		if ($rs){
			$attributes = $this->getOperationAttributes();
			
			$query_result='<RESULTS'.$attributes.'>';
			while($row = $rs->FetchRow()){
				$query_result.='<LABEL name="'.$row['Denomination'].'" languageID="'.$row['LanguageID'].'">';
				$query_result.=$row['Text'];
				$query_result.='</LABEL>';
			}
			$query_result.='</RESULTS>';
			
			$this->setXML($query_result);
			return true;
		}else{
			$this->setError("Problem with the sql query *".$sql."*.");
			return false;
		}
	}
}
?>
