<?php
/*
Officity - Web application platform - Version 6.0 - 2011-07-05

François Dispaux, Boris Verdeyen, Thomas Hermant,
Jérémie Roy, Grégory Meurice, Abdelila Harbi, 
Marc Mignonsin, Jonathan Sanchez, Julien Gonzalez, Pierre Fouchez

Sushee and Officity is © Copyright 2011 Nectil SA.

`/sushee-source/sushee/private/showFilePreview.php` is part of Officity.

Sushee is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

Officity and Sushee are distributed in the hope that they will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Sushee. If not, see <http://www.gnu.org/licenses/>.
*/ 
require_once(dirname(__FILE__)."/../common/common_functions.inc.php");
require_once(dirname(__FILE__)."/../file/file_functions.inc.php");
require_once(dirname(__FILE__)."/../file/file_config.inc.php");
require_once(dirname(__FILE__)."/../common/image_functions.inc.php");

require_once(dirname(__FILE__)."/../private/checkLogged.inc.php");
session_write_close();
set_time_limit(300);
function previewFallback(){
	header("Content-type: image/jpg");
	$fn=fopen("./bkg.jpg","r");
	fpassthru($fn);
}
/*function my_is_utf8($string) {
   return (preg_match('/^([\x00-\x7f]|[\xc2-\xdf][\x80-\xbf]|\xe0[\xa0-\xbf][\x80-\xbf]|[\xe1-\xec][\x80-\xbf]{2}|
\xed[\x80-\x9f][\x80-\xbf]|[\xee-\xef][\x80-\xbf]{2}|f0[\x90-\xbf][\x80-\xbf]{2}|[\xf1-\xf3][\x80-\xbf]{3}|\xf4[\x80-\x8f][\x80-\xbf]{2})*$/', $string) === 1);
}*/
if (isset($_GET['target'])){
	$target = $_GET['target'];
	$basename = BaseFilename($target);
	global $directoryRoot;
	$path = $directoryRoot.$target;
	if(file_exists($path) && is_readable($path)){
		$ext = getFileExt($basename);
		if($ext=='png' || $ext=='gif' || $ext == 'svg' || $ext == 'tif' || $ext == 'tiff' || $ext == 'avi' || $ext == 'mpg' || $ext == 'mpeg' || $ext=='pdf' || $ext=='jpg' || $ext=='jpeg'){
			$filesize = filesize($path);
			if($filesize<2048000){
				$convert_xml = new XML('<TRANSFORMATION><convert format="jpg"/></TRANSFORMATION>');
				$resultFile = imageCreation($convert_xml,"/TRANSFORMATION[1]",$path);
			}else
			debug_log("Image $path too heavy!".$filesize);
		}else if($ext=='pdf'){
			$filesize = filesize($path);
			if($filesize<2048000){
				$convert_xml = new XML('<TRANSFORMATION><convert format="jpg"/></TRANSFORMATION>');
				$resultFile = imageCreation($convert_xml,"/TRANSFORMATION[1]",$path);
			}else
			debug_log("Image $path too heavy!".$filesize);
		}else if($ext=='txt' || $ext=='xml' || $ext=='nql' || $ext=='sql' || $ext=='csv' || $ext=='css' || $ext=='xsl' || $ext=='vcf' || $ext=='htm' || $ext=='html' || $ext=='css' || $ext=='as'){
			ini_set('auto_detect_line_endings','1');
			$handle = fopen($path, "r");
			if(!isset($_GET['maxlines']))
			$lines = 20;
			else
			$lines = $_GET['maxlines'];
			$i = 0;
			$str='<RESPONSE><FILECONTENT maxlines="'.$lines.'">';
			while (!feof($handle) && $i<$lines) {
				$buffer = fgets($handle, 4096);
				$str.=encode_to_XML($buffer);
				$i++;
			}
			if(is_utf8($str))
				$str = utf8_decode(utf8_To_UnicodeEntities($str)); // entity before decoding ( to avoid to loose pure utf8 characters)
			
			$str.='</FILECONTENT></RESPONSE>';
			xml_out($str);
			$resultFile = false;//textCreation('Bonjour','wrap',150);
		}
		if($resultFile && file_exists($resultFile) && filesize($resultFile)>0){
			$filesize=filesize($resultFile);
			header("Pragma: public");
			header("Expires: 0"); // set expiration time
			header("Cache-Control: must-revalidate, post-check=0, pre-check=0");
			header("Content-Transfer-Encoding: Binary");
			header("Connection: close");
			header("Content-type: image/jpg");
			header("Content-length: ".$filesize);
			
			//$fn=fopen($resultFile,"r");
			//fpassthru($fn);
			$fp = fopen($resultFile, 'rb');
			//$file_buffer = fread($fp, $filesize);
			while (!feof ($fp)) {
				print(fread($fp, 1024*8));
				flush();
			}
			fclose ($fp);
		}else
			previewFallback();
	}else
		xml_out("<?xml version='1.0'?><RESPONSE>".generateMsgXML(1,"File $path doesn't exist.")."</RESPONSE>");
}else
	xml_out("<?xml version='1.0'?><RESPONSE>".generateMsgXML(1,"No target was given.")."</RESPONSE>");
?>
