<?php
/*
Officity - Web application platform - Version 6.0 - 2011-07-05

François Dispaux, Boris Verdeyen, Thomas Hermant,
Jérémie Roy, Grégory Meurice, Abdelila Harbi, 
Marc Mignonsin, Jonathan Sanchez, Julien Gonzalez, Pierre Fouchez

Sushee and Officity is © Copyright 2011 Nectil SA.

`/sushee-source/sushee/private/updateApplication.inc.php` is part of Officity.

Sushee is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

Officity and Sushee are distributed in the hope that they will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Sushee. If not, see <http://www.gnu.org/licenses/>.
*/
require_once(dirname(__FILE__).'/../common/nqlOperation.class.php');
require_once(dirname(__FILE__).'/../common/namespace.class.php');
require_once(dirname(__FILE__).'/../common/nectil_publisher.class.php');

class updateApplication extends NQLOperation{
	
	var $denomination;
	var $publisher = false;
	
	function setPublisher($publisher){
		$this->publisher = $publisher;
	}
	
	function getPublisher(){
		return $this->publisher;
	}
	
	function parse(){
		$denomination = $this->firstNode->valueOf('INFO/DENOMINATION');
		if(!$denomination){
			$this->setError('No name was provided for the application to update');
			return false;
		}else{
			$this->denomination = $denomination;
			
		}
		
		$publisherNode = $this->firstNode->getElement('PUBLISHER');
		if(!$publisherNode){
			$this->setError('No publisher was provided for the application to be created');
			return false;
		}
		$publisherLogin = $publisherNode->valueOf('LOGIN');
		$publisherPassword = $publisherNode->valueOf('PASSWORD');
		if(!$publisherLogin || !$publisherPassword){
			$this->setError('Login or password for publisher was not set');
			return false;
		}
		
		
		$publisher = new NectilPublisher();
		$res = $publisher->authenticate($publisherLogin,$publisherPassword);
		if(!$res){
			$this->setError('This publisher is not referenced on officity.com');
			return false;
		}
		
		$this->publisher = $publisher;
		$namespace = $publisher->getNamespace();
		if(substr($this->denomination,0,strlen($namespace->getName())+1)==$namespace->getName().':'){
			$this->denomination = substr($this->denomination,strlen($namespace->getName())+1);
		}
		$applicationName = $namespace->getName().':'.$this->denomination;
		// checking there is no application already with this name
		$sql = 'SELECT `ID` FROM `applications` WHERE `Denomination`="'.encodeQuote($applicationName).'";';
		$db_conn = db_connect();
		$this->logSQL($sql);
		$row = $db_conn->getRow($sql);
		if(!$row){
			$this->setError('There is no application with this denomination');
			return false;
		}
		$this->ID = $row['ID'];
		
		return true;
	}
	
	function getID(){
		return $this->ID;
	}
	
	function operate(){
		$namespace = $this->publisher->getNamespace();
		
		$namespace->register();
		$applicationName = $namespace->getName().':'.$this->denomination;
		$db_conn = db_connect();
		if($this->firstNode->getElement('INFO/DOCKABLE')){
			$dockable = $this->firstNode->valueOf('INFO/DOCKABLE');
			$sql = 'UPDATE `applications` SET `Dockable` = \''.$dockable.'\' WHERE `ID`=\''.$this->getID().'\';';
			$this->logSQL($sql);
			$db_conn->Execute($sql);
		}
		if($this->firstNode->getElement('INFO/ICON')){
			$icon = $this->firstNode->valueOf('INFO/ICON');
			$sql = 'UPDATE `applications` SET `Icon` = \''.$icon.'\' WHERE `ID`=\''.$this->getID().'\';';
			$this->logSQL($sql);
			$db_conn->Execute($sql);
		}
		
		$this->setSuccess('Application succesfully updated');
		return true;
	}
}

?>