<?php
/*
Officity - Web application platform - Version 6.0 - 2011-07-05

François Dispaux, Boris Verdeyen, Thomas Hermant,
Jérémie Roy, Grégory Meurice, Abdelila Harbi, 
Marc Mignonsin, Jonathan Sanchez, Julien Gonzalez, Pierre Fouchez

Sushee and Officity is © Copyright 2011 Nectil SA.

`/sushee-source/sushee/private/updateOmnilinktype.inc.php` is part of Officity.

Sushee is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

Officity and Sushee are distributed in the hope that they will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Sushee. If not, see <http://www.gnu.org/licenses/>.
*/
require_once(dirname(__FILE__).'/../common/nqlOperation.class.php');
require_once(dirname(__FILE__).'/../private/update.nql.php');

class sushee_updateOmnilinktype extends NQLOperation{
	
	function parse(){
		// taking the ID of the type to update
		$this->elementID = $this->firstNode->valueOf('@ID');
		if(!$this->elementID){
			$this->setError('You didnt provide the ID of the type to update');
			return false;
		}
		return true;
	}
	
	function operate(){
		
		// type definition
		$type = sushee_OmnilinkType($this->getElementID());
		
		$denomination = $this->firstNode->valueOf('/INFO/DENOMINATION');
		$other_type = sushee_OmnilinkType($denomination);
		if($other_type->loaded){
			$this->setError('A type with the same denomination `'.$denomination.'` already exists');
			return false;
		}
		
		// updating in database
		$delete = new updateElement($this->getName(),$this->getOperationNode());
		$delete->execute();
		$this->setMsg($delete->getMsg());
		
		// updating the type in the session also
		$type->clearInSession();
		
		return true;
	}
	
}



?>