<?php
/*
Officity - Web application platform - Version 6.0 - 2011-07-05

François Dispaux, Boris Verdeyen, Thomas Hermant,
Jérémie Roy, Grégory Meurice, Abdelila Harbi, 
Marc Mignonsin, Jonathan Sanchez, Julien Gonzalez, Pierre Fouchez

Sushee and Officity is © Copyright 2011 Nectil SA.

`/sushee-source/sushee/public/login.php` is part of Officity.

Sushee is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

Officity and Sushee are distributed in the hope that they will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Sushee. If not, see <http://www.gnu.org/licenses/>.
*/
require_once(dirname(__FILE__)."/../common/common_functions.inc.php");
require_once(dirname(__FILE__)."/../common/db_functions.inc.php");
require_once(dirname(__FILE__)."/../common/XML.class.php");
require_once(dirname(__FILE__)."/../common/module.class.php");
require_once(dirname(__FILE__)."/../common/application.class.php");
require_once(dirname(__FILE__)."/../common/nectil_user.class.php");
require_once(dirname(__FILE__)."/../common/nectil_element.class.php");


if(!$stringofXML)
	$xml = get_xml_from_post_data(false);
else
	$xml = new XML($stringofXML);

// verifying it's a valid user
if ($xml->loaded){
	$login = $xml->getData('/QUERY[1]/LOGIN[1]');
	$password = $xml->getData('/QUERY[1]/PASSWORD[1]');
	$languageID = $xml->getData('/QUERY[1]/LANGUAGEID[1]');
	$xml_sessID = $xml->getData('/QUERY[1]/@sessid');
	$forgotten = $xml->getData('/QUERY[1]/@forgotten');
	if ($xml_sessID==='0')
		$xml_sessID = FALSE;
		
	if ( ($login===FALSE || $password===FALSE || $languageID===FALSE) && $xml_sessID===FALSE){
		// the correct xml nodes were not found
		$strResponse='<MESSAGE msgType="1">Invalid request*'.htmlentities($stringOfXML).'*</MESSAGE>';
	}else if($login==='' && $xml_sessID===FALSE ){
		$strResponse='<MESSAGE msgType="3">Anonymous Login not authorized</MESSAGE>';
	}else if($forgotten==='true'){
		
		$res = sendNewPassword($login);
		if ($res){
			$strResponse='<MESSAGE msgType="0">Your login and password have been sent in your mailbox.</MESSAGE>';
		}else{
			$strResponse='<MESSAGE msgType="3">You have no access to this instance of Nectil.</MESSAGE>';
		}
	}else if($password==='' && $xml_sessID===FALSE ){
		$strResponse='<MESSAGE msgType="3">Invalid password</MESSAGE>';
	}else if($xml_sessID!==FALSE && !isset($_SESSION[$GLOBALS["nectil_url"]]['SESSIONuserID']) ){
		$strResponse='<MESSAGE msgType="3">Invalid session recuperation</MESSAGE>';
	}else {
		// verifying this user exists and gave the correct password
		$db_conn = db_connect();
		if ($xml_sessID===FALSE){
			$keyringUsers_sql = 'SELECT `TargetID` FROM `dependencies` WHERE `DependencyTypeID` =3';
			$keyringUsers_rs = $db_conn->Execute($keyringUsers_sql);
			$keyringCondition = '';
			while($keyringUser = $keyringUsers_rs->FetchRow()){
				$keyringCondition.=$keyringUser['TargetID'].',';
			}
			if($keyringCondition){
				$keyringCondition=substr($keyringCondition,0,-1);
			}
			$sql = 'SELECT * FROM `contacts` WHERE `ID` IN ('.$keyringCondition.') AND `Email1`="'.encodeQuote($login).'" AND `Password`="'.encodeQuote(mysql_password($password)).'" AND `Activity`=1;';
		}else
			$sql = 'SELECT * FROM `contacts` WHERE `ID`=\''.$_SESSION[$GLOBALS["nectil_url"]]['SESSIONuserID'].'\';';
		
		$recordSet = &$db_conn->Execute($sql);
		if ( $contact = $recordSet->FetchRow() ){
			session_start();
			session_cache_expire(24*60);
			resetNectilSession();
			$sessionID=session_id();
			$user = new NectilUser();
			$userID = $user->setID($contact['ID']);
			$user->setSessionPassword($password);
			// security for the modules
			$strResponse='<MODULES>';
			$modules = new modules();
			$modulekeyModuleInfo = moduleInfo('modulekey');
			$fields_array=array('ID','Denomination','IsPrivate','ModuleToID');
			foreach($modules->list as $moduleInfo){
				
				$strResponse.='<MODULE ID="'.$moduleInfo->ID.'" module="'.$moduleInfo->name.'">';
				$moduleKey = getInfo($modulekeyModuleInfo,$moduleInfo->moduleKeyID);
				$strResponse.=generateInfoXML($modulekeyModuleInfo,$moduleKey,$fields_array,false);
				$strResponse.=$moduleInfo->getXMLSecurity();
				$strResponse.='</MODULE>';
				foreach($moduleInfo->depTypes as $depTypeName=>$props){
					depType($depTypeName);
				}
			}
			$strResponse.='</MODULES>';
			
			// security for the application
			$apps = new ApplicationCollection();
			$strResponse.=$apps->getLoginXML($languageID);
			
			$specific_db_conn = db_connect(FALSE);
			$ContactModuleInfo = moduleInfo('contact');
			$strResponse.='<CONTACT ID="'.$userID.'">'.generateInfoXML($ContactModuleInfo,$contact,$ContactModuleInfo->getFieldsBySecurity('0'),FALSE).'</CONTACT>';
			$groupModuleInfo = moduleInfo('group');
			$strResponse.='<TEAMS>';
			$group_sql = 'SELECT gp.Denomination,gp.ID FROM dependencies AS dep LEFT JOIN groups AS gp ON gp.ID=dep.OriginID WHERE gp.IsTeam=1 AND dep.TargetID='.$userID.' AND dep.DependencyTypeID=1;';
			$rs = $specific_db_conn->Execute($group_sql);
			while($row = $rs->FetchRow()){
				$strResponse.='<GROUP ID="'.$row['ID'].'"><DENOMINATION>'.encode_to_XML($row['Denomination']).'</DENOMINATION></GROUP>';
			}
			$strResponse.='</TEAMS>';
			
			// adding informations about the environment of the user
			include_once(dirname(__FILE__)."/../common/phpSniff.class.php");
			$client =& new phpSniff();
			$IP = $_SERVER['REMOTE_ADDR'];
			$browser = $client->property('long_name');
			
			$_SESSION[$GLOBALS["nectil_url"]]['SESSIONua'] = $_SERVER['HTTP_USER_AGENT'];
			$_SESSION[$GLOBALS["nectil_url"]]['SESSIONIP'] = $IP;
			$strResponse.='<USERAGENT>'.encode_to_XML($_SERVER['HTTP_USER_AGENT']).'</USERAGENT>';
			$strResponse.='<BROWSER>'.encode_to_XML($browser).'</BROWSER>';
			$strResponse.='<IP>'.encode_to_XML($IP).'</IP>';
			
			// saving the login datas in the database to follow the user activity
			$loginRegister['UserID'] = $userID;
			$loginRegister['Connection'] = $GLOBALS['sushee_today'];
			$loginRegister['LastAction'] = $GLOBALS['sushee_today'];
			$loginRegister['SessionID'] = $sessionID;
			$loginRegister['Browser'] = $browser;
			$loginRegister['IP'] = $IP;
			
			$loginRegisterObject = new LoginModuleElement($loginRegister);
			$loginRegisterObject->create();
			
			$user->registerLoginObject($loginRegisterObject);
			
		}else{
			$strResponse='<MESSAGE msgType="1">Invalid login or password</MESSAGE>';
		}
	}
}



require_once(dirname(__FILE__)."/../common/output_xml.inc.php");

?>
