/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.MalformedInputException;
import java.nio.charset.UnmappableCharacterException;
import net.sf.saxon.Configuration;
import net.sf.saxon.Err;
import net.sf.saxon.Platform;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.EscapeURI;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.functions.XSLTFunction;
import net.sf.saxon.om.FastStringBuffer;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NameChecker;
import net.sf.saxon.om.XMLChar;
import net.sf.saxon.trans.DynamicError;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.BooleanValue;
import net.sf.saxon.value.StringValue;

public class UnparsedText
extends SystemFunction
implements XSLTFunction {
    String expressionBaseURI = null;
    public static final int UNPARSED_TEXT = 0;
    public static final int UNPARSED_TEXT_AVAILABLE = 1;

    public void checkArguments(StaticContext staticContext) throws XPathException {
        if (this.expressionBaseURI == null) {
            super.checkArguments(staticContext);
            this.expressionBaseURI = staticContext.getBaseURI();
        }
    }

    public Expression preEvaluate(StaticContext staticContext) {
        return this;
    }

    public Item evaluateItem(XPathContext xPathContext) throws XPathException {
        StringValue stringValue;
        try {
            StringValue stringValue2 = (StringValue)this.argument[0].evaluateItem(xPathContext);
            if (stringValue2 == null) {
                return null;
            }
            String string = stringValue2.getStringValue();
            String string2 = null;
            if (this.getNumberOfArguments() == 2) {
                string2 = this.argument[1].evaluateItem(xPathContext).getStringValue();
            }
            stringValue = new StringValue(this.readFile(string, this.expressionBaseURI, string2, xPathContext));
        }
        catch (XPathException xPathException) {
            if (this.operation == 1) {
                return BooleanValue.FALSE;
            }
            throw xPathException;
        }
        if (this.operation == 1) {
            return BooleanValue.TRUE;
        }
        return stringValue;
    }

    private CharSequence readFile(String string, String string2, String string3, XPathContext xPathContext) throws XPathException {
        URI uRI;
        Configuration configuration = xPathContext.getConfiguration();
        NameChecker nameChecker = configuration.getNameChecker();
        Platform platform = Configuration.getPlatform();
        try {
            uRI = platform.makeAbsolute(string, string2);
        }
        catch (URISyntaxException uRISyntaxException) {
            DynamicError dynamicError = new DynamicError("Cannot resolve relative URI", uRISyntaxException);
            dynamicError.setErrorCode("XTDE1170");
            throw dynamicError;
        }
        if (uRI.getFragment() != null) {
            DynamicError dynamicError = new DynamicError("URI for unparsed-text() must not contain a fragment identifier");
            dynamicError.setErrorCode("XTDE1170");
            throw dynamicError;
        }
        EscapeURI.checkPercentEncoding(uRI.toString());
        Reader reader = xPathContext.getController().getUnparsedTextURIResolver().resolve(uRI, string3, configuration);
        try {
            int n;
            FastStringBuffer fastStringBuffer = new FastStringBuffer(2048);
            char[] cArray = new char[2048];
            boolean bl = true;
            int n2 = 1;
            int n3 = 1;
            while ((n = reader.read(cArray, 0, 2048)) >= 0) {
                int n4 = 0;
                while (n4 < n) {
                    int n5;
                    if ((n5 = cArray[n4++]) == 10) {
                        ++n2;
                        n3 = 0;
                    }
                    ++n3;
                    if (XMLChar.isHighSurrogate(n5)) {
                        if (n4 == n) {
                            n = reader.read(cArray, 0, 2048);
                            n4 = 0;
                        }
                        char c = cArray[n4++];
                        n5 = XMLChar.supplemental((char)n5, c);
                    }
                    if (nameChecker.isValidChar(n5)) continue;
                    DynamicError dynamicError = new DynamicError("The unparsed-text file contains a character illegal in XML (line=" + n2 + " column=" + n3 + " value=hex " + Integer.toHexString(n5) + ')');
                    dynamicError.setErrorCode("XTDE1190");
                    throw dynamicError;
                }
                if (bl) {
                    bl = false;
                    if (cArray[0] == '\ufeff') {
                        fastStringBuffer.append(cArray, 1, n - 1);
                        continue;
                    }
                    fastStringBuffer.append(cArray, 0, n);
                    continue;
                }
                fastStringBuffer.append(cArray, 0, n);
            }
            reader.close();
            return fastStringBuffer.condense();
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            DynamicError dynamicError = new DynamicError("Unknown encoding " + Err.wrap(string3), unsupportedEncodingException);
            dynamicError.setErrorCode("XTDE1190");
            throw dynamicError;
        }
        catch (IOException iOException) {
            String string4 = "Failed to read input file";
            if (!iOException.getMessage().equals(uRI.toString())) {
                string4 = string4 + ' ' + uRI.toString();
            }
            string4 = string4 + " (" + iOException.getClass().getName() + ')';
            DynamicError dynamicError = new DynamicError(string4, iOException);
            String string5 = iOException instanceof MalformedInputException ? "XTDE1200" : (iOException instanceof CharacterCodingException ? "XTDE1200" : (iOException instanceof UnmappableCharacterException ? "XTDE1190" : "XTDE1170"));
            dynamicError.setErrorCode(string5);
            dynamicError.setLocator(this);
            throw dynamicError;
        }
    }

    public static void main(String[] stringArray) throws Exception {
        FastStringBuffer fastStringBuffer = new FastStringBuffer(100);
        FastStringBuffer fastStringBuffer2 = new FastStringBuffer(100);
        File file = new File(stringArray[0]);
        FileInputStream fileInputStream = new FileInputStream(file);
        while (true) {
            int n;
            if ((n = ((InputStream)fileInputStream).read()) < 0) break;
            fastStringBuffer.append(Integer.toHexString(n) + " ");
            fastStringBuffer2.append((char)n + " ");
            if (fastStringBuffer.length() <= 80) continue;
            System.out.println(fastStringBuffer.toString());
            System.out.println(fastStringBuffer2.toString());
            fastStringBuffer = new FastStringBuffer(100);
            fastStringBuffer2 = new FastStringBuffer(100);
        }
        System.out.println(fastStringBuffer.toString());
        System.out.println(fastStringBuffer2.toString());
    }
}

