/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.value;

import java.util.Date;
import java.util.GregorianCalendar;
import java.util.SimpleTimeZone;
import java.util.StringTokenizer;
import net.sf.saxon.Configuration;
import net.sf.saxon.Err;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.sort.ComparisonKey;
import net.sf.saxon.trans.DynamicError;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.type.ValidationException;
import net.sf.saxon.value.CalendarValue;
import net.sf.saxon.value.DateTimeValue;
import net.sf.saxon.value.DateValue;
import net.sf.saxon.value.Whitespace;

public abstract class GDateValue
extends CalendarValue {
    protected int year;
    protected byte month;
    protected byte day;
    protected static byte[] daysPerMonth = new byte[]{31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
    protected static final short[] monthData = new short[]{306, 337, 0, 31, 61, 92, 122, 153, 184, 214, 245, 275};

    public int getYear() {
        return this.year;
    }

    public byte getMonth() {
        return this.month;
    }

    public byte getDay() {
        return this.day;
    }

    public GregorianCalendar getCalendar() {
        int n = this.hasTimezone() ? this.getTimezoneInMinutes() : 0;
        SimpleTimeZone simpleTimeZone = new SimpleTimeZone(n * 60000, "LLL");
        GregorianCalendar gregorianCalendar = new GregorianCalendar(simpleTimeZone);
        gregorianCalendar.setGregorianChange(new Date(Long.MIN_VALUE));
        gregorianCalendar.clear();
        gregorianCalendar.setLenient(false);
        int n2 = this.year;
        if (this.year <= 0) {
            n2 = 1 - this.year;
            gregorianCalendar.set(0, 0);
        }
        gregorianCalendar.set(n2, this.month - 1, this.day);
        gregorianCalendar.set(15, n * 60000);
        gregorianCalendar.set(16, 0);
        gregorianCalendar.getTime();
        return gregorianCalendar;
    }

    public Object convertToJava(Class clazz, XPathContext xPathContext) throws XPathException {
        if (clazz.isAssignableFrom(Date.class)) {
            return this.getCalendar().getTime();
        }
        if (clazz.isAssignableFrom(GregorianCalendar.class)) {
            return this.getCalendar();
        }
        if (clazz.isAssignableFrom(DateValue.class)) {
            return this;
        }
        if (clazz == String.class) {
            return this.getStringValue();
        }
        if (clazz.isAssignableFrom(CharSequence.class)) {
            return this.getStringValueCS();
        }
        if (clazz == Object.class) {
            return this.getStringValue();
        }
        Object object = this.convertToJava(clazz, xPathContext);
        if (object == null) {
            throw new DynamicError("Conversion of date to " + clazz.getName() + " is not supported");
        }
        return object;
    }

    public void setLexicalValue(CharSequence charSequence) throws XPathException {
        StringTokenizer stringTokenizer = new StringTokenizer(((Object)Whitespace.trimWhitespace(charSequence)).toString(), "-:+Z", true);
        try {
            if (!stringTokenizer.hasMoreElements()) {
                this.badDate("Too short", charSequence);
            }
            String string = (String)stringTokenizer.nextElement();
            int n = 1;
            if ("+".equals(string)) {
                this.badDate("Date may not start with '+' sign", charSequence);
            } else if ("-".equals(string)) {
                n = -1;
                string = (String)stringTokenizer.nextElement();
            }
            if (string.length() < 4) {
                this.badDate("Year is less than four digits", charSequence);
            }
            if (string.length() > 4 && string.charAt(0) == '0') {
                this.badDate("When year exceeds 4 digits, leading zeroes are not allowed", charSequence);
            }
            this.year = Integer.parseInt(string) * n;
            if (this.year == 0) {
                this.badDate("Year zero is not allowed", charSequence);
            }
            if (n < 0) {
                ++this.year;
            }
            if (!stringTokenizer.hasMoreElements()) {
                this.badDate("Too short", charSequence);
            }
            if (!"-".equals(stringTokenizer.nextElement())) {
                this.badDate("Wrong delimiter after year", charSequence);
            }
            if (!stringTokenizer.hasMoreElements()) {
                this.badDate("Too short", charSequence);
            }
            if ((string = (String)stringTokenizer.nextElement()).length() != 2) {
                this.badDate("Month must be two digits", charSequence);
            }
            this.month = (byte)Integer.parseInt(string);
            if (this.month < 1 || this.month > 12) {
                this.badDate("Month is out of range", charSequence);
            }
            if (!stringTokenizer.hasMoreElements()) {
                this.badDate("Too short", charSequence);
            }
            if (!"-".equals(stringTokenizer.nextElement())) {
                this.badDate("Wrong delimiter after month", charSequence);
            }
            if (!stringTokenizer.hasMoreElements()) {
                this.badDate("Too short", charSequence);
            }
            if ((string = (String)stringTokenizer.nextElement()).length() != 2) {
                this.badDate("Day must be two digits", charSequence);
            }
            this.day = (byte)Integer.parseInt(string);
            if (this.day < 1 || this.day > 31) {
                this.badDate("Day is out of range", charSequence);
            }
            if (stringTokenizer.hasMoreElements()) {
                String string2 = (String)stringTokenizer.nextElement();
                if ("Z".equals(string2)) {
                    int n2 = 0;
                    if (stringTokenizer.hasMoreElements()) {
                        this.badDate("Continues after 'Z'", charSequence);
                    }
                    this.setTimezoneInMinutes(n2);
                } else if ("+".equals(string2) || "-".equals(string2)) {
                    if (!stringTokenizer.hasMoreElements()) {
                        this.badDate("Missing timezone", charSequence);
                    }
                    string = (String)stringTokenizer.nextElement();
                    int n3 = Integer.parseInt(string);
                    if (string.length() != 2) {
                        this.badDate("Timezone hour must be two digits", charSequence);
                    }
                    if (n3 > 14) {
                        this.badDate("Timezone hour is out of range", charSequence);
                    }
                    if (!stringTokenizer.hasMoreElements()) {
                        this.badDate("No minutes in timezone", charSequence);
                    }
                    if (!":".equals(stringTokenizer.nextElement())) {
                        this.badDate("Wrong delimiter after timezone hour", charSequence);
                    }
                    if (!stringTokenizer.hasMoreElements()) {
                        this.badDate("No minutes in timezone", charSequence);
                    }
                    string = (String)stringTokenizer.nextElement();
                    int n4 = Integer.parseInt(string);
                    if (string.length() != 2) {
                        this.badDate("Timezone minute must be two digits", charSequence);
                    }
                    if (n4 > 59) {
                        this.badDate("Timezone minute is out of range", charSequence);
                    }
                    if (stringTokenizer.hasMoreElements()) {
                        this.badDate("Continues after timezone", charSequence);
                    }
                    int n5 = n3 * 60 + n4;
                    if ("-".equals(string2)) {
                        n5 = -n5;
                    }
                    this.setTimezoneInMinutes(n5);
                } else {
                    this.badDate("Timezone format is incorrect", charSequence);
                }
            }
            if (!GDateValue.isValidDate(this.year, this.month, this.day)) {
                this.badDate("Non-existent date", charSequence);
            }
        }
        catch (NumberFormatException numberFormatException) {
            this.badDate("Non-numeric component", charSequence);
        }
    }

    private void badDate(String string, CharSequence charSequence) throws ValidationException {
        ValidationException validationException = new ValidationException("Invalid date " + Err.wrap(charSequence, 4) + " (" + string + ")");
        validationException.setErrorCode("FORG0001");
        throw validationException;
    }

    public static boolean isValidDate(int n, int n2, int n3) {
        if (n2 > 0 && n2 <= 12 && n3 > 0 && n3 <= daysPerMonth[n2 - 1]) {
            return true;
        }
        if (n2 == 2 && n3 == 29) {
            return GDateValue.isLeapYear(n);
        }
        return false;
    }

    public static boolean isLeapYear(int n) {
        return n % 4 == 0 && (n % 100 != 0 || n % 400 == 0);
    }

    public int compareTo(Object object) {
        if (!(object instanceof GDateValue)) {
            throw new ClassCastException("Date values are not comparable to " + object.getClass());
        }
        return this.compareTo((GDateValue)object, new Configuration());
    }

    public int compareTo(CalendarValue calendarValue, Configuration configuration) {
        TypeHierarchy typeHierarchy = configuration.getTypeHierarchy();
        if (this.getItemType(typeHierarchy).getPrimitiveType() != calendarValue.getItemType(typeHierarchy).getPrimitiveType()) {
            throw new ClassCastException("Cannot compare values of different types");
        }
        return this.toDateTime().compareTo(calendarValue.toDateTime(), configuration);
    }

    public DateTimeValue toDateTime() {
        return new DateTimeValue(this.year, this.month, this.day, 0, 0, 0, 0, this.getTimezoneInMinutes());
    }

    public ComparisonKey getComparisonKey(Configuration configuration) {
        return new ComparisonKey(521, this.toDateTime().normalize(configuration));
    }

    public boolean equals(Object object) {
        return this.compareTo(object) == 0;
    }

    public int hashCode() {
        return this.getCalendar().getTime().hashCode() + this.getTimezoneInMinutes();
    }
}

