<?xml version="1.0"?>
<!--

Officity - Web application platform - Version 6.0 - 2011-07-05

François Dispaux, Boris Verdeyen, Thomas Hermant,
Jérémie Roy, Grégory Meurice, Abdelila Harbi, 
Marc Mignonsin, Jonathan Sanchez, Julien Gonzalez, Pierre Fouchez

Sushee and Officity is © Copyright 2011 Nectil SA.

`/var/www/installer/public_html/officity-source/apps/officity/directory/app.xsl` is part of Officity.

Sushee is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

Officity and Sushee are distributed in the hope that they will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Sushee. If not, see <http://www.gnu.org/licenses/>.

-->
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0" xmlns:OFFICITY="http://officity.com">
	<xsl:import href="app.include.xsl" />
	<xsl:strip-space elements="*"/>
	<xsl:output method="xml" indent="no" encoding="utf-8" doctype-public="-//W3C//DTD XHTML 1.0 Strict//EN" doctype-system="http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd" omit-xml-declaration="yes"/>
	
	<xsl:param name="visitorAppKeys" select="/RESPONSE/RESULTS[@name='visitorKeyring']/KEYRING/DEPENDENCIES/DEPENDENCY[@type='keyringAppKeys']/APPLICATIONKEY"/>
	<xsl:param name="visitorApps" select="/RESPONSE/RESULTS[@name='applications']/APP[@ID=$visitorAppKeys/INFO/APPLICATIONTOID]"/>
	<xsl:param name="shellConfig" select="/RESPONSE/RESULTS[@name='shell-config']/SHELLCONFIG" />
	
	<xsl:template match="/RESPONSE">
		<html>
			<xsl:apply-templates select="$shellConfig" mode="page-header" />
			<xsl:apply-templates select="$shellConfig" mode="page-body">
				<xsl:with-param name="visitorApps" select="$visitorApps" />
			</xsl:apply-templates>
			<script type="text/javascript">
				<!-- APPLICATION INITIALIZATION -->
				var <xsl:value-of select="$shellConfig/CONTROLLERNAME" />;
								
				$(document).ready(function()
				{         
					<xsl:apply-templates select="$shellConfig" mode="page-js" />
				});
			</script>
		</html>
	</xsl:template>
</xsl:stylesheet>