<?xml version="1.0"?>
<!--

Officity - Web application platform - Version 6.0 - 2011-07-05

François Dispaux, Boris Verdeyen, Thomas Hermant,
Jérémie Roy, Grégory Meurice, Abdelila Harbi, 
Marc Mignonsin, Jonathan Sanchez, Julien Gonzalez, Pierre Fouchez

Sushee and Officity is © Copyright 2011 Nectil SA.

`/var/www/installer/public_html/officity-source/apps/officity/directory/contacts/Directory.xsl` is part of Officity.

Sushee is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

Officity and Sushee are distributed in the hope that they will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Sushee. If not, see <http://www.gnu.org/licenses/>.

-->
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0" xmlns:OFFICITY="http://officity.com">
    <xsl:import href="include.xsl"/>
    <xsl:output encoding="UTF-8" method="xml" indent="no"/>
    <xsl:strip-space elements="*"/>

	<xsl:template match="/RESPONSE">
    	<xsl:call-template name="panel-navigation" />
    </xsl:template>
	
	<xsl:template name="panel-body-navigation"> 
        <xsl:for-each select="/RESPONSE/RESULTS[@name='alphabet']/LETTER">
            <xsl:call-template name="navigationitem">
                <xsl:with-param name="id">index-<xsl:value-of select="."/></xsl:with-param>
                <xsl:with-param name="title">
                    <xsl:value-of select="."/>
                </xsl:with-param>
                <xsl:with-param name="panelURI">contacts/DirectoryItems</xsl:with-param>
                <xsl:with-param name="icon">
                    <xsl:text>../system/images/icons/contacts/contacts-18.png</xsl:text>
                </xsl:with-param>
                <xsl:with-param name="params">
                    <xsl:text>index:'</xsl:text>
                    <xsl:value-of select="."/>
                    <xsl:text>'</xsl:text>
                </xsl:with-param>
                <xsl:with-param name="displayCount" select="true()"/>
            </xsl:call-template>
        </xsl:for-each>
	</xsl:template>

	<xsl:template name="panel-js-navigation">
		<xsl:apply-templates select="/RESPONSE/RESULTS[@name='alphabet']/LETTER" mode="counter"/>
	</xsl:template>

    <xsl:template match="LETTER" mode="counter">
        var countRequest<xsl:value-of select="."/> = new AjaxRequest(
            <xsl:value-of select="$panelID"/>,
            AppController,
            '<xsl:apply-templates select="/RESPONSE/RESULTS[@name='element-template']/*[1]" mode="element-script-count"/>',
            'GET'
        );

        countRequest<xsl:value-of select="."/>.addData('index', '<xsl:value-of select="."/>');

        countRequest<xsl:value-of select="."/>.onSuccess(function(response){
            $('#index-<xsl:value-of select="."/> .info').html(response.message+' hit(s)');
        }).send();
    </xsl:template>
</xsl:stylesheet>