<?php
/*
Officity - Web application platform - Version 6.0 - 2011-07-05

François Dispaux, Boris Verdeyen, Thomas Hermant,
Jérémie Roy, Grégory Meurice, Abdelila Harbi, 
Marc Mignonsin, Jonathan Sanchez, Julien Gonzalez, Pierre Fouchez

Sushee and Officity is © Copyright 2011 Nectil SA.

`/var/www/installer/public_html/officity-source/apps/officity/directory/contacts/DirectoryItems.php` is part of Officity.

Sushee is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

Officity and Sushee are distributed in the hope that they will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Sushee. If not, see <http://www.gnu.org/licenses/>.
*/
    require_once(dirname(__FILE__).'/include.php');

    /* *** */

    $INDEX_LETTERS = URLParam::fetch('index');

    /* *** */

    $nql = new Officity_Shell();

    $element = new Sushee_ContactElement();

    $contact_info = $society_info = '';

    $letters_count = strlen($INDEX_LETTERS);
    for ($i=0; $i<$letters_count; $i++)
    {
    	$letter = $INDEX_LETTERS[$i];
    	$contact_info .= '<LASTNAME operator="starts-with">'.$letter.'</LASTNAME>';
    	$society_info .= '<DENOMINATION operator="starts-with">'.$letter.'</DENOMINATION>';
    	//$element->addSearchInfo('LASTNAME', 'starts-with', $letter);
    	//$element->addSearchInfo('DENOMINATION', 'starts-with', $letter);
    }

    // search contact & societies
    $element->createFromXML('
        <CONTACT>
    	    <INFO>'.$contact_info.'</INFO>
        	<INFO>'.$society_info.'</INFO>
        </CONTACT>
	');

    $return_infos = array(
        'INFO/CONTACTTYPE',
        'INFO/LASTNAME',
        'INFO/FIRSTNAME',
        'INFO/MIDDLENAME',
        'INFO/DENOMINATION',
    	'INFO/EMAIL1'
    );
    $element->setReturn($return_infos, 1);
    $element->setDefaultPaginate(URLParam::fetch('display', 50), URLParam::fetch('page', 1));
	$element->setDefaultSort('INFO/SEARCHTEXT');

    $element->search('list', false);
    $search_command = $element->getNQLCommand();
    $nql->addCommand($search_command);
    //die(var_dump($search_command));

    $nql->addPaging();

    echo $nql->transform(dirname(__FILE__).'/DirectoryItems.xsl');
?>