<?xml version="1.0"?>
<!--

Officity - Web application platform - Version 6.0 - 2011-07-05

François Dispaux, Boris Verdeyen, Thomas Hermant,
Jérémie Roy, Grégory Meurice, Abdelila Harbi, 
Marc Mignonsin, Jonathan Sanchez, Julien Gonzalez, Pierre Fouchez

Sushee and Officity is © Copyright 2011 Nectil SA.

`/var/www/installer/public_html/officity-source/apps/officity/directory/contacts/DirectoryItems.xsl` is part of Officity.

Sushee is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

Officity and Sushee are distributed in the hope that they will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Sushee. If not, see <http://www.gnu.org/licenses/>.

-->
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0" xmlns:OFFICITY="http://officity.com">
    <xsl:import href="include.xsl"/>    
    <xsl:output encoding="UTF-8" method="xml" indent="no"/>
    <xsl:strip-space elements="*"/>

	<xsl:template match="/RESPONSE">
		<xsl:call-template name="panel-results">
			<xsl:with-param name="list" select="/RESPONSE/RESULTS[@name='list']"/>
	        <xsl:with-param name="addNew" select="true()"/>
	        <xsl:with-param name="pagingStyle" select="'browser'"/>
	        <xsl:with-param name="params">
	        	<xsl:text>index:'</xsl:text>
	        	<xsl:value-of select="/RESPONSE/URL/index" />
	        	<xsl:text>'</xsl:text>
	        </xsl:with-param>
		</xsl:call-template>
	</xsl:template>
	
	<!-- custom : results list -->
	<xsl:template name="panel-list-results">
		<xsl:param name="list" />
        <xsl:choose>
            <xsl:when test="$list/@hits > 0">
                <xsl:for-each select="$list/*">
                	<xsl:sort select="translate(concat(INFO[CONTACTTYPE='PP']/LASTNAME,INFO[CONTACTTYPE='PP']/FIRSTNAME,INFO[CONTACTTYPE='PM']/DENOMINATION), $xsltsl-str-upper, $xsltsl-str-lower)" order="ascending"/>
                    <xsl:apply-templates select="." mode="element-navitem" />
                </xsl:for-each>
            </xsl:when>
            <xsl:otherwise>
                <div class="no-result">No hits</div>
            </xsl:otherwise>
        </xsl:choose>
	</xsl:template>
</xsl:stylesheet>