<?xml version="1.0"?>
<!--

Officity - Web application platform - Version 6.0 - 2011-07-05

François Dispaux, Boris Verdeyen, Thomas Hermant,
Jérémie Roy, Grégory Meurice, Abdelila Harbi, 
Marc Mignonsin, Jonathan Sanchez, Julien Gonzalez, Pierre Fouchez

Sushee and Officity is © Copyright 2011 Nectil SA.

`/var/www/installer/public_html/officity-source/apps/officity/factory/applications/New.xsl` is part of Officity.

Sushee is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

Officity and Sushee are distributed in the hope that they will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Sushee. If not, see <http://www.gnu.org/licenses/>.

-->
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0" xmlns:OFFICITY="http://officity.com">
    <xsl:import href="include.xsl"/>    
    <xsl:output encoding="UTF-8" method="xml" indent="no"/>
    <xsl:strip-space elements="*"/>
    
    <!-- parameters -->
    <xsl:param name="fields" select="/RESPONSE/RESULTS[@name='fields']/FIELD"/>
    <xsl:param name="item" select="/RESPONSE/RESULTS[@name='item']/*[1]"/>
    <xsl:param name="module" select="/RESPONSE/URL/module"/>
    
    <!-- optional -->
    <xsl:param name="dependency" select="/RESPONSE/URL/dependency"/>
    <xsl:param name="targetModule" select="/RESPONSE/URL/targetModule"/>
    <xsl:param name="targetID" select="/RESPONSE/URL/targetID"/>
    
   	<xsl:template match="/RESPONSE">
    	<xsl:call-template name="panel-newelement">
    		<xsl:with-param name="element" select= "$item" />
    		<xsl:with-param name="title" select= "'New application'" />
    		<xsl:with-param name="titlecssclass" select= "'app'" />
    		<xsl:with-param name="tabsList" select= "'info,Details;'" />
    	</xsl:call-template>
    </xsl:template>
    
    <!-- custom : info form -->
    <xsl:template name="element-tab-info">
        <xsl:param name="element" />
         
       	<xsl:variable name="editorInputName">
			<xsl:call-template name="gen-dep-input-name">
				<xsl:with-param name="dependencyType" select="'officity:appNamespaces'" />
				<xsl:with-param name="moduleName" select="'namespace'" />
				<xsl:with-param name="serviceName" select="'info'" />
				<xsl:with-param name="fieldName" select="'ID'" />
				<xsl:with-param name="type" select="'int'"/>
			</xsl:call-template>
       	</xsl:variable>  
     	<xsl:call-template name="form-info-line">
       		<xsl:with-param name="label" select="'*Editor:'" />
	    	<xsl:with-param name="input">
                <select name="{$editorInputName}" class="input-select required">
                    <option value="">
                        <xsl:text>(Choose an editor)</xsl:text>
                    </option>
                    <xsl:for-each select="/RESPONSE/RESULTS[@name='editors']/*">
                        <xsl:sort select="INFO/EDITOR" />
                        <option value="{@ID}">
                        	<xsl:if test="/RESPONSE/URL/namespaceID=@ID">
                        		<xsl:attribute name="selected">selected</xsl:attribute>
                        	</xsl:if>
                            <xsl:apply-templates select="." mode="element-label" />
                        </option>
                    </xsl:for-each>
                </select>
	    	</xsl:with-param> 
	    	<xsl:with-param name="extraLabel">
	    		<xsl:text>Link your application to an existing Editor. By doing so, we can avoid collision with other Editors' applications.</xsl:text>
	    	</xsl:with-param>
	    	<xsl:with-param name="topLabel" select="true()" />
    	</xsl:call-template>
    	
       	<xsl:apply-templates select="$element/INFO/DENOMINATION" mode="form-info-line">
       		<xsl:with-param name="required" select="true()"  />
	    	<xsl:with-param name="extraLabel">
	    		<xsl:text>Full name of the application.</xsl:text>
	    	</xsl:with-param>
	    	<xsl:with-param name="topLabel" select="true()" />
       	</xsl:apply-templates>
       	
       	<xsl:apply-templates select="$element/INFO/URL" mode="form-info-line">
       		<xsl:with-param name="label" select="'Folder (no special chars authorized):'"  />
       		<xsl:with-param name="required" select="true()"  />
	    	<xsl:with-param name="extraLabel">
	    		<xsl:text>Folder in which the application will be created.</xsl:text>
	    	</xsl:with-param>
	    	<xsl:with-param name="topLabel" select="true()" />
       	</xsl:apply-templates>
       	
       	<xsl:apply-templates select="$element/INFO/ICON" mode="form-info-line">
       		<xsl:with-param name="label" select="'Icon path (relative to the editor): '" />
       	</xsl:apply-templates> 
       	
       	<!--xsl:apply-templates select="$element/INFO/DOCKABLE" mode="form-info-line" /-->
       	
	  	<xsl:call-template name="form-desc-line">
	  		<xsl:with-param name="moduleName" select="name($element)" />
	  		<xsl:with-param name="fieldName" select="'SUMMARY'" />
		    <xsl:with-param name="label" select="'Short description: '" />
		    <xsl:with-param name="type" select="'styled'" />
		    <xsl:with-param name="languageID" select="'shared'" />
		    <xsl:with-param name="inputValue" select="$element/DESCRIPTIONS/DESCRIPTION[@languageID='shared']/SUMMARY" />
		    <xsl:with-param name="required" select="false()" />
	    </xsl:call-template>
       	 
       	<xsl:apply-templates select="$element" mode="form-info-line-submit">
       		<xsl:with-param name="buttonLabel" select="'Create'"/>
       	</xsl:apply-templates>
    </xsl:template>
</xsl:stylesheet>