<?xml version="1.0"?>
<!--

Officity - Web application platform - Version 6.0 - 2011-07-05

François Dispaux, Boris Verdeyen, Thomas Hermant,
Jérémie Roy, Grégory Meurice, Abdelila Harbi, 
Marc Mignonsin, Jonathan Sanchez, Julien Gonzalez, Pierre Fouchez

Sushee and Officity is © Copyright 2011 Nectil SA.

`/var/www/installer/public_html/officity-source/apps/officity/factory/environments/Index.xsl` is part of Officity.

Sushee is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

Officity and Sushee are distributed in the hope that they will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Sushee. If not, see <http://www.gnu.org/licenses/>.

-->
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0" xmlns:OFFICITY="http://officity.com">
    <xsl:import href="include.xsl"/>    
    <xsl:output encoding="UTF-8" method="xml" indent="no"/>
    <xsl:strip-space elements="*"/>
    
    <xsl:param name="list" select="/RESPONSE/RESULTS[@name='list']" />

	<xsl:template match="/RESPONSE">
		<xsl:call-template name="panel-navigation">
		</xsl:call-template>
	</xsl:template>
	
	<xsl:template name="panel-body-navigation">
        <xsl:call-template name="staticitemheader">
            <xsl:with-param name="title">Environments</xsl:with-param>
            <xsl:with-param name="icon">../system/images/icons/environment/env-32.png</xsl:with-param>
            <xsl:with-param name="info">
            	<xsl:text>
            		It is a common practice to have distinct environments to develop, update and test your applications before releasing (or publishing).
            		These environments are located in distinct folders that can be configured here.
				</xsl:text>
            </xsl:with-param>
        </xsl:call-template>
        <xsl:choose>
            <xsl:when test="$list/@hits > 0">
	            <xsl:apply-templates select="$list/OFFICITY:ENVIRONMENT[INFO/TYPE='production']" mode="env-actions" />
	            <xsl:apply-templates select="$list/OFFICITY:ENVIRONMENT[INFO/TYPE='beta']" mode="env-actions" />
	            <xsl:apply-templates select="$list/OFFICITY:ENVIRONMENT[INFO/TYPE='development']" mode="env-actions" />
	            <xsl:apply-templates select="$list/OFFICITY:ENVIRONMENT[INFO/TYPE='versions']" mode="env-actions" />
            </xsl:when>
            <xsl:otherwise>
                <div class="no-result">No hits</div>
            </xsl:otherwise>
        </xsl:choose>
        
         <xsl:call-template name="confirm-dialog" />
	</xsl:template>
	
    <xsl:template name="confirm-dialog">
        <div id="confirm-dialog" title="Confirm deactivation" class="modal-dialog" align="center">
            <form id="confirm-form">
            	<input type="hidden" id="confirmID" value=""/>
            		<p>
	            		<br />                
						<xsl:text>Do you really want to deactivate the </xsl:text>
						<strong id="confirmType" />
						<xsl:text> environment?</xsl:text>
	                    <br/><br /><br />
                    </p>
	                <div class="controls">
	                    <a id="cancel-button" href="#">Cancel</a>&#160;&#160;&#160;&#160;
	                    <input id="ok-button" name="ok-button" type="button" value="Deactivate" class="modal-button"/>
	                </div>
            </form>
        </div>
    </xsl:template>
    
    <xsl:template match="OFFICITY:ENVIRONMENT[INFO/TYPE='production']" mode="env-desc">
    	The "Production" environment is the "final" place where users can experience new and updated applications.
	    <p>&#160;</p>
	    <p>&#160;</p>
    </xsl:template>
    
    <xsl:template match="OFFICITY:ENVIRONMENT[INFO/TYPE='beta']" mode="env-desc">
	    The "Beta testing" environment is intended to pre-release testing in a production-like environment.
	    <p>&#160;</p>
	    <p>&#160;</p>
    </xsl:template>
    
    <xsl:template match="OFFICITY:ENVIRONMENT[INFO/TYPE='development']" mode="env-desc">
		The "Development" environment is where the development of applications take place.
		The Factory will automatically generate or modify files in this environent's folder.
		You can specify server commands to be executed after each files modification. For instance, you may need to add these files to your version control system.
	    <p>&#160;</p>
	    <p>&#160;</p>
    </xsl:template>
    
    <xsl:template match="OFFICITY:ENVIRONMENT[INFO/TYPE='versions']" mode="env-desc">
    	This is where the Factory archives the different environments folders before publishing.
    	<p>&#160;</p>
		<p>&#160;</p>
    </xsl:template>
    
	<xsl:template match="OFFICITY:ENVIRONMENT[INFO/PUBLISHED=1]" mode="env-actions">
		<div class="env-actions">
			<a href="#" class="env-deactivate" targetID="{@ID}" targetType="{//LIST[@name='EnvironmentType']/ITEM[@value=current()/INFO/TYPE]/@label}">
				<xsl:text>Deactivate</xsl:text>
			</a>
			<h2 class="officity__environment-{INFO/TYPE}">
				<xsl:value-of select="//LIST[@name='EnvironmentType']/ITEM[@value=current()/INFO/TYPE]/@label"/>
			</h2>
			<p>
				<xsl:apply-templates select="." mode="env-desc"/>
			</p>
			<p>&#160;</p>
			<form class="form-env-update" onsubmit="return false;" id="env-form-{@ID}">
				<input type="hidden" name="ID" value="{@ID}"/>
				<input type="hidden" value="1">
					<xsl:attribute name="name">
						<xsl:call-template name="gen-info-input-name">
							<xsl:with-param name="moduleName" select="'officity:environment'"/>
							<xsl:with-param name="fieldName" select="'published'"/>
							<xsl:with-param name="type" select="'boolean'"/>
						</xsl:call-template>
					</xsl:attribute>
				</input>
				<table width="100%">
					<tr>
						<td align="right" width="20%">*Folder:</td>
						<td align="left" width="50%">
							<input type="text" class="input-text required" value="{INFO/FOLDER}"> 
								<xsl:attribute name="name">
									<xsl:call-template name="gen-info-input-name">
										<xsl:with-param name="moduleName" select="'officity:environment'"/>
										<xsl:with-param name="fieldName" select="'folder'"/>
										<xsl:with-param name="type" select="'text'"/>
									</xsl:call-template>
								</xsl:attribute>
							</input>
						</td>
						<td align="left" valign="top" rowspan="2">
							<input type="submit" class="input-submit-save input-update" value="Update" />
						</td>
					</tr>
					<xsl:if test="INFO/TYPE='development'">
						<tr>
							<td align="right" width="20%">Server command after create:</td>
							<td align="left" width="50%">
								<textarea class="input-textarea">
									<xsl:attribute name="name">
										<xsl:call-template name="gen-info-input-name">
											<xsl:with-param name="moduleName" select="'officity:environment'"/>
											<xsl:with-param name="fieldName" select="'CREATECOMMAND'"/>
											<xsl:with-param name="type" select="'text'"/>
										</xsl:call-template>
									</xsl:attribute>
									<xsl:value-of select="INFO/CREATECOMMAND" />
								</textarea>
							</td>
						</tr>
						<tr>
							<td align="right" width="20%">Server command after update:</td>
							<td align="left" width="50%">
								<textarea class="input-textarea">
									<xsl:attribute name="name">
										<xsl:call-template name="gen-info-input-name">
											<xsl:with-param name="moduleName" select="'officity:environment'"/>
											<xsl:with-param name="fieldName" select="'UPDATECOMMAND'"/>
											<xsl:with-param name="type" select="'text'"/>
										</xsl:call-template>
									</xsl:attribute>
									<xsl:value-of select="INFO/UPDATECOMMAND" />
								</textarea>
							</td>
						</tr>
						<tr>
							<td align="right" width="20%">Server command after delete:</td>
							<td align="left" width="50%">
								<textarea class="input-textarea">
									<xsl:attribute name="name">
										<xsl:call-template name="gen-info-input-name">
											<xsl:with-param name="moduleName" select="'officity:environment'"/>
											<xsl:with-param name="fieldName" select="'DELETECOMMAND'"/>
											<xsl:with-param name="type" select="'text'"/>
										</xsl:call-template>
									</xsl:attribute>
									<xsl:value-of select="INFO/DELETECOMMAND" />
								</textarea>
							</td>
						</tr>
						<tr>
							<td align="right" width="20%">Server command after rename:</td>
							<td align="left" width="50%">
								<textarea class="input-textarea">
									<xsl:attribute name="name">
										<xsl:call-template name="gen-info-input-name">
											<xsl:with-param name="moduleName" select="'officity:environment'"/>
											<xsl:with-param name="fieldName" select="'RENAMECOMMAND'"/>
											<xsl:with-param name="type" select="'text'"/>
										</xsl:call-template>
									</xsl:attribute>
									<xsl:value-of select="INFO/RENAMECOMMAND" />
								</textarea>
							</td>
						</tr>
					</xsl:if>
				</table>
			</form>
		</div>
		<script type="text/javascript">
			var inputsValidator<xsl:value-of select="$panelID"/> = new InputsValidator(<xsl:value-of select="$panelID"/>, '#env-form-<xsl:value-of select="@ID" />');
		</script>
	</xsl:template>
	
	<xsl:template match="OFFICITY:ENVIRONMENT[INFO/PUBLISHED=0]" mode="env-actions">
			<div class="env-actions">
			<h2 class="officity__environment-{INFO/TYPE}">
				<xsl:value-of select="//LIST[@name='EnvironmentType']/ITEM[@value=current()/INFO/TYPE]/@label"/>
			</h2>
			<form class="form-env-activate" onsubmit="return false;" id="env-form-{@ID}">
				<input type="hidden" name="ID" value="{@ID}"/>
				<input type="hidden" value="1">
					<xsl:attribute name="name">
						<xsl:call-template name="gen-info-input-name">
							<xsl:with-param name="moduleName" select="'officity:environment'"/>
							<xsl:with-param name="fieldName" select="'published'"/>
							<xsl:with-param name="type" select="'boolean'"/>
						</xsl:call-template>
					</xsl:attribute>
				</input>
				<p>
					<input type="submit" class="input-submit-save input-activate" value="Activate" />
					<xsl:apply-templates select="." mode="env-desc"/>
				</p>
			</form>
		</div>
	</xsl:template>
	
	<xsl:template name="panel-add-js">
		// update
	    $('#<xsl:value-of select="$panelID"/>.panel').find('form.form-env-update').submit(function(){
	        fm = new FormManager(<xsl:value-of select="$panelID"/>, AppController);
	
	        fm.onSuccess(function(response){
	            $(AppController).panelslider('reloadPanel', <xsl:value-of select="$panelID" />);
	        });
	
	        fm.displayProcess('Updating environment...');
	        fm.setScript('<xsl:apply-templates select="$list/*[1]" mode="element-script-update" />');
	        fm.parseAndSend(this);
	
	        return false;
	    });
	    
	    // activate
	    $('#<xsl:value-of select="$panelID"/>.panel').find('form.form-env-activate').submit(function(){
	        fm = new FormManager(<xsl:value-of select="$panelID"/>, AppController);
	
	        fm.onSuccess(function(response){
	            $(AppController).panelslider('reloadPanel', <xsl:value-of select="$panelID" />);
	        });
	
	        fm.displayProcess('Environment activation...');
	        fm.setScript('<xsl:apply-templates select="$list/*[1]" mode="element-script-update" />');
	        fm.parseAndSend(this);
	
	        return false;
	    });
	    
	    // deactivate confirmation
        var confirmDialog = new ModalDialog(
            <xsl:value-of select="$panelID"/>,
            AppController,
            "#confirm-dialog",
            {
                bgiframe: true,
                width: 500,
                minHeight: 150,
                autoOpen: false,
            }
        );
        
        confirmDialog.setCloseCallback(null);
        confirmDialog.setCancelCallback('#cancel-button', null);
        
        confirmDialog.setOkCallback("#ok-button", function(){
        	var formID = 'env-form-' + $('.ui-dialog').find('#confirm-form').find('input#confirmID').val();
        	
	    	var formElem = $('#<xsl:value-of select="$panelID" />.panel').find('#'+formID);
	    	formElem.find('input[name=info-officity__environment-published-boolean]').val('0');
	    	
	        fm = new FormManager(<xsl:value-of select="$panelID"/>, AppController);
	
	        fm.onSuccess(function(response){
	            $(AppController).panelslider('reloadPanel', <xsl:value-of select="$panelID" />);
	        });
	
	        fm.displayProcess('Deactivating environment...');
	        fm.setScript('<xsl:apply-templates select="$list/*[1]" mode="element-script-update" />');
	        
	        this.hide();
	        fm.parseAndSend(formElem);
        });

	    $('#<xsl:value-of select="$panelID" />.panel').find('a.env-deactivate').click(function(){
	    	var confirmFormElem = $('.ui-dialog').find('#confirm-form');
	    	confirmFormElem.find('input#confirmID').val($(this).attr('targetID'));
	    	confirmFormElem.find('#confirmType').html($(this).attr('targetType'));
	    	
	    	confirmDialog.show();
	    	return false;
	    });
	    
		<xsl:call-template name="js-init-autoresize" />
	</xsl:template>
</xsl:stylesheet>