<?xml version="1.0"?>
<!--

Officity - Web application platform - Version 6.0 - 2011-07-05

François Dispaux, Boris Verdeyen, Thomas Hermant,
Jérémie Roy, Grégory Meurice, Abdelila Harbi, 
Marc Mignonsin, Jonathan Sanchez, Julien Gonzalez, Pierre Fouchez

Sushee and Officity is © Copyright 2011 Nectil SA.

`/var/www/installer/public_html/officity-source/apps/officity/factory/modules/DependenciesBrowse.xsl` is part of Officity.

Sushee is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

Officity and Sushee are distributed in the hope that they will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Sushee. If not, see <http://www.gnu.org/licenses/>.

-->
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0" xmlns:OFFICITY="http://officity.com">
    <xsl:import href="include.xsl"/>
    <xsl:output encoding="UTF-8" method="xml" indent="no"/>
    <xsl:strip-space elements="*"/>
    
    <xsl:param name="module" select="translate(/RESPONSE/URL/module,'ABCDEFGHIJKLMNOPQRSTUVWXYZ','abcdefghijklmnopqrstuvwxyz')"/>
   
	<xsl:template match="/RESPONSE">
    	<xsl:call-template name="panel-navigation">
    	</xsl:call-template>
    </xsl:template>
    
    <xsl:template name="panel-title">
		<xsl:choose> 
			<xsl:when test="/RESPONSE/URL/module">   
                <xsl:value-of select="/RESPONSE/URL/module" />
            </xsl:when>
            <xsl:otherwise>
            	<xsl:text>All</xsl:text>
            </xsl:otherwise>
		</xsl:choose>
		<xsl:text> dependencies</xsl:text>
    </xsl:template>  
	
	<xsl:template name="panel-body-navigation">
        <xsl:call-template name="staticitemheader">
            <xsl:with-param name="title">Dependencies</xsl:with-param>
            <xsl:with-param name="icon">../system/images/icons/dependencies/link-32.png</xsl:with-param>
            <xsl:with-param name="info">
            	<xsl:text>A dependency indicates how two modules are related. For example we can define two dependencies "Works for" and "Has worked for" between modules "Contact" and "Society". A module also can be related to itself.</xsl:text>
            	&#160;<br /><br />
            	<xsl:text>
					There are three types of dependencies:
				</xsl:text>
					<br /><br />
				<xsl:text>
					1. Asymmetrical One-way: the dependency "Is capital of" makes sense only if you read it that way "module City "Is capital of" module Country".
				</xsl:text><br /><br />
				<xsl:text>
					2. Symmetrical Round-trip: makes sense in both reading directions, e.g. "Is my brother" between module Contact and itself.
				</xsl:text><br /><br />
				<xsl:text>
					3. Asymmetrical Round-trip: to set a professional relation between Contact and Society we may need to define two dependencies "Works for" and "Employs" between modules "Contact" and "Society".
				</xsl:text>
            </xsl:with-param>
        </xsl:call-template>
        
		<xsl:choose>
			<xsl:when test="/RESPONSE/URL/all">
		        <xsl:choose>
		        	<xsl:when test="/RESPONSE/RESULTS/DEPENDENCYENTITY">
			        	<xsl:apply-templates select="/RESPONSE/RESULTS/DEPENDENCYENTITY" mode="alldependencytypes">
			        		<xsl:sort select="DEPENDENCYTYPE[1]/@from" />
			        		<xsl:sort select="translate(DEPENDENCYTYPE[1]/TYPE, $xsltsl-str-lower, $xsltsl-str-upper)" />
			        	</xsl:apply-templates>
		            </xsl:when>
		            <xsl:otherwise>
		                <div class="no-result">No dependencies configured</div>
		            </xsl:otherwise>
		        </xsl:choose>
			</xsl:when>
			<xsl:otherwise>
		        <xsl:call-template name="nav-new">
		            <xsl:with-param name="title">Create Dependency...</xsl:with-param>
		            <xsl:with-param name="panelURI" select="'modules/DependencyNew'" />
		            <xsl:with-param name="params">
			            <xsl:text>fromModule:'</xsl:text>
			            <xsl:value-of select="/RESPONSE/URL/module" />
			            <xsl:text>',fromModuleID:</xsl:text>
			            <xsl:value-of select="/RESPONSE/URL/moduleID" />
		            </xsl:with-param>
		            <xsl:with-param name="cssclass" select="'grey-bkgnd'" />
		        </xsl:call-template>
		        <xsl:choose>
		        	<xsl:when test="/RESPONSE/RESULTS/DEPENDENCYENTITY">
			        	<xsl:apply-templates select="/RESPONSE/RESULTS/DEPENDENCYENTITY" mode="dependencytypes">
			        		<xsl:sort select="translate(DEPENDENCYTYPE/TYPE, $xsltsl-str-lower, $xsltsl-str-upper)" />
			        	</xsl:apply-templates>
		            </xsl:when>
		            <xsl:otherwise>
		                <div class="no-result">No dependencies configured</div>
		            </xsl:otherwise>
		        </xsl:choose>
			</xsl:otherwise>
		</xsl:choose> 
	</xsl:template>
	
	<!-- all dependencies -->
	<xsl:template match="DEPENDENCYENTITY" mode="alldependencytypes">
		<xsl:choose>
			<xsl:when test="count(DEPENDENCYTYPE)=1">
				<xsl:apply-templates select="DEPENDENCYTYPE" mode="element-navitem-50-50">
					<xsl:with-param name="returnType">
						<xsl:value-of select="DEPENDENCYTYPE/TYPE" />
					</xsl:with-param>
					<xsl:with-param name="icon">
						<xsl:apply-templates select="DEPENDENCYTYPE" mode="element-icon"/>
					</xsl:with-param>
				</xsl:apply-templates>
			</xsl:when>
			<xsl:when test="DEPENDENCYTYPE[1]/TYPE=DEPENDENCYTYPE[2]/TYPE">
				<xsl:apply-templates select="DEPENDENCYTYPE[1]" mode="element-navitem-50-50">
					<xsl:with-param name="returnType">
						<xsl:value-of select="DEPENDENCYTYPE/TYPE" />
					</xsl:with-param>
					<xsl:with-param name="icon">
						<xsl:text>../system/images/icons/dependencies/arrows-sym.png</xsl:text>
					</xsl:with-param>
				</xsl:apply-templates>
			</xsl:when>
			<xsl:otherwise>
				<xsl:apply-templates select="DEPENDENCYTYPE[1]" mode="element-navitem-50-50">
					<xsl:with-param name="returnType">
						<xsl:value-of select="DEPENDENCYTYPE[2]/TYPE" />
					</xsl:with-param>
					<xsl:with-param name="icon">
						<xsl:apply-templates select="DEPENDENCYTYPE[1]" mode="element-icon"/>
					</xsl:with-param>
				</xsl:apply-templates>
				<xsl:apply-templates select="DEPENDENCYTYPE[2]" mode="element-navitem-50-50">
					<xsl:with-param name="returnType">
						<xsl:value-of select="DEPENDENCYTYPE[1]/TYPE" />
					</xsl:with-param>
					<xsl:with-param name="icon" select="''" />
				</xsl:apply-templates>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	
	<xsl:template match="DEPENDENCYTYPE" mode="element-navitem-50-50">
		<xsl:param name="returnType" />
		<xsl:param name="icon" />
		
		<xsl:call-template name="navigationitem-50-50">
			<xsl:with-param name="editor">
				<xsl:apply-templates select="." mode="element-application-editor"/>
			</xsl:with-param>
			<xsl:with-param name="app">
				<xsl:apply-templates select="." mode="element-application"/>
			</xsl:with-param>
			<xsl:with-param name="id">
                <xsl:apply-templates select="." mode="element-navitem-id"/>
            </xsl:with-param>
			<xsl:with-param name="icon">
				<xsl:value-of select="$icon" />
			</xsl:with-param>
			<xsl:with-param name="title">
				<span style="text-transform:uppercase;"><xsl:value-of select="@from" /></span>
				<xsl:text> </xsl:text>
				<img src="{$systemImagesURL}/icons/dependencies/arrow-right.png" style="height: 16px; width: 16px; position: relative; top: 4px; margin: 0 0px 0 0px;"/>
				<xsl:text> </xsl:text>
				<xsl:value-of select="TYPE" />
			</xsl:with-param>
			<xsl:with-param name="panelURI">
				<xsl:apply-templates select="." mode="element-script-detail"/>
			</xsl:with-param>
			<xsl:with-param name="params">
               <xsl:apply-templates select="." mode="element-navitem-parms"/>
            </xsl:with-param>
			<xsl:with-param name="info">
				<xsl:value-of select="$returnType" />
				<xsl:text> </xsl:text>
				<img src="{$systemImagesURL}/icons/dependencies/arrow-left.png" style="height: 16px; width: 16px; position: relative; top: 4px; margin: 0 0px 0 0px;"/>
				<xsl:text> </xsl:text>
				<span style="text-transform:uppercase;"><xsl:value-of select="@to" /></span>
			</xsl:with-param>
		</xsl:call-template>
	</xsl:template>
	
	<!-- module dependencies -->
	<xsl:template match="DEPENDENCYENTITY" mode="dependencytypes">
		<xsl:choose>
			<xsl:when test="(count(DEPENDENCYTYPE)=1) or (DEPENDENCYTYPE[1]/TYPE=DEPENDENCYTYPE[2]/TYPE)">
				<xsl:apply-templates select="DEPENDENCYTYPE[1]" mode="element-navitem" />
			</xsl:when>
			<xsl:otherwise>
				<xsl:apply-templates select="DEPENDENCYTYPE[@from=$module]" mode="element-navitem" />
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
</xsl:stylesheet>