<?php
/*
Officity - Web application platform - Version 6.0 - 2011-07-05

François Dispaux, Boris Verdeyen, Thomas Hermant,
Jérémie Roy, Grégory Meurice, Abdelila Harbi, 
Marc Mignonsin, Jonathan Sanchez, Julien Gonzalez, Pierre Fouchez

Sushee and Officity is © Copyright 2011 Nectil SA.

`/var/www/installer/public_html/officity-source/apps/officity/factory/modules/DependencyDetails.php` is part of Officity.

Sushee is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

Officity and Sushee are distributed in the hope that they will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Sushee. If not, see <http://www.gnu.org/licenses/>.
*/
    require_once(dirname(__FILE__).'/include.php');

    /* *** */
    
    function addSourceCodeFromTemplate(&$nql, $tplURI, $name)
    {
    	$dep_nql = new Sushee_Shell(false);
    	$dep_nql->addCommand('
			<GET name="item">
			  <DEPENDENCYENTITY ID="'.URLParam::fetch('startID').'"/>
			</GET>
    	');
    	$dep_nql->execute();
    	$current_dep = $dep_nql->getElement('/RESPONSE/RESULTS/DEPENDENCYENTITY/DEPENDENCYTYPE');
    	if (empty($current_dep))
    	{
    		$nql->addStatic('!!! Cannot retrieve current dependency !!!', $name);
    		return;
    	}
    	
    	$tpl_path = SYSTEM_PACKAGES_PATH.$tplURI;
    	$tpl_file = new KernelFile($tpl_path);
    	
    	if ($tpl_file->exists())
    	{
			$content = $tpl_file->toString();
			$src = $content;
			$src = str_replace('%deplabel%', $current_dep->valueOf('DENOMINATION/LABEL'), $src);
			$src = str_replace('%deptype%', $current_dep->valueOf('TYPE'), $src);
			$src = str_replace('%from%', $current_dep->valueOf('@from'), $src);
			$src = str_replace('%to%', $current_dep->valueOf('@to'), $src);
	    	$src = xmlpp($src);
    	}
    	else
    	{
    		$src = '!!! Code template file "'.$tplURI.'" does not exist !!!';
    	}
    	
    	$nql->addStatic($src, $name);
    }
    
    /* *** */
        
    $nql = new Officity_Shell();
	
    $nql->addCommand('
		<GET name="item">
		  <DEPENDENCYENTITY ID="'.URLParam::fetch('startID').'"/>
		</GET>
    ');
    
    $nql->addCommand('
		<GET name="fromModule">
		  <MODULE denomination="'.URLParam::fetch('fromDenom').'"/>
		  <RETURN>
			<INFO>
				<DENOMINATION />
			</INFO>
		  </RETURN>
		</GET>
    ');
    
    $nql->addCommand('
		<GET name="toModule">
		  <MODULE denomination="'.URLParam::fetch('toDenom').'"/>
		  <RETURN>
			<INFO>
				<DENOMINATION />
			</INFO>
		  </RETURN>
		</GET>
    ');
    
    $nql->addCommand('
    	<GET>
    		<LIST name="DependencyTypes" />
    	</GET>	
    ');
    
    addSourceCodeFromTemplate($nql, 'dependencies/source.navdetailsitem-link.xsl', 'sourceXSLLink');
    //addSourceCodeFromTemplate($nql, 'dependencies/source.navdetailsitem-quicksearch.xsl', 'sourceXSLQuicksearch');
  
    echo $nql->transform(dirname(__FILE__).'/DependencyDetails.xsl');
?>