<?php
/*
Officity - Web application platform - Version 6.0 - 2011-07-05

François Dispaux, Boris Verdeyen, Thomas Hermant,
Jérémie Roy, Grégory Meurice, Abdelila Harbi, 
Marc Mignonsin, Jonathan Sanchez, Julien Gonzalez, Pierre Fouchez

Sushee and Officity is © Copyright 2011 Nectil SA.

`/var/www/installer/public_html/officity-source/apps/officity/factory/modules/DisplayConfig.php` is part of Officity.

Sushee is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

Officity and Sushee are distributed in the hope that they will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Sushee. If not, see <http://www.gnu.org/licenses/>.
*/
	require_once(dirname(__FILE__).'/include.php');
	
	/* *** */
	
	$module = strtolower(URLParam::fetch('module'));
	
	/* *** */

	// get all modules and related fields involved in dependencies @ depth 1	
	$fields_nql = new Sushee_Shell(false);
	
    $fields_nql->addCommand('
        <GET name="dependencies">
            <DEPENDENCYENTITY from="'.$module.'" />
        </GET>
    ');
    
    $fields_commands = $fields_nql->transform(dirname(__FILE__).'/displayconfig-resources-cmds.xsl');

   	$nql = new Officity_Shell();
   	
	$nql->addCommand($fields_commands);
	
    $nql->addCommand('
        <GET name="dependencies">
            <DEPENDENCYENTITY from="'.$module.'" />
        </GET>
    ');
	
	$nql->addCommand('
		<RESULTS name="results" static="true">
			<VALUE>10</VALUE>
			<VALUE>25</VALUE>
			<VALUE>50</VALUE>
			<VALUE>100</VALUE>
			<VALUE>250</VALUE>
			<VALUE>500</VALUE>
		</RESULTS>
	');
	
	$nql->addCommand('
		<SEARCH name="default-filter">
			<OFFICITY:FILTER>
				<INFO>
					<USAGE operator="=">user</USAGE>
					<DEFAULT operator="=">1</DEFAULT>
					<MODULE operator="=">'.$module.'</MODULE>
				</INFO>
			</OFFICITY:FILTER>
		</SEARCH>
	');
	
	$nql->addCommand('
		<SEARCH name="default-reports">
			<OFFICITY:REPORT>
				<INFO>
					<USAGE operator="=">user</USAGE>
					<MODEL operator="=">1</MODEL>
					<MODULE operator="=">'.$module.'</MODULE>
				</INFO>
			</OFFICITY:REPORT>
		</SEARCH>
	');
	
	$nql->addCommand('
		<SEARCH name="default-search-config">
			<OFFICITY:SEARCHCONFIG>
				<INFO>
					<DEFAULT operator="=">1</DEFAULT>
					<MODULE operator="=">'.$module.'</MODULE>
				</INFO>
			</OFFICITY:SEARCHCONFIG>
		</SEARCH>
	');

	echo $nql->transform(dirname(__FILE__).'/DisplayConfig.xsl');
?>