<?xml version="1.0"?>
<!--

Officity - Web application platform - Version 6.0 - 2011-07-05

François Dispaux, Boris Verdeyen, Thomas Hermant,
Jérémie Roy, Grégory Meurice, Abdelila Harbi, 
Marc Mignonsin, Jonathan Sanchez, Julien Gonzalez, Pierre Fouchez

Sushee and Officity is © Copyright 2011 Nectil SA.

`/var/www/installer/public_html/officity-source/apps/officity/factory/modules/FieldNew.xsl` is part of Officity.

Sushee is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

Officity and Sushee are distributed in the hope that they will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Sushee. If not, see <http://www.gnu.org/licenses/>.

-->
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0" xmlns:OFFICITY="http://officity.com">
    <xsl:import href="include.xsl"/>    
    <xsl:output encoding="UTF-8" method="xml" indent="no"/>
    <xsl:strip-space elements="*"/>
    
    <!-- parameters -->
    <xsl:param name="fields" select="/RESPONSE/RESULTS[@name='fields']/FIELD"/>
    <xsl:param name="item" select="/RESPONSE/RESULTS[@name='item']/*[1]"/>
    <xsl:param name="module" select="/RESPONSE/URL/module"/>
    
    <!-- optional -->
    <xsl:param name="dependency" select="/RESPONSE/URL/dependency"/>
    <xsl:param name="targetModule" select="/RESPONSE/URL/targetModule"/>
    <xsl:param name="targetID" select="/RESPONSE/URL/targetID"/>
    
   	<xsl:template match="/RESPONSE">
    	<xsl:call-template name="panel-newelement">
    		<xsl:with-param name="element" select= "$item" />
    		<xsl:with-param name="title" select= "'New Field'" />
    		<xsl:with-param name="titlecssclass" select= "'field'" />
    		<xsl:with-param name="tabsList" select= "'info,Details;'" />
    		<!--xsl:with-param name="displayNavDetails" select="true()" /-->
    	</xsl:call-template>
    </xsl:template>
    
    <!-- custom : info form -->
    <xsl:template name="element-tab-info">
        <xsl:param name="element" />  

		<xsl:variable name="typeInputID">
			<xsl:call-template name="gen-info-input-ID">
				<xsl:with-param name="moduleName" select="'field'" />
				<xsl:with-param name="fieldName" select="'type'" />
			</xsl:call-template>
		</xsl:variable>
		<xsl:variable name="typeInputName">
			<xsl:call-template name="gen-info-input-name">
				<xsl:with-param name="moduleName" select="'field'" />
				<xsl:with-param name="fieldName" select="'type'" />
			</xsl:call-template>
		</xsl:variable>
		<xsl:variable name="listInputID">
			<xsl:call-template name="gen-info-input-ID">
				<xsl:with-param name="moduleName" select="'field'" />
				<xsl:with-param name="fieldName" select="'listname'" />
			</xsl:call-template>
		</xsl:variable>
		<xsl:variable name="listInputName">
			<xsl:call-template name="gen-info-input-name">
				<xsl:with-param name="moduleName" select="'field'" />
				<xsl:with-param name="fieldName" select="'listname'" />
			</xsl:call-template>
		</xsl:variable>
		<xsl:variable name="targetModuleInputID">
			<xsl:call-template name="gen-info-input-ID">
				<xsl:with-param name="moduleName" select="'field'" />
				<xsl:with-param name="fieldName" select="'targetmodule'" />
			</xsl:call-template>
		</xsl:variable>
		<xsl:variable name="targetModuleInputName">
			<xsl:call-template name="gen-info-input-name">
				<xsl:with-param name="moduleName" select="'field'" />
				<xsl:with-param name="fieldName" select="'targetmodule'" />
			</xsl:call-template>
		</xsl:variable>
		<xsl:variable name="targetFieldInputID">
			<xsl:call-template name="gen-info-input-ID">
				<xsl:with-param name="moduleName" select="'field'" />
				<xsl:with-param name="fieldName" select="'targetfield'" />
				<xsl:with-param name="type" select="'text'" />
			</xsl:call-template>
		</xsl:variable>
		<xsl:variable name="targetFieldInputName">
			<xsl:call-template name="gen-info-input-name">
				<xsl:with-param name="moduleName" select="'field'" />
				<xsl:with-param name="fieldName" select="'targetfield'" />
				<xsl:with-param name="type" select="'text'" />
			</xsl:call-template>
		</xsl:variable>
		
		<xsl:choose>
			<xsl:when test="not(/RESPONSE/URL/targetModuleDenom)">
				<xsl:variable name="moduleInputID">
					<xsl:call-template name="gen-info-input-ID">
						<xsl:with-param name="moduleName" select="'field'" />
						<xsl:with-param name="fieldName" select="'module'" />
					</xsl:call-template>
				</xsl:variable>
				<xsl:variable name="moduleInputName">
					<xsl:call-template name="gen-info-input-name">
						<xsl:with-param name="moduleName" select="'field'" />
						<xsl:with-param name="fieldName" select="'module'" />
					</xsl:call-template>
				</xsl:variable>
		
		       	<xsl:call-template name="form-info-line">
					<xsl:with-param name="label" select="'Module:'"  />
					<xsl:with-param name="input">
				        <select class="input-select" id="{$moduleInputID}" name="{$moduleInputName}">
				            <option value="">
				                <xsl:text>(Choose a module)</xsl:text>
				            </option>
				            <xsl:for-each select="/RESPONSE/RESULTS[@name='modules']/MODULE">
				                <xsl:sort select="INFO/DENOMINATION" />
				                <option value="{INFO/DENOMINATION}">
				                    <xsl:value-of select="INFO/DENOMINATION"/>
				                </option>
				            </xsl:for-each>
				        </select>
					</xsl:with-param>
				</xsl:call-template>
			</xsl:when>
			<xsl:otherwise>
				<xsl:apply-templates select="$element/INFO/MODULE" mode="form-info-line">
					<xsl:with-param name="hidden" select="true()" />
					<xsl:with-param name="inputValue" select="/RESPONSE/URL/targetModuleDenom" />
				</xsl:apply-templates>
		
				<xsl:call-template name="overview-line">
					<xsl:with-param name="label" select="'Module:'" />
					<xsl:with-param name="value" select="/RESPONSE/RESULTS[@name='targetModule']/MODULE/INFO/DENOMINATION" />
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>
		             	
       	<xsl:apply-templates select="$element/INFO/DENOMINATION" mode="form-info-line">
       		<xsl:with-param name="required" select="true()"  />
	    	<xsl:with-param name="extraLabel">
	    		<xsl:text>Technical name of your field.  (Spaces and other special characters will be removed.)</xsl:text>
	    	</xsl:with-param>
	    	<xsl:with-param name="topLabel" select="true()" />
       	</xsl:apply-templates>

       	<xsl:call-template name="form-info-line">
			<xsl:with-param name="label" select="'Type:'"  />
			<xsl:with-param name="input">
		        <select class="input-select" id="{$typeInputID}" name="{$typeInputName}">
		        	<xsl:attribute name="onchange">
		        		switch ($(this).val())
		        		{
		        			case 'enum':
		        			case 'list':
				        		// hide elements list
				        		$('#<xsl:value-of select="$panelID" />.panel').find('#<xsl:value-of select="$targetModuleInputID" />').val('').closest('tr').hide();
				        		$('#<xsl:value-of select="$panelID" />.panel').find('#<xsl:value-of select="$targetFieldInputID" />').val('').closest('tr').hide();
				        		
			        			var listElem = $('#<xsl:value-of select="$panelID" />.panel').find('#<xsl:value-of select="$listInputID" />');
			        			listElem.find('option.classicitem').show();
			        			listElem.find('option.sysitem').hide();
			        			listElem.val('').closest('tr').show();
			        			
			        			$('#<xsl:value-of select="$panelID" />.panel').find('#list-values').closest('tr').hide();
			        			break;
			        			
		        			case 'systemList':
				        		// hide elements list
				        		$('#<xsl:value-of select="$panelID" />.panel').find('#<xsl:value-of select="$targetModuleInputID" />').val('').closest('tr').hide();
				        		$('#<xsl:value-of select="$panelID" />.panel').find('#<xsl:value-of select="$targetFieldInputID" />').val('').closest('tr').hide();
				        		
			        			var listElem = $('#<xsl:value-of select="$panelID" />.panel').find('#<xsl:value-of select="$listInputID" />');
			        			listElem.find('option.sysitem').show();
			        			listElem.find('option.classicitem').hide();
			        			listElem.val('').closest('tr').show();
			        			
			        			$('#<xsl:value-of select="$panelID" />.panel').find('#list-values').closest('tr').hide();
		        				break;
		        				
		        			case 'elementsList':
		        				// hide classic list
		        				$('#<xsl:value-of select="$panelID" />.panel').find('#<xsl:value-of select="$listInputID" />').val('').closest('tr').hide();
		        			
			        			$('#<xsl:value-of select="$panelID" />.panel').find('#<xsl:value-of select="$targetModuleInputID" />').closest('tr').show();
			        			$('#<xsl:value-of select="$panelID" />.panel').find('#<xsl:value-of select="$targetFieldInputID" />').closest('tr').show();
			        			
			        			$('#<xsl:value-of select="$panelID" />.panel').find('#list-values').closest('tr').hide();
		        				break;
		        				
	        				default:
			        			$('#<xsl:value-of select="$panelID" />.panel').find('#<xsl:value-of select="$listInputID" />').val('').closest('tr').hide();
				        		$('#<xsl:value-of select="$panelID" />.panel').find('#<xsl:value-of select="$targetModuleInputID" />').val('').closest('tr').hide();
				        		$('#<xsl:value-of select="$panelID" />.panel').find('#<xsl:value-of select="$targetFieldInputID" />').val('').closest('tr').hide();
				        		
				        		$('#<xsl:value-of select="$panelID" />.panel').find('#list-values').closest('tr').hide();
	        					break;
		        		}
		        	</xsl:attribute>
		            <option value="">
		                <xsl:text>(Choose a type)</xsl:text>
		            </option>
		            <xsl:for-each select="/RESPONSE/RESULTS/LIST[@name='FieldTypes']/ITEM">
		                <xsl:sort select="@label" />
		                <option value="{@value}">
		                    <xsl:value-of select="@label"/>
		                </option>
		            </xsl:for-each>
		        </select>
			</xsl:with-param>
	    	<xsl:with-param name="extraLabel">
	    		<xsl:text>Define the kind of data that your field will contain. (A field named "Birthday" should be set to contain data of type "Date".)</xsl:text>
	    	</xsl:with-param>
	    	<xsl:with-param name="topLabel" select="true()" />
    	</xsl:call-template>

       	<xsl:call-template name="form-info-line">
			<xsl:with-param name="label" select="'List:'"  />
			<xsl:with-param name="input">
		        <select class="input-select" id="{$listInputID}" name="{$listInputName}">
		        	<xsl:attribute name="onchange">
		        		if ($(this).val() == 'new')
		        		{
		        			$('#<xsl:value-of select="$panelID" />.panel').find('#list-values').show().closest('tr').show();
	        			}
	        			else
	        			{
	        				$('#<xsl:value-of select="$panelID" />.panel').find('#list-values').show().closest('tr').hide();
	        			}
		        	</xsl:attribute>
		            <option value="">
		                <xsl:text>(Choose a list)</xsl:text>
		            </option>
		            <option value="new" class="classicitem">
		                <xsl:text>Create a new list...</xsl:text>
		            </option>
		            <xsl:for-each select="/RESPONSE/RESULTS/LIST[@name!='']">
		                <xsl:sort select="@domain" />
		                <xsl:sort select="@name" />
		                <option value="{@name}" class="classicitem">
		                    <xsl:value-of select="@domain"/>
		                    <xsl:text> : </xsl:text>
		                    <xsl:apply-templates select="@name" mode="display-value"/>
		                </option>
		            </xsl:for-each>
		            <option value="Countries" class="sysitem">
		                <xsl:text>Countries</xsl:text>
		            </option>
		            <option value="Languages" class="sysitem">
		                <xsl:text>Languages</xsl:text>
		            </option>
		        </select>
			</xsl:with-param>
	    	<xsl:with-param name="extraLabel">
	    		<xsl:text>Choose an existing list (or create a new one, if permitted).</xsl:text>
	    	</xsl:with-param>
	    	<xsl:with-param name="topLabel" select="true()" />
	    	<xsl:with-param name="hidden" select="true()" />
		</xsl:call-template>
		
       	<xsl:call-template name="form-info-line">
			<xsl:with-param name="label" select="'List values:'"  />
			<xsl:with-param name="input">
				<textarea class="input-textarea" id="list-values" name="list-values">
					<xsl:value-of select="translate(/RESPONSE/URL/targetModuleDenom, ':', '/')" />
					<xsl:text>,listname</xsl:text>
					<xsl:text>,shared</xsl:text>
					<xsl:text>,label</xsl:text>
					<xsl:text>,value</xsl:text>
				</textarea>
			</xsl:with-param>
	    	<xsl:with-param name="extraLabel">
	    		Insert CSV list values according to the following format:<br />
	    		[domain],[list name],[language ID],[label],[value]
	    	</xsl:with-param>
	    	<xsl:with-param name="topLabel" select="true()" />
	    	<xsl:with-param name="hidden" select="true()" /> 
		</xsl:call-template>

       	<xsl:call-template name="form-info-line">
			<xsl:with-param name="label" select="'Target Module:'"  />
			<xsl:with-param name="input">
		        <select class="input-select" id="{$targetModuleInputID}" name="{$targetModuleInputName}">
		            <option value="">
		                <xsl:text>(Choose a module)</xsl:text>
		            </option>
		            <xsl:for-each select="/RESPONSE/RESULTS[@name='modules']/MODULE">
		                <xsl:sort select="INFO/DENOMINATION" />
		                <option value="{INFO/DENOMINATION}">
		                    <xsl:value-of select="INFO/DENOMINATION"/>
		                </option>
		            </xsl:for-each>
		        </select>
			</xsl:with-param>
	    	<xsl:with-param name="topLabel" select="true()" />
	    	<xsl:with-param name="hidden" select="true()" />
		</xsl:call-template>
       	
       	<xsl:apply-templates select="$element/INFO/TARGETFIELD" mode="form-info-line">
	       	<xsl:with-param name="hidden" select="true()" />
	    	<xsl:with-param name="extraLabel">
	    		<xsl:text>Create a list of values coming from target field in target module.</xsl:text>
	    	</xsl:with-param>
       	</xsl:apply-templates>

       	<xsl:apply-templates select="$element/INFO/DEFAULTVALUE" mode="form-info-line">
	    	<xsl:with-param name="extraLabel">
	    		<xsl:text>This will be the default value of your field if it has remained empty or untouched.</xsl:text>
	    	</xsl:with-param>
	    	<xsl:with-param name="topLabel" select="true()" />
       	</xsl:apply-templates>
      	
       	<xsl:apply-templates select="$element/INFO/SEARCHABLE" mode="form-info-line">
	    	<xsl:with-param name="extraLabel">
	    		<br />
				<xsl:text>When checked, indicates that the field is available for search.</xsl:text>
	    	</xsl:with-param>
	    	<xsl:with-param name="topLabel" select="true()" />
       	</xsl:apply-templates>
       	
       	<xsl:apply-templates select="$element/INFO/DISPLAYABLE" mode="form-info-line">
	    	<xsl:with-param name="extraLabel">
	    		<br />
	    		<xsl:text>When checked, indicates that the field can be part of a search results or reports for example.</xsl:text>
	    	</xsl:with-param>
	    	<xsl:with-param name="topLabel" select="true()" />
       	</xsl:apply-templates>
       	
       	<xsl:apply-templates select="$element/INFO/DISPLAYLENGTH" mode="form-info-line">
	       	<xsl:with-param name="cssclass" select="'input-number-small'" />
	    	<xsl:with-param name="extraLabel">
	    		<em>Characters average</em>
	    		<br />
	    		<xsl:text>If your field needs more space in order to be properly displayed you can set this here.</xsl:text>
	    	</xsl:with-param>
	    	<xsl:with-param name="topLabel" select="true()" />
       	</xsl:apply-templates>
       	 
       	<xsl:apply-templates select="$element" mode="form-info-line-submit">
       		<xsl:with-param name="buttonLabel" select="'Create'"/>
      		<xsl:with-param name="createAndNew" select="true()" />
       	</xsl:apply-templates>
    </xsl:template>
    
    <!-- custom : default navigation items -->
    <xsl:template name="panel-block-details-nav-element">
    	<xsl:param name="element" />
	    <xsl:call-template name="navigationdetailsitem">
		    <xsl:with-param name="title" select="'Import list...'" />
		    <xsl:with-param name="panelURI">../../system/tools/list/Import</xsl:with-param>
		    <xsl:with-param name="icon">../system/images/icons/documents/excel-16.png</xsl:with-param>
		    <xsl:with-param name="info">
		    </xsl:with-param>
		    <xsl:with-param name="cssclass">grey-bkgnd</xsl:with-param>
	    </xsl:call-template>
    </xsl:template>
</xsl:stylesheet>