<?xml version="1.0"?>
<!--

Officity - Web application platform - Version 6.0 - 2011-07-05

François Dispaux, Boris Verdeyen, Thomas Hermant,
Jérémie Roy, Grégory Meurice, Abdelila Harbi, 
Marc Mignonsin, Jonathan Sanchez, Julien Gonzalez, Pierre Fouchez

Sushee and Officity is © Copyright 2011 Nectil SA.

`/var/www/installer/public_html/officity-source/apps/officity/factory/modules/Index.xsl` is part of Officity.

Sushee is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

Officity and Sushee are distributed in the hope that they will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Sushee. If not, see <http://www.gnu.org/licenses/>.

-->
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0" xmlns:OFFICITY="http://officity.com">
    <xsl:import href="include.xsl"/>    
    <xsl:output encoding="UTF-8" method="xml" indent="no"/>
    <xsl:strip-space elements="*"/>
    
    <xsl:param name="list" select="/RESPONSE/RESULTS[@name='list']" />

	<xsl:template match="/RESPONSE">
		<xsl:call-template name="panel-navigation">
		</xsl:call-template>
	</xsl:template>
	
	<xsl:template name="panel-body-navigation">
        <xsl:call-template name="staticitemheader">
            <xsl:with-param name="title">Modules, fields and dependencies.</xsl:with-param>
            <xsl:with-param name="icon">../system/images/icons/modules/module-32.png</xsl:with-param>
            <xsl:with-param name="info">
            	<xsl:text>Modules hold your business data. In simple terms, Module is a table, Module elements are records of that table and fields are the columns. Create as many modules as you need and make them work together with dependencies.</xsl:text>
            </xsl:with-param>
        </xsl:call-template>
        
		<xsl:call-template name="nav-new">
			<xsl:with-param name="title" select="'Create new...'" />
			<xsl:with-param name="module" select="'module'" />
			<xsl:with-param name="panelURI" select="'modules/ModuleNew'" />
			<xsl:with-param name="cssclass" select="'grey-bkgnd'"/>
		</xsl:call-template>

		<xsl:call-template name="navigationitem">	        
			<xsl:with-param name="title" select="'Browse...'" />
			<xsl:with-param name="panelURI" select="'modules/ModulesBrowse'" />
			<xsl:with-param name="icon" select="'../system/images/icons/browse.png'"/>
		</xsl:call-template>
		
		<xsl:call-template name="nav-search">
            <xsl:with-param name="title" select="'Search Modules'" />
            <xsl:with-param name="module" select="'module'" />
            <xsl:with-param name="icon" select="'../system/images/icons/search/advancedsearch.png'" />
		</xsl:call-template>

        <xsl:call-template name="nav-savedfilters">
            <xsl:with-param name="title">Filters on Modules</xsl:with-param>
            <xsl:with-param name="module" select="'module'"/>
        </xsl:call-template>
        
		<xsl:call-template name="nav-search">
            <xsl:with-param name="title">Search Fields</xsl:with-param>
            <xsl:with-param name="module" select="'field'" />
            <xsl:with-param name="icon" select="'../system/images/icons/search/advancedsearch.png'" />
		</xsl:call-template>

        <xsl:call-template name="nav-savedfilters">
            <xsl:with-param name="title">Filters on Fields</xsl:with-param>
            <xsl:with-param name="module" select="'field'"/>
        </xsl:call-template>
        
		<xsl:call-template name="navigationitem">	        
			<xsl:with-param name="title" select="'Browse all dependencies...'" />
			<xsl:with-param name="panelURI" select="'modules/DependenciesBrowse'" />
			<xsl:with-param name="params" select="'all:true'" />
			<xsl:with-param name="icon" select="'../system/images/icons/browse.png'"/>
		</xsl:call-template>
	</xsl:template>
</xsl:stylesheet>