<?xml version="1.0"?>
<!--

Officity - Web application platform - Version 6.0 - 2011-07-05

François Dispaux, Boris Verdeyen, Thomas Hermant,
Jérémie Roy, Grégory Meurice, Abdelila Harbi, 
Marc Mignonsin, Jonathan Sanchez, Julien Gonzalez, Pierre Fouchez

Sushee and Officity is © Copyright 2011 Nectil SA.

`/var/www/installer/public_html/officity-source/apps/officity/factory/modules/ModuleDetails.xsl` is part of Officity.

Sushee is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

Officity and Sushee are distributed in the hope that they will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Sushee. If not, see <http://www.gnu.org/licenses/>.

-->
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0" xmlns:OFFICITY="http://officity.com">
    <xsl:import href="include.xsl"/>    
    <xsl:output encoding="UTF-8" method="xml" indent="no"/>
    <xsl:strip-space elements="*"/>
    
    <!-- parameters -->    
    <xsl:param name="fields" select="/RESPONSE/RESULTS[@name='fields']/FIELD"/>
    <xsl:param name="depentities" select="/RESPONSE/RESULTS[@name='dependencies']/DEPENDENCYENTITY"/>
  	<!--xsl:param name="descriptions" select="/RESPONSE/RESULTS[@name='descriptions']/DESCRIPTIONCONFIG"/-->
  	
    <xsl:param name="item" select="/RESPONSE/RESULTS[@name='item']/*[1]"/>
    <xsl:param name="itemInfo" select="$item/INFO"/>
    <xsl:param name="itemDeps" select="$item/DEPENDENCIES"/>
    <xsl:param name="itemDescs" select="$item/DESCRIPTIONS"/>
    <xsl:param name="module" select="/RESPONSE/URL/module"/>
    <xsl:param name="templateItem" select="/RESPONSE/RESULTS[@name='templateItem']/*[1]"/>
    
    <!-- optional -->
    <xsl:param name="dependency" select="/RESPONSE/URL/dependency"/>
    <xsl:param name="targetModule" select="/RESPONSE/URL/targetModule"/>
    <xsl:param name="targetID" select="/RESPONSE/URL/targetID"/>
    
   	<xsl:template match="/RESPONSE">
    	<xsl:call-template name="panel-elementdetails">
    		<xsl:with-param name="element" select= "$item" />
    		<xsl:with-param name="tabsList">
				<xsl:text>details,Details;display,Display;files,Shared Files;</xsl:text>
    		</xsl:with-param>
    		 <xsl:with-param name="displayOverviewTab" select="false()" />
    		 <xsl:with-param name="displayAdminTab" select="true()" />
    		 <xsl:with-param name="deleteRight" select="true()" />
    		 <xsl:with-param name="deleteConfirm" select="true()"/>
    		 <xsl:with-param name="deleteConfirmText">
           		<p>
            		<br />                
					<xsl:text>By deleting this module, you will also </xsl:text>
					<strong>delete all related folders/files</strong>
					<xsl:text>.</xsl:text>
					<br /><br />
					<xsl:text>Some of these files are shared, this may also impact other applications.</xsl:text>
					<br /><br />
					<strong>Are you sure?</strong>
                    <br/><br /><br />
                </p>
    		 </xsl:with-param>
    	</xsl:call-template>
    </xsl:template>
        
    <!-- custom : tabs content -->
	<xsl:template name="panel-body-element-tabs-content">
		<xsl:param name="element" />
		<xsl:param name="newElement" />
		
		<!-- tab : details -->
  		<xsl:call-template name="element-tabform-create">
			<xsl:with-param name="denom" select="'details'" />
			<xsl:with-param name="element" select="$element" />
			<xsl:with-param name="content">
				<xsl:call-template name="element-tab-details">
					<xsl:with-param name="element" select="$element" />
				</xsl:call-template>
			</xsl:with-param>
		</xsl:call-template>
		
		<!-- tab : display -->
  		<xsl:call-template name="element-tabform-create">
			<xsl:with-param name="denom" select="'display'" />
			<xsl:with-param name="element" select="$element" />
			<xsl:with-param name="content">
				<xsl:call-template name="element-tab-display">
					<xsl:with-param name="element" select="$element" />
				</xsl:call-template>
			</xsl:with-param>
		</xsl:call-template>
		
		<!-- tab : files -->
  		<xsl:call-template name="element-tabform-create">
			<xsl:with-param name="denom" select="'files'" />
			<xsl:with-param name="element" select="$element" />
			<xsl:with-param name="content">
				<xsl:call-template name="element-tab-files">
					<xsl:with-param name="element" select="$element" />
				</xsl:call-template>
			</xsl:with-param>
		</xsl:call-template>
	</xsl:template>
    
    <!-- custom : details tab -->
    <xsl:template name="element-tab-details">
        <xsl:param name="element" />    
           
     	<xsl:call-template name="overview-line">
       		<xsl:with-param name="label" select="'Editor:'" />
	    	<xsl:with-param name="value">
                <xsl:apply-templates select="$element/DEPENDENCIES/DEPENDENCY[@type='officity:moduleNamespaces']/NAMESPACE" mode="element-label" />
	    	</xsl:with-param>
    	</xsl:call-template>
    	
       	<xsl:apply-templates select="$element/INFO/DENOMINATION" mode="overview-line">
       	</xsl:apply-templates>
       	
       	<xsl:call-template name="overview-line">
			<xsl:with-param name="label" select="'Type:'"  />
			<xsl:with-param name="value">
				<xsl:choose>
					<xsl:when test="$element/INFO/EXTENDS/text()">
						<xsl:value-of select="/RESPONSE/RESULTS/LIST[@name='ModuleTypes']/ITEM[@value='extends']/@label" />
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="/RESPONSE/RESULTS/LIST[@name='ModuleTypes']/ITEM[@value='base']/@label" />
					</xsl:otherwise>
				</xsl:choose>
			</xsl:with-param>
		</xsl:call-template>
		
		<xsl:if test="$element/INFO/EXTENDS/text()">
    	   	<xsl:apply-templates select="$element/INFO/EXTENDS" mode="overview-line">
	       	</xsl:apply-templates>
       	</xsl:if>
       	
       	<xsl:apply-templates select="$element/INFO/TABLENAME" mode="overview-line">
       	</xsl:apply-templates> 
       	
       	<xsl:apply-templates select="$element/INFO/ADVANCEDSECURITY" mode="form-info-line">
       	</xsl:apply-templates> 
       	 
       	<xsl:apply-templates select="$element" mode="form-info-line-submit" />
    </xsl:template>
    
    <!-- custom : display tab -->
    <xsl:template name="element-tab-display">
        <xsl:param name="element" />  
        
	  	<xsl:call-template name="form-desc-line">
	  		<xsl:with-param name="moduleName" select="name($element)" />
	  		<xsl:with-param name="fieldName" select="'TITLE'" />
		    <xsl:with-param name="label" select="'Label: '" />
		    <xsl:with-param name="type" select="'text'" />
		    <xsl:with-param name="languageID" select="'shared'" />
		    <xsl:with-param name="inputValue" select="$element/DESCRIPTIONS/DESCRIPTION[@languageID='shared']/TITLE" />
	   </xsl:call-template>
	  	<xsl:call-template name="form-desc-line">
	  		<xsl:with-param name="moduleName" select="name($element)" />
	  		<xsl:with-param name="fieldName" select="'HEADER'" />
		    <xsl:with-param name="label" select="'Plural form: '" />
		    <xsl:with-param name="type" select="'text'" />
		    <xsl:with-param name="languageID" select="'shared'" />
		    <xsl:with-param name="inputValue" select="$element/DESCRIPTIONS/DESCRIPTION[@languageID='shared']/HEADER" />
	    </xsl:call-template>
	  	<xsl:call-template name="form-desc-line">
	  		<xsl:with-param name="moduleName" select="name($element)" />
	  		<xsl:with-param name="fieldName" select="'SUMMARY'" />
		    <xsl:with-param name="label" select="'Abbreviation: '" />
		    <xsl:with-param name="type" select="'text'" />
	     	<xsl:with-param name="languageID" select="'shared'" />
	     	<xsl:with-param name="inputValue" select="$element/DESCRIPTIONS/DESCRIPTION[@languageID='shared']/SUMMARY" />
	    </xsl:call-template>
	    
       	<xsl:apply-templates select="$element/INFO/ICON" mode="form-info-line">
       		<xsl:with-param name="label" select="'Icon path (relative to the editor): '" />
       	</xsl:apply-templates> 
       	
       	<xsl:apply-templates select="$element" mode="form-desc-line-submit" />
    </xsl:template>
    
    <!-- custom : files tab -->
    <xsl:template name="element-tab-files">
        <xsl:param name="element" /> 
         
        <xsl:for-each select="/RESPONSE/RESULTS[@name='modulefiles']/MODULEFILES/ENVIRONMENT">
	       	<xsl:call-template name="overview-line">
				<xsl:with-param name="label">
					<xsl:value-of select="//LIST[@name='EnvironmentType']/ITEM[@value=current()/@type]/@label" />
					<xsl:text> environment:</xsl:text>
				</xsl:with-param>
				<xsl:with-param name="value">
					<xsl:choose>
						<xsl:when test="FILENAME">
							<xsl:for-each select="FILENAME">
								<xsl:sort select="." />
								<xsl:text>    </xsl:text>
								<xsl:value-of select="." /><br />
							</xsl:for-each>
						</xsl:when>
						<xsl:otherwise>
							<xsl:text>No files found</xsl:text>
							<xsl:if test="not($element/DEPENDENCIES/DEPENDENCY[@type='officity:moduleNamespaces']/NAMESPACE)">
								<xsl:text> (no namespace provided)</xsl:text>
							</xsl:if>
						</xsl:otherwise>
					</xsl:choose>
				</xsl:with-param>
				<xsl:with-param name="topLabel" select="true()" />
			</xsl:call-template>
			<xsl:call-template name="form-empty-line" />
		</xsl:for-each>
		<xsl:if test="$element/DEPENDENCIES/DEPENDENCY[@type='officity:moduleNamespaces']/NAMESPACE and not(/RESPONSE/RESULTS[@name='modulefiles']/MODULEFILES//FILENAME)">
       		<xsl:call-template name="overview-line">
				<xsl:with-param name="value">
					<form name="gen-files-form-{$panelID}">
						<input type="hidden" name="ID" value="{$element/@ID}" />
						<input type="button" value="Generate files" class="input-submit-save" name="gen-files">
							<xsl:attribute name="onclick">
						        fm = new FormManager(<xsl:value-of select="$panelID"/>, AppController);
						
						        fm.onSuccess(function(response){
						            $(AppController).panelslider('reloadPanel', <xsl:value-of select="$panelID" />);
						        });
						
						        fm.displayProcess('Generating module files...');
						        fm.setScript('<xsl:apply-templates select="$element" mode="element-script-gen-files" />');
						        fm.parseAndSend($(this).parents('form'));
						
						        return false;
							</xsl:attribute>
						</input>
					</form>
				</xsl:with-param>
			</xsl:call-template> 
		</xsl:if>
    </xsl:template>
    
    <!-- custom : default navigation items -->
    <xsl:template name="panel-block-details-nav-element">
    	<xsl:param name="element" />
    	
		<xsl:call-template name="navigationdetailsitem">
			<xsl:with-param name="title" select="'Fields'"/>
			<xsl:with-param name="panelURI" select="'modules/FieldsBrowse'"/>
            <xsl:with-param name="cssclass">first</xsl:with-param>
			<xsl:with-param name="params">
				<xsl:text>moduleDenom:'</xsl:text>
				<xsl:value-of select="$element/INFO/DENOMINATION" />
				<xsl:text>',moduleID:'</xsl:text>
				<xsl:value-of select="$element/@ID" />
				<xsl:text>'</xsl:text>
			</xsl:with-param>
			<xsl:with-param name="icon">
			</xsl:with-param> 
		</xsl:call-template> 
		<xsl:call-template name="navigationdetailsitem">
			<xsl:with-param name="title" select="'Processors'"/>
			<xsl:with-param name="panelURI" select="'modules/ProcessorsBrowse'"/>
			<xsl:with-param name="params">
				<xsl:text>moduleDenom:'</xsl:text>
				<xsl:value-of select="$element/INFO/DENOMINATION" />
				<xsl:text>',moduleID:'</xsl:text>
				<xsl:value-of select="$element/@ID" />
				<xsl:text>'</xsl:text>
			</xsl:with-param>
			<xsl:with-param name="icon">
			</xsl:with-param> 
		</xsl:call-template>
		<xsl:call-template name="navigationdetailsitem">
			<xsl:with-param name="title" select="'Dependencies'"/>
			<xsl:with-param name="panelURI" select="'modules/DependenciesBrowse'"/>
			<xsl:with-param name="params">
				<xsl:text>module:'</xsl:text>
				<xsl:value-of select="$element/INFO/DENOMINATION" />
				<xsl:text>',moduleID:</xsl:text>
				<xsl:value-of select="$element/@ID" />
			</xsl:with-param>
			<xsl:with-param name="icon">
			</xsl:with-param> 
		</xsl:call-template>
		<xsl:call-template name="navigationdetailsitem">
			<xsl:with-param name="title" select="'Display config'"/>
			<xsl:with-param name="panelURI" select="'modules/DisplayConfig'"/>
			<xsl:with-param name="params">
				<xsl:text>module:'</xsl:text>
				<xsl:value-of select="$element/INFO/DENOMINATION" />
				<xsl:text>'</xsl:text>
			</xsl:with-param>
			<xsl:with-param name="icon">
			</xsl:with-param> 
		</xsl:call-template>
		<xsl:call-template name="navigationdetailsitem">
            <xsl:with-param name="title" select="'Browse Elements'" />
            <xsl:with-param name="panelURI" select="'../../system/tools/element/QuickSearch'" />
            <xsl:with-param name="editor">
            	<xsl:apply-templates select="$templateItem" mode="element-application-editor"/>
            </xsl:with-param>
            <xsl:with-param name="app">
            	<xsl:apply-templates select="$templateItem" mode="element-application"/>
            </xsl:with-param>
            <xsl:with-param name="params">
            	<xsl:text>module:'</xsl:text>
            	<xsl:value-of select="$element/INFO/DENOMINATION"/>
            	<xsl:text>'</xsl:text>
            </xsl:with-param>
		</xsl:call-template>
		<xsl:call-template name="navigationdetailsitem">
            <xsl:with-param name="title" select="'New Element'" />
			<xsl:with-param name="panelURI">
				<xsl:apply-templates select="$templateItem" mode="element-script-new"/>
			</xsl:with-param>
            <xsl:with-param name="editor">
            	<xsl:apply-templates select="$templateItem" mode="element-application-editor"/>
            </xsl:with-param>
            <xsl:with-param name="app">
            	<xsl:apply-templates select="$templateItem" mode="element-application"/>
            </xsl:with-param>
            <xsl:with-param name="params">
            	<xsl:apply-templates select="$templateItem" mode="element-navitem-parms"/>
            </xsl:with-param>
		</xsl:call-template>
		<xsl:call-template name="navigationdetailsitem">
            <xsl:with-param name="title" select="'Browse Raw Elements'" />
            <xsl:with-param name="panelURI" select="'../../system/tools/element/RawQuickSearch'" />
            <xsl:with-param name="params">
            	<xsl:text>module:'</xsl:text>
            	<xsl:value-of select="$element/INFO/DENOMINATION"/>
            	<xsl:text>',editor:'</xsl:text>
            	<xsl:apply-templates select="$templateItem" mode="element-application-editor"/>
            	<xsl:text>',app:'</xsl:text>
            	<xsl:apply-templates select="$templateItem" mode="element-application"/>
            	<xsl:text>'</xsl:text>
            </xsl:with-param>
		</xsl:call-template>
		<xsl:call-template name="navigationdetailsitem">
            <xsl:with-param name="title" select="'New Raw Element'" />
			<xsl:with-param name="panelURI">
				<xsl:text>../../system/tools/element/New</xsl:text>
			</xsl:with-param>
            <xsl:with-param name="params">
				<xsl:text>module:'</xsl:text>
            	<xsl:value-of select="$element/INFO/DENOMINATION"/>
            	<xsl:text>'</xsl:text>
            </xsl:with-param>
		</xsl:call-template>
	    <xsl:call-template name="nav-search">
	        <xsl:with-param name="title">Advanced search</xsl:with-param>
	        <xsl:with-param name="module" select="$element/INFO/DENOMINATION" />
	        <xsl:with-param name="icon" select="''"/>
	    </xsl:call-template>
	    <xsl:call-template name="nav-savedfilters">
	        <xsl:with-param name="title">Saved filters</xsl:with-param>
	        <xsl:with-param name="module" select="$element/INFO/DENOMINATION" />
	        <xsl:with-param name="icon" select="''"/>
	    </xsl:call-template>
		<xsl:call-template name="nav-links">
			<xsl:with-param name="title" select="'Editor'"/>
			<xsl:with-param name="panelURI" select="'namespaces/NamespaceLink'"/>
			<xsl:with-param name="module" select="'module'" />
			<xsl:with-param name="originID" select="$element/@ID" />
			<xsl:with-param name="targetModule" select="'namespace'" />
			<xsl:with-param name="dependency" select="'officity:moduleNamespaces'"/>
			<xsl:with-param name="icon">
			</xsl:with-param>
		</xsl:call-template>
        <xsl:call-template name="new-followup">
            <xsl:with-param name="title">Follow-up</xsl:with-param>
            <xsl:with-param name="element" select="$element" />
        </xsl:call-template>
		<xsl:call-template name="history-list">
			<xsl:with-param name="title">History</xsl:with-param>
			<xsl:with-param name="element" select="$element" />
			<xsl:with-param name="cssclass">last</xsl:with-param>
		</xsl:call-template>		
    </xsl:template>
</xsl:stylesheet>