<?xml version="1.0"?>
<!--

Officity - Web application platform - Version 6.0 - 2011-07-05

François Dispaux, Boris Verdeyen, Thomas Hermant,
Jérémie Roy, Grégory Meurice, Abdelila Harbi, 
Marc Mignonsin, Jonathan Sanchez, Julien Gonzalez, Pierre Fouchez

Sushee and Officity is © Copyright 2011 Nectil SA.

`/var/www/installer/public_html/officity-source/apps/officity/factory/modules/ProcessorDetails.xsl` is part of Officity.

Sushee is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

Officity and Sushee are distributed in the hope that they will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Sushee. If not, see <http://www.gnu.org/licenses/>.

-->
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0" xmlns:OFFICITY="http://officity.com">
    <xsl:import href="include.xsl"/>    
    <xsl:output encoding="UTF-8" method="xml" indent="no"/>
    <xsl:strip-space elements="*"/>
    
    <!-- parameters -->
    <xsl:param name="fields" select="/RESPONSE/RESULTS[@name='fields']/FIELD"/>
    <xsl:param name="depentities" select="/RESPONSE/RESULTS[@name='dependencies']/DEPENDENCYENTITY"/>
  	<!--xsl:param name="descriptions" select="/RESPONSE/RESULTS[@name='descriptions']/DESCRIPTIONCONFIG"/-->
  	
    <xsl:param name="item" select="/RESPONSE/RESULTS[@name='item']/*[1]"/>
    <xsl:param name="itemInfo" select="$item/INFO"/>
    <xsl:param name="itemDeps" select="$item/DEPENDENCIES"/>
    <xsl:param name="itemDescs" select="$item/DESCRIPTIONS"/>
    <xsl:param name="module" select="/RESPONSE/URL/module"/>
    
    <!-- optional -->
    <xsl:param name="dependency" select="/RESPONSE/URL/dependency"/>
    <xsl:param name="targetModule" select="/RESPONSE/URL/targetModule"/>
    <xsl:param name="targetID" select="/RESPONSE/URL/targetID"/>
    
   	<xsl:template match="/RESPONSE">
    	<xsl:call-template name="panel-elementdetails">
    		<xsl:with-param name="element" select= "$item" />
    		<xsl:with-param name="tabsList">
				<xsl:text>details,Details;</xsl:text>
    		</xsl:with-param>
    		 <xsl:with-param name="displayOverviewTab" select="false()" />
    		 <xsl:with-param name="displayAdminTab" select="true()" />
    		 <xsl:with-param name="deleteRight" select="true()" />
    	</xsl:call-template>
    </xsl:template>
    
    <!-- custom : tabs content -->
	<xsl:template name="panel-body-element-tabs-content">
		<xsl:param name="element" />
		<xsl:param name="newElement" />
		
		<!-- tab : details -->
  		<xsl:call-template name="element-tabform-create">
			<xsl:with-param name="denom" select="'details'" />
			<xsl:with-param name="element" select="$element" />
			<xsl:with-param name="content">
				<xsl:call-template name="element-tab-details">
					<xsl:with-param name="element" select="$element" />
				</xsl:call-template>
			</xsl:with-param>
		</xsl:call-template>
	</xsl:template>
    
    <!-- custom : details tab -->
    <xsl:template name="element-tab-details">
        <xsl:param name="element" />    
           
		<xsl:call-template name="overview-line">
			<xsl:with-param name="label" select="'Module:'" />
			<xsl:with-param name="value" select="/RESPONSE/RESULTS[@name='targetModule']/MODULE/INFO/DENOMINATION" />
		</xsl:call-template>
       	<xsl:apply-templates select="$element/INFO/TYPE" mode="form-info-line">
       	</xsl:apply-templates>
       	<xsl:apply-templates select="$element/INFO/COMMAND" mode="form-info-line">
       	</xsl:apply-templates>          
       	<xsl:apply-templates select="$element/INFO/PATH" mode="form-info-line">
       		<xsl:with-param name="required" select="true()" />
       	</xsl:apply-templates> 
       	<xsl:apply-templates select="$element/INFO/CLASSNAME" mode="form-info-line" />     
       	<xsl:apply-templates select="$element/INFO/METHOD" mode="form-info-line" />     
       	<xsl:apply-templates select="$element/INFO/ORDERING" mode="form-info-line">
       		<xsl:with-param name="extraLabel" select="'Leave empty if not relevant'" />
       	</xsl:apply-templates>     
       	 
       	<xsl:apply-templates select="$element" mode="form-info-line-submit" />
    </xsl:template>
       
    <!-- custom : default navigation items -->
    <xsl:template name="panel-block-details-nav-element">
    	<xsl:param name="element" />
    	
		<xsl:call-template name="navigationdetailsitem">
			<xsl:with-param name="title" select="'Module'"/>
			<xsl:with-param name="panelURI">
				<xsl:apply-templates select="/RESPONSE/RESULTS[@name='targetModule']/MODULE" mode="element-script-detail" />
			</xsl:with-param>
			<xsl:with-param name="params">
				<xsl:apply-templates select="/RESPONSE/RESULTS[@name='targetModule']/MODULE" mode="element-navitem-parms" />
			</xsl:with-param>
            <xsl:with-param name="cssclass">first</xsl:with-param>
		</xsl:call-template> 
        <xsl:call-template name="new-followup">
            <xsl:with-param name="title">Follow-up</xsl:with-param>
            <xsl:with-param name="element" select="$element" />
        </xsl:call-template>
		<xsl:call-template name="history-list">
			<xsl:with-param name="title">History</xsl:with-param>
			<xsl:with-param name="element" select="$element" />
			<xsl:with-param name="cssclass">last</xsl:with-param>
		</xsl:call-template>		
    </xsl:template>
</xsl:stylesheet>