<?xml version="1.0"?>
<!--

Officity - Web application platform - Version 6.0 - 2011-07-05

François Dispaux, Boris Verdeyen, Thomas Hermant,
Jérémie Roy, Grégory Meurice, Abdelila Harbi, 
Marc Mignonsin, Jonathan Sanchez, Julien Gonzalez, Pierre Fouchez

Sushee and Officity is © Copyright 2011 Nectil SA.

`/var/www/installer/public_html/officity-source/apps/officity/factory/modules/ProcessorsBrowse.xsl` is part of Officity.

Sushee is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

Officity and Sushee are distributed in the hope that they will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Sushee. If not, see <http://www.gnu.org/licenses/>.

-->
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0" xmlns:OFFICITY="http://officity.com">
    <xsl:import href="include.xsl"/>
    <xsl:output encoding="UTF-8" method="xml" indent="no"/>
    <xsl:strip-space elements="*"/>
    
	<!-- parameters -->
    <xsl:param name="module" select="/RESPONSE/URL/module"/>
    <xsl:param name="searchText" select="/RESPONSE/URL/quicksearch-text" />

	<xsl:template match="/RESPONSE">
		<xsl:call-template name="panel-quicksearch">
			<xsl:with-param name="list" select="/RESPONSE/RESULTS[@name='list']"/>
	        <xsl:with-param name="addNew" select="true()"/>
	        <xsl:with-param name="pagingStyle" select="'pager'"/>
	        <xsl:with-param name="searchText">
	        	<xsl:text>Search for </xsl:text>
	        	<xsl:value-of select="/RESPONSE/URL/moduleDenom" />
	        	<xsl:text> processors...</xsl:text>
	        </xsl:with-param>
	        <xsl:with-param name="params">
	        	<xsl:text>moduleDenom:'</xsl:text>
	        	<xsl:value-of select="/RESPONSE/URL/moduleDenom" />
	        	<xsl:text>',moduleID:'</xsl:text>
	        	<xsl:value-of select="/RESPONSE/URL/moduleID" />
	        	<xsl:text>'</xsl:text>
	        </xsl:with-param>
		</xsl:call-template>
    </xsl:template>
    
	<!-- quicksearch list header -->
	<xsl:template name="panel-list-header-quicksearch">
        <xsl:param name="list" />
        <xsl:param name="module" />
        <xsl:param name="addNew" />
        <xsl:param name="addNewScript" />
        
        <xsl:call-template name="nav-new">
            <xsl:with-param name="title">Create Processor...</xsl:with-param>
            <xsl:with-param name="module" select="$module" />
            <xsl:with-param name="panelURI" select="'modules/ProcessorNew'" />
            <xsl:with-param name="params">
	            <xsl:text>searchText:'</xsl:text>
	            <xsl:value-of select="/RESPONSE/URL/quicksearch-text" />
	            <xsl:text>',</xsl:text>
	        	<xsl:text>targetModuleID:</xsl:text>
	        	<xsl:value-of select="/RESPONSE/URL/moduleID" />
            </xsl:with-param>
            <xsl:with-param name="cssclass" select="'grey-bkgnd'" />
        </xsl:call-template>
	</xsl:template>
	
	<!-- quicksearch list -->
	<xsl:template name="panel-list-quicksearch">
		<xsl:param name="list" />
        <xsl:choose>
            <xsl:when test="$list/@hits > 0">
                <xsl:for-each select="$list/*">
                	<xsl:sort select="contains(INFO/COMMAND,'CREATE')"  order="descending"/>
                	<xsl:sort select="contains(INFO/COMMAND,'UPDATE')"  order="descending"/>
                	<xsl:sort select="contains(INFO/COMMAND,'KILL')"  order="descending"/>
                	<xsl:sort select="contains(INFO/COMMAND,'DELETE')"  order="descending"/>
                	<xsl:sort select="contains(INFO/COMMAND,'SEARCH')"  order="descending"/>
                	<xsl:sort select="INFO/ORDERING" />
                	<xsl:sort select="INFO/TYPE" order="descending"/>
                    <xsl:apply-templates select="." mode="element-navitem-quicksearch" />
                </xsl:for-each>
            </xsl:when>
            <xsl:otherwise>
                <div class="no-result">
                	<xsl:text>No hits</xsl:text>
                    <xsl:if test="/RESPONSE/MESSAGE[@msgType!='0']">
                		<br />
                		<span style="font-size:0.6em;">
                			<xsl:text>Warning: </xsl:text>
                			<xsl:value-of select="/RESPONSE/MESSAGE[@msgType!='0']" />
               			</span>
                	</xsl:if>
                </div>
            </xsl:otherwise>
        </xsl:choose>
	</xsl:template>
</xsl:stylesheet>
