<?xml version="1.0"?>
<!--

Officity - Web application platform - Version 6.0 - 2011-07-05

François Dispaux, Boris Verdeyen, Thomas Hermant,
Jérémie Roy, Grégory Meurice, Abdelila Harbi, 
Marc Mignonsin, Jonathan Sanchez, Julien Gonzalez, Pierre Fouchez

Sushee and Officity is © Copyright 2011 Nectil SA.

`/var/www/installer/public_html/officity-source/apps/officity/factory/modules/RawModuleDetails.xsl` is part of Officity.

Sushee is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

Officity and Sushee are distributed in the hope that they will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Sushee. If not, see <http://www.gnu.org/licenses/>.

-->
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0" xmlns:OFFICITY="http://officity.com">
    <xsl:import href="include.xsl"/>    
    <xsl:output encoding="UTF-8" method="xml" indent="no"/>
    <xsl:strip-space elements="*"/>
    
    <!-- parameters -->    
    <xsl:param name="fields" select="/RESPONSE/RESULTS[@name='fields']/FIELD"/>
    <xsl:param name="depentities" select="/RESPONSE/RESULTS[@name='dependencies']/DEPENDENCYENTITY"/>
  	<!--xsl:param name="descriptions" select="/RESPONSE/RESULTS[@name='descriptions']/DESCRIPTIONCONFIG"/-->
  	
    <xsl:param name="item" select="/RESPONSE/RESULTS[@name='item']/*[1]"/>
    <xsl:param name="itemInfo" select="$item/INFO"/>
    <xsl:param name="itemDeps" select="$item/DEPENDENCIES"/>
    <xsl:param name="itemDescs" select="$item/DESCRIPTIONS"/>
    <xsl:param name="module" select="/RESPONSE/URL/module"/>
    <xsl:param name="templateItem" select="/RESPONSE/RESULTS[@name='templateItem']/*[1]"/>
    
    <!-- optional -->
    <xsl:param name="dependency" select="/RESPONSE/URL/dependency"/>
    <xsl:param name="targetModule" select="/RESPONSE/URL/targetModule"/>
    <xsl:param name="targetID" select="/RESPONSE/URL/targetID"/>
    
   	<xsl:template match="/RESPONSE">
    	<xsl:call-template name="panel-elementdetails">
    		<xsl:with-param name="element" select= "$item" />
    		<xsl:with-param name="tabsList">
				<xsl:text>details,Details;display,Display;</xsl:text>
    		</xsl:with-param>
    		 <xsl:with-param name="displayOverviewTab" select="false()" />
    		 <xsl:with-param name="displayAdminTab" select="true()" />
    		 <xsl:with-param name="deleteRight" select="true()" />
    	</xsl:call-template>
    </xsl:template>
    
    <!-- custom : tabs content -->
	<xsl:template name="panel-body-element-tabs-content">
		<xsl:param name="element" />
		<xsl:param name="newElement" />
		
		<!-- tab : details -->
  		<xsl:call-template name="element-tabform-create">
			<xsl:with-param name="denom" select="'details'" />
			<xsl:with-param name="element" select="$element" />
			<xsl:with-param name="content">
				<xsl:call-template name="element-tab-details">
					<xsl:with-param name="element" select="$element" />
				</xsl:call-template>
			</xsl:with-param>
		</xsl:call-template>
		
		<!-- tab : display -->
  		<xsl:call-template name="element-tabform-create">
			<xsl:with-param name="denom" select="'display'" />
			<xsl:with-param name="element" select="$element" />
			<xsl:with-param name="content">
				<xsl:call-template name="element-tab-display">
					<xsl:with-param name="element" select="$element" />
				</xsl:call-template>
			</xsl:with-param>
		</xsl:call-template>
	</xsl:template>
    
    <!-- custom : details tab -->
    <xsl:template name="element-tab-details">
        <xsl:param name="element" />    
           
     	<xsl:call-template name="overview-line">
       		<xsl:with-param name="label" select="'Editor:'" />
	    	<xsl:with-param name="value">
                <xsl:apply-templates select="$element/DEPENDENCIES/DEPENDENCY[@type='officity:moduleNamespaces']/NAMESPACE" mode="element-label" />
	    	</xsl:with-param>
    	</xsl:call-template>
    	
       	<xsl:apply-templates select="$element/INFO/DENOMINATION" mode="overview-line">
       	</xsl:apply-templates>
       	
       	<xsl:call-template name="overview-line">
			<xsl:with-param name="label" select="'Type:'"  />
			<xsl:with-param name="value">
				<xsl:choose>
					<xsl:when test="$element/INFO/EXTENDS/text()">
						<xsl:value-of select="/RESPONSE/RESULTS/LIST[@name='ModuleTypes']/ITEM[@value='extends']/@label" />
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="/RESPONSE/RESULTS/LIST[@name='ModuleTypes']/ITEM[@value='base']/@label" />
					</xsl:otherwise>
				</xsl:choose>
			</xsl:with-param>
		</xsl:call-template>
		
		<xsl:if test="$element/INFO/EXTENDS/text()">
    	   	<xsl:apply-templates select="$element/INFO/EXTENDS" mode="overview-line">
	       	</xsl:apply-templates>
       	</xsl:if>
       	
       	<xsl:apply-templates select="$element/INFO/TABLENAME" mode="overview-line">
       	</xsl:apply-templates> 
       	
       	<xsl:apply-templates select="$element/INFO/ADVANCEDSECURITY" mode="form-info-line">
       	</xsl:apply-templates> 
       	 
       	<xsl:apply-templates select="$element" mode="form-info-line-submit" />
    </xsl:template>
    
       <!-- custom : display tab -->
    <xsl:template name="element-tab-display">
        <xsl:param name="element" />  
        
	  	<xsl:call-template name="form-desc-line">
	  		<xsl:with-param name="moduleName" select="name($element)" />
	  		<xsl:with-param name="fieldName" select="'TITLE'" />
		    <xsl:with-param name="label" select="'Label: '" />
		    <xsl:with-param name="type" select="'text'" />
		    <xsl:with-param name="languageID" select="'shared'" />
		    <xsl:with-param name="inputValue" select="$element/DESCRIPTIONS/DESCRIPTION[@languageID='shared']/TITLE" />
	   </xsl:call-template>
	  	<xsl:call-template name="form-desc-line">
	  		<xsl:with-param name="moduleName" select="name($element)" />
	  		<xsl:with-param name="fieldName" select="'HEADER'" />
		    <xsl:with-param name="label" select="'Plural form: '" />
		    <xsl:with-param name="type" select="'text'" />
		    <xsl:with-param name="languageID" select="'shared'" />
		    <xsl:with-param name="inputValue" select="$element/DESCRIPTIONS/DESCRIPTION[@languageID='shared']/HEADER" />
	    </xsl:call-template>
	  	<xsl:call-template name="form-desc-line">
	  		<xsl:with-param name="moduleName" select="name($element)" />
	  		<xsl:with-param name="fieldName" select="'SUMMARY'" />
		    <xsl:with-param name="label" select="'Abbreviation: '" />
		    <xsl:with-param name="type" select="'text'" />
	     	<xsl:with-param name="languageID" select="'shared'" />
	     	<xsl:with-param name="inputValue" select="$element/DESCRIPTIONS/DESCRIPTION[@languageID='shared']/SUMMARY" />
	    </xsl:call-template>
	    
       	<xsl:apply-templates select="$element/INFO/ICON" mode="form-info-line">
       		<xsl:with-param name="label" select="'Icon path (relative to the editor): '" />
       	</xsl:apply-templates> 
       	
       	<xsl:apply-templates select="$element" mode="form-desc-line-submit" />
    </xsl:template>
    
    <!-- custom : default navigation items -->
    <xsl:template name="panel-block-details-nav-element">
    	<xsl:param name="element" />
    	
		<xsl:call-template name="navigationdetailsitem">
			<xsl:with-param name="title" select="'Fields'"/>
			<xsl:with-param name="panelURI" select="'modules/FieldsBrowse'"/>
            <xsl:with-param name="cssclass">first</xsl:with-param>
			<xsl:with-param name="params">
				<xsl:text>moduleDenom:'</xsl:text>
				<xsl:value-of select="$element/INFO/DENOMINATION" />
				<xsl:text>',moduleID:'</xsl:text>
				<xsl:value-of select="$element/@ID" />
				<xsl:text>'</xsl:text>
			</xsl:with-param>
			<xsl:with-param name="icon">
			</xsl:with-param> 
		</xsl:call-template> 
		<xsl:call-template name="navigationdetailsitem">
			<xsl:with-param name="title" select="'Processors'"/>
			<xsl:with-param name="panelURI" select="'modules/ProcessorsBrowse'"/>
			<xsl:with-param name="params">
				<xsl:text>moduleDenom:'</xsl:text>
				<xsl:value-of select="$element/INFO/DENOMINATION" />
				<xsl:text>',moduleID:'</xsl:text>
				<xsl:value-of select="$element/@ID" />
				<xsl:text>'</xsl:text>
			</xsl:with-param>
			<xsl:with-param name="icon">
			</xsl:with-param> 
		</xsl:call-template>
		<xsl:call-template name="navigationdetailsitem">
			<xsl:with-param name="title" select="'Dependencies'"/>
			<xsl:with-param name="panelURI" select="'modules/DependenciesBrowse'"/>
			<xsl:with-param name="params">
				<xsl:text>module:'</xsl:text>
				<xsl:value-of select="$element/INFO/DENOMINATION" />
				<xsl:text>'</xsl:text>
			</xsl:with-param>
			<xsl:with-param name="icon">
			</xsl:with-param> 
		</xsl:call-template>
		<xsl:call-template name="navigationdetailsitem">
            <xsl:with-param name="title" select="'Browse Elements'" />
            <xsl:with-param name="panelURI" select="'../../system/tools/element/QuickSearch'" />
            <xsl:with-param name="params">
            	<xsl:text>module:'</xsl:text>
            	<xsl:value-of select="$element/INFO/DENOMINATION"/>
            	<xsl:text>',editor:'</xsl:text>
            	<xsl:apply-templates select="$templateItem" mode="element-application-editor"/>
            	<xsl:text>',app:'</xsl:text>
            	<xsl:apply-templates select="$templateItem" mode="element-application"/>
            	<xsl:text>'</xsl:text>
            </xsl:with-param>
		</xsl:call-template>
		<xsl:call-template name="navigationdetailsitem">
            <xsl:with-param name="title" select="'Browse Elements (raw)'" />
            <xsl:with-param name="panelURI" select="'../../system/tools/element/RawQuickSearch'" />
            <xsl:with-param name="params">
            	<xsl:text>module:'</xsl:text>
            	<xsl:value-of select="$element/INFO/DENOMINATION"/>
            	<xsl:text>',editor:'</xsl:text>
            	<xsl:apply-templates select="$templateItem" mode="element-application-editor"/>
            	<xsl:text>',app:'</xsl:text>
            	<xsl:apply-templates select="$templateItem" mode="element-application"/>
            	<xsl:text>'</xsl:text>
            </xsl:with-param>
		</xsl:call-template>
		<xsl:call-template name="navigationdetailsitem">
            <xsl:with-param name="title" select="'New Element'" />
			<xsl:with-param name="panelURI">
				<xsl:apply-templates select="$templateItem" mode="element-script-new"/>
			</xsl:with-param>
            <xsl:with-param name="params">
            	<xsl:apply-templates select="$templateItem" mode="element-navitem-parms"/>
            </xsl:with-param>
		</xsl:call-template>
		<xsl:call-template name="navigationdetailsitem">
            <xsl:with-param name="title" select="'New Raw Element'" />
			<xsl:with-param name="panelURI">
				<xsl:text>../../system/tools/element/New</xsl:text>
			</xsl:with-param>
            <xsl:with-param name="params">
				<xsl:text>module:'</xsl:text>
            	<xsl:value-of select="$element/INFO/DENOMINATION"/>
            	<xsl:text>'</xsl:text>
            </xsl:with-param>
		</xsl:call-template>
        <xsl:call-template name="new-followup">
            <xsl:with-param name="title">Follow-up</xsl:with-param>
            <xsl:with-param name="element" select="$element" />
        </xsl:call-template>
		<xsl:call-template name="history-list">
			<xsl:with-param name="title">History</xsl:with-param>
			<xsl:with-param name="element" select="$element" />
			<xsl:with-param name="cssclass">last</xsl:with-param>
		</xsl:call-template>		
    </xsl:template>
</xsl:stylesheet>