<?xml version="1.0"?>
<!--

Officity - Web application platform - Version 6.0 - 2011-07-05

François Dispaux, Boris Verdeyen, Thomas Hermant,
Jérémie Roy, Grégory Meurice, Abdelila Harbi, 
Marc Mignonsin, Jonathan Sanchez, Julien Gonzalez, Pierre Fouchez

Sushee and Officity is © Copyright 2011 Nectil SA.

`/var/www/installer/public_html/officity-source/apps/officity/factory/namespaces/New.xsl` is part of Officity.

Sushee is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

Officity and Sushee are distributed in the hope that they will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Sushee. If not, see <http://www.gnu.org/licenses/>.

-->
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0" xmlns:OFFICITY="http://officity.com">
    <xsl:import href="include.xsl"/>    
    <xsl:output encoding="UTF-8" method="xml" indent="no"/>
    <xsl:strip-space elements="*"/>
    
    <!-- parameters -->
    <xsl:param name="fields" select="/RESPONSE/RESULTS[@name='fields']/FIELD"/>
    <xsl:param name="item" select="/RESPONSE/RESULTS[@name='item']/*[1]"/>
    <xsl:param name="module" select="/RESPONSE/URL/module"/>
    
    <!-- optional -->
    <xsl:param name="dependency" select="/RESPONSE/URL/dependency"/>
    <xsl:param name="targetModule" select="/RESPONSE/URL/targetModule"/>
    <xsl:param name="targetID" select="/RESPONSE/URL/targetID"/>
    
   	<xsl:template match="/RESPONSE">
    	<xsl:call-template name="panel-newelement">
    		<xsl:with-param name="element" select= "$item" />
    		<xsl:with-param name="title" select= "'New editor'" />
    		<xsl:with-param name="titlecssclass" select= "'namespace'" />
    		<xsl:with-param name="tabsList" select= "'info,Details;'" />
    	</xsl:call-template>
    </xsl:template>
    
    <!-- custom : info form -->
    <xsl:template name="element-tab-info">
        <xsl:param name="element" />  

       	<xsl:apply-templates select="$element/INFO/EDITOR" mode="form-info-line">
       		<xsl:with-param name="label" select="'Editor name: '" />
	    	<xsl:with-param name="extraLabel">
	    		<xsl:text>Editor's real name, e.g.: Nectil S.A.</xsl:text>
	    	</xsl:with-param>
       	</xsl:apply-templates>              	
       	<xsl:apply-templates select="$element/INFO/NAMESPACE" mode="form-info-line">
       		<xsl:with-param name="label" select="'Namespace (only chars from a to z): '"  />
       		<xsl:with-param name="required" select="true()"  />
	    	<xsl:with-param name="extraLabel">
	    		<xsl:text>A unique and short technical name, e.g.: nec</xsl:text>
	    	</xsl:with-param>
       	</xsl:apply-templates>
       	<xsl:apply-templates select="$element/INFO/URL" mode="form-info-line">
       		<xsl:with-param name="required" select="true()"  />
	    	<xsl:with-param name="extraLabel">
	    		<xsl:text>Editor's URL, e.g.: http://nectil.com</xsl:text>
	    	</xsl:with-param>
       	</xsl:apply-templates>
       	<xsl:apply-templates select="$element/INFO/ICON" mode="form-info-line">
       		<xsl:with-param name="label" select="'Icon path (relative to this editor): '" />
       	</xsl:apply-templates> 
       	 
       	<xsl:apply-templates select="$element" mode="form-info-line-submit">
       		<xsl:with-param name="buttonLabel" select="'Create'"/>
       	</xsl:apply-templates>
    </xsl:template>
    
    <!-- custom : default navigation items -->
    <!--xsl:template name="panel-block-details-nav-element">
    	<xsl:param name="element" />
    	
		<xsl:call-template name="navigationdetailsitem">
			<xsl:with-param name="title" select="'Publishers'"/>
			<xsl:with-param name="panelURI" select="'publishers/Index'"/>
            <xsl:with-param name="cssclass">first last</xsl:with-param>
			<xsl:with-param name="params">
			</xsl:with-param>
			<xsl:with-param name="icon">
				<xsl:text>../system/images/icons/publish/publishers.png</xsl:text>
			</xsl:with-param> 
		</xsl:call-template>		
    </xsl:template-->
</xsl:stylesheet>