<?xml version="1.0"?>
<!--

Officity - Web application platform - Version 6.0 - 2011-07-05

François Dispaux, Boris Verdeyen, Thomas Hermant,
Jérémie Roy, Grégory Meurice, Abdelila Harbi, 
Marc Mignonsin, Jonathan Sanchez, Julien Gonzalez, Pierre Fouchez

Sushee and Officity is © Copyright 2011 Nectil SA.

`/var/www/installer/public_html/officity-source/apps/officity/lib/documents/ChapterContent.xsl` is part of Officity.

Sushee is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

Officity and Sushee are distributed in the hope that they will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Sushee. If not, see <http://www.gnu.org/licenses/>.

-->
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0" xmlns:OFFICITY="http://officity.com">
    <xsl:import href="include.xsl"/>
    <xsl:output encoding="UTF-8" method="xml" indent="no"/>
    <xsl:strip-space elements="*"/>
    
    <xsl:param name="container" select="/RESPONSE/RESULTS[@name='item']/OFFICITY:LIBITEM" />
    <xsl:param name="list" select="/RESPONSE/RESULTS[@name='list']" />
    <xsl:param name="items" select="$list/OFFICITY:LIBITEM[INFO/TRASHED='no']" />
    
    <!-- IDs -->
    <xsl:param name="quickAddPageFormID">
        <xsl:text>header-pageform-</xsl:text><xsl:value-of select="$panelID" />
    </xsl:param>

	<xsl:template match="/RESPONSE">	
    	<xsl:call-template name="panel-quicksearch">
			<xsl:with-param name="list" select="/RESPONSE/RESULTS[@name='list']"/>
			<xsl:with-param name="module" select="'officity:libitem'" />
			<xsl:with-param name="pagingStyle" select="'pager'"/>
	        <xsl:with-param name="addNew" select="false()" />  
	        <xsl:with-param name="params">
				<xsl:text>ID:</xsl:text>
				<xsl:value-of select="$container/@ID" />
	        </xsl:with-param>
    	</xsl:call-template>
    </xsl:template>

	<!-- custom : header -->
	<xsl:template name="panel-header-quicksearch">
		<form id="quichsearch-form" onsubmit="return false;" style="width:25%">
			<xsl:call-template name="header-quicksearch-input">
				<xsl:with-param name="ID">
					<xsl:text>quicksearch-text</xsl:text>
				</xsl:with-param>
				<xsl:with-param name="searchText" select="'Quick search...'" />
				<xsl:with-param name="resetID">
					<xsl:text>quicksearch-reset</xsl:text>
				</xsl:with-param>
			</xsl:call-template>
		</form>
		
		<form id="{$quickAddPageFormID}" name="{$quickAddPageFormID}" class="quickadd-form" style="width:20%">
  			<input type="hidden" value="page">
				<xsl:attribute name="name">
					<xsl:call-template name="gen-info-input-name">
						<xsl:with-param name="moduleName" select="'officity:libitem'" />
						<xsl:with-param name="fieldName" select="'TYPE'" />
					</xsl:call-template>
				</xsl:attribute>
   			</input>
			<input type="hidden" name="dependency" value="officity:content" />
			<input type="hidden" name="targetModule" value="officity:libitem" />
			<input type="hidden" name="targetID" value="{$container/@ID}" />
			<xsl:call-template name="header-input">
				<xsl:with-param name="name">
					<xsl:call-template name="gen-desc-input-name">
						<xsl:with-param name="languageID" select="/RESPONSE/NECTIL/language" />
						<xsl:with-param name="moduleName" select="'officity:libitem'" />
						<xsl:with-param name="fieldName" select="'TITLE'" />
					</xsl:call-template>
				</xsl:with-param>
				<xsl:with-param name="ID">
					<xsl:call-template name="gen-desc-input-ID">
						<xsl:with-param name="languageID" select="/RESPONSE/NECTIL/language" />
						<xsl:with-param name="moduleName" select="'officity:libitem'" />
						<xsl:with-param name="fieldName" select="'TITLE'" />
					</xsl:call-template>
					<xsl:text>-quickaddpage</xsl:text>
				</xsl:with-param>
				<xsl:with-param name="addText" select="'New page(s)...'" />
				<xsl:with-param name="imgcssclass" select="'img-page'" />
			</xsl:call-template>
		</form>
	</xsl:template>
	
	<!-- custom : list -->
	<xsl:template name="panel-list-quicksearch">  
		<xsl:param name="list" />
		
		<div class="wiki-header">
			<xsl:apply-templates select="$container" mode="element-title" />			
			<p class="summary">
				<xsl:apply-templates select="$container" mode="element-summary" />
			</p>
			<a class="info-action" href="#" title="Chapter details">
				<xsl:attribute name="onclick">
	                <xsl:call-template name="navhandler">
	                    <xsl:with-param name="title">
	                    	<xsl:text>Chapter details: </xsl:text>
	                    	<xsl:apply-templates select="$container" mode="element-label" />
                    	</xsl:with-param>
	                    <xsl:with-param name="panelURI">
	                    	<xsl:apply-templates select="$container" mode="element-script-detail" />
	                    </xsl:with-param>
	                    <xsl:with-param name="params">
	                    	<xsl:apply-templates select="$container" mode="element-navitem-parms" />
	                    </xsl:with-param>                    
	                </xsl:call-template>
				</xsl:attribute>
			</a>
			<a class="edit-action" href="#" title="Edit chapter">
				<xsl:attribute name="onclick">
				</xsl:attribute>
			</a>
		</div>
		<div class="wiki-body">
			<xsl:apply-templates select="$container" mode="element-body" />
		</div>
		
		<xsl:choose>  
			<xsl:when test="$items">
				<xsl:choose>
					<xsl:when test="/RESPONSE/URL/mode='searchitems'">
						<xsl:for-each select="$items" >					
							<xsl:sort select="INFO/TYPE='page'" />
							<xsl:sort select="INFO/KIND" />
							<xsl:sort select="INFO/TITLE" />
							<xsl:apply-templates select="." mode="element-navitem" />
						</xsl:for-each>
					</xsl:when>
					<xsl:when test="/RESPONSE/URL/mode='editchapter'">
						<!-- TODO :edit in place -->
						<div id="drag-container-{$panelID}">
							<xsl:choose>
								<xsl:when test="count($items)&gt;1">
									<xsl:for-each select="$items" >					
										<xsl:apply-templates select="." mode="element-navitem-draggable" />
									</xsl:for-each>
									<script type="text/javascript">
										<xsl:call-template name="init-draggable-js">
											<xsl:with-param name="container" select="$container" />
											<xsl:with-param name="itemsCount" select="count($items)" />
										</xsl:call-template>
									</script>
								</xsl:when>
								<xsl:otherwise>
									<xsl:for-each select="$items" >					
										<xsl:apply-templates select="." mode="element-navitem" />
									</xsl:for-each>
								</xsl:otherwise>
							</xsl:choose>
						</div>
					</xsl:when>
					<xsl:otherwise>
						<xsl:call-template name="choose-draggable-navigation">
							<xsl:with-param name="items" select="$items" />
							<xsl:with-param name="container" select="$container" />
						</xsl:call-template>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:when>
			<xsl:otherwise>
				<xsl:choose>
					<xsl:when test="/RESPONSE/URL/mode='searchitems'">
						<div class="no-result">No hits</div>
					</xsl:when>
					<xsl:otherwise>
						<div class="no-result">This chapter is empty</div>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	
	<!-- custom : additional js -->
	<xsl:template name="panel-add-js">
       <!-- quick add page -->
		<xsl:call-template name="init-panel-header-quickadd-js">
			<xsl:with-param name="formID" select="$quickAddPageFormID" /> 
			<xsl:with-param name="container" select="$container" />
			<xsl:with-param name="processingMsg" select="'Adding new page(s)...'" /> 
		</xsl:call-template>
		
		// reset header inputs
		$('#<xsl:value-of select="$panelID" />.panel').bind('panel-header-reset', function(){
			quickSearcher<xsl:value-of select="$panelID"/>.reset(false);
			$('#<xsl:value-of select="$panelID"/>').find('.panel-header').placeHolders('reset');
		});
	</xsl:template>
</xsl:stylesheet>