<?xml version="1.0"?>
<!--

Officity - Web application platform - Version 6.0 - 2011-07-05

François Dispaux, Boris Verdeyen, Thomas Hermant,
Jérémie Roy, Grégory Meurice, Abdelila Harbi, 
Marc Mignonsin, Jonathan Sanchez, Julien Gonzalez, Pierre Fouchez

Sushee and Officity is © Copyright 2011 Nectil SA.

`/var/www/installer/public_html/officity-source/apps/officity/lib/documents/ContentList.xsl` is part of Officity.

Sushee is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

Officity and Sushee are distributed in the hope that they will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Sushee. If not, see <http://www.gnu.org/licenses/>.

-->
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0" xmlns:OFFICITY="http://officity.com">
    <xsl:import href="include.xsl"/>
    <xsl:output encoding="UTF-8" method="xml" indent="no"/>
    <xsl:strip-space elements="*"/>

	<!-- parameters -->
    <xsl:param name="module" select="/RESPONSE/URL/module"/>
    <xsl:param name="searchText" select="/RESPONSE/URL/quicksearch-text" />
    <xsl:param name="originID" select="/RESPONSE/URL/originID"/>
    <xsl:param name="dependency" select="/RESPONSE/URL/dependency"/>
    <xsl:param name="targetModule" select="/RESPONSE/URL/targetModule"/>
    <xsl:param name="depsList" select="'depsList'"/>
    
	<xsl:template match="/RESPONSE">
		<xsl:choose>
			<xsl:when test="/RESPONSE/URL/trashed!='no'">
				<xsl:call-template name="panel-results">
					<xsl:with-param name="list" select="/RESPONSE/RESULTS[@name='list']"/>
					<xsl:with-param name="addNew" select="false()"/>
			        <xsl:with-param name="pagingStyle" select="'pager'"/>
			        <xsl:with-param name="params">
			        	<xsl:text>trashed:'</xsl:text>
			        	<xsl:value-of select="/RESPONSE/URL/trashed" />
			        	<xsl:text>'</xsl:text>
		        	</xsl:with-param>
				</xsl:call-template>
			</xsl:when>
			<xsl:otherwise>
				<xsl:call-template name="panel-link">
					<xsl:with-param name="list" select="/RESPONSE/RESULTS[@name='list']"/>
			        <xsl:with-param name="addNew" select="true()"/>
			        <xsl:with-param name="pagingStyle" select="'pager'"/>
			        <xsl:with-param name="params">
			        	<xsl:text>trashed:'</xsl:text>
			        	<xsl:value-of select="/RESPONSE/URL/trashed" />
			        	<xsl:text>'</xsl:text>
		        	</xsl:with-param>
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>
    </xsl:template>
    
	<!-- results list -->
	<xsl:template name="panel-list-results">
		<xsl:param name="list" />

		<xsl:variable name="items" select="$list/OFFICITY:LIBITEM[INFO/TYPE!='server']"/>
		
        <xsl:choose>
            <xsl:when test="$items">
                <xsl:for-each select="$items">
					<xsl:sort select="INFO/TYPE='page'" />
					<xsl:sort select="INFO/TYPE='chapter'" />
					<xsl:sort select="INFO/TYPE='book'" />
					<xsl:sort select="INFO/TYPE='file'" />
					<xsl:sort select="INFO/TYPE='folder'" />
					<xsl:sort select="INFO/TYPE='disk'" />
					<xsl:sort select="INFO/TITLE" />
					<xsl:sort select="INFO/KIND" />
                    <xsl:apply-templates select="." mode="element-navitem" />
                </xsl:for-each>
            </xsl:when>
            <xsl:otherwise>
                <div class="no-result">
           			<xsl:text>No content</xsl:text>
                </div>
            </xsl:otherwise>
        </xsl:choose>
	</xsl:template>
    
	<!-- custom : link list -->
	<xsl:template name="panel-list-link">
		<xsl:param name="list" select="$list" />
		
		<xsl:variable name="items" select="$list/OFFICITY:LIBITEM[INFO/TYPE!='server']"/>
		
        <xsl:choose>
            <xsl:when test="$items">
                <xsl:for-each select="$items">
					<xsl:sort select="INFO/TYPE='page'" />
					<xsl:sort select="INFO/TYPE='chapter'" />
					<xsl:sort select="INFO/TYPE='book'" />
					<xsl:sort select="INFO/TYPE='file'" />
					<xsl:sort select="INFO/TYPE='folder'" />
					<xsl:sort select="INFO/TYPE='disk'" />
					<xsl:sort select="INFO/TITLE" />
					<xsl:sort select="INFO/KIND" />
                    <xsl:apply-templates select="." mode="element-navitem-link" />
                </xsl:for-each>
            </xsl:when>
            <xsl:otherwise>
                <div class="no-result">
                	<xsl:choose>
                		<xsl:when test="/RESPONSE/URL/mode='searchitems'">
                			<xsl:text>No hits</xsl:text>
                		</xsl:when>
                		<xsl:otherwise>
                			<xsl:text>No content</xsl:text>
                		</xsl:otherwise>
                	</xsl:choose>
                </div>
            </xsl:otherwise>
        </xsl:choose>
	</xsl:template>
	
	<!-- custom : link list header -->
	<xsl:template name="panel-list-header-link">
        <xsl:param name="list" />
        <xsl:param name="module" />
        <xsl:param name="originID" />
        <xsl:param name="dependency" />
        <xsl:param name="targetModule" />
        <xsl:param name="addNew" />
        <xsl:param name="addNewScript" />
        
		<xsl:if test="/RESPONSE/URL/quicksearch-text/text()">
	        <xsl:call-template name="nav-new">
	            <xsl:with-param name="title">Create new file...</xsl:with-param>
	            <xsl:with-param name="module" select="$targetModule" />
	            <xsl:with-param name="panelURI" select="'documents/FileNew'" />
	            <xsl:with-param name="params">
		            <xsl:text>searchText:'</xsl:text>
		            <xsl:value-of select="/RESPONSE/URL/quicksearch-text" />
		            <xsl:text>',targetID:</xsl:text><xsl:value-of select="$originID"/>
		            <xsl:text>,targetModule:'</xsl:text>
		            <xsl:value-of select="$targetModule"/>
		            <xsl:text>', dependency:'</xsl:text>
		            <xsl:value-of select="$dependency"/>
		            <xsl:text>'</xsl:text>
	            </xsl:with-param>
	            <xsl:with-param name="cssclass" select="'grey-bkgnd'" />
	        </xsl:call-template>
        </xsl:if>
	</xsl:template>
</xsl:stylesheet>