<?xml version="1.0"?>
<!--

Officity - Web application platform - Version 6.0 - 2011-07-05

François Dispaux, Boris Verdeyen, Thomas Hermant,
Jérémie Roy, Grégory Meurice, Abdelila Harbi, 
Marc Mignonsin, Jonathan Sanchez, Julien Gonzalez, Pierre Fouchez

Sushee and Officity is © Copyright 2011 Nectil SA.

`/var/www/installer/public_html/officity-source/apps/officity/lib/documents/PageDetails.xsl` is part of Officity.

Sushee is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

Officity and Sushee are distributed in the hope that they will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Sushee. If not, see <http://www.gnu.org/licenses/>.

-->
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0" xmlns:OFFICITY="http://officity.com">
	<xsl:import href="include.xsl"/>	
	<xsl:output encoding="UTF-8" method="xml" indent="no"/>
	<xsl:strip-space elements="*"/>
	
	<!-- parameters -->
	<xsl:param name="fields" select="/RESPONSE/RESULTS[@name='fields']/FIELD"/>
	<xsl:param name="depentities" select="/RESPONSE/RESULTS[@name='dependencies']/DEPENDENCYENTITY"/>
  	<!--xsl:param name="descriptions" select="/RESPONSE/RESULTS[@name='descriptions']/DESCRIPTIONCONFIG"/-->
	<xsl:param name="item" select="/RESPONSE/RESULTS[@name='item']/*[1]"/>
	<xsl:param name="itemInfo" select="$item/INFO"/>
	<xsl:param name="itemDeps" select="$item/DEPENDENCIES"/>
	<xsl:param name="itemDescs" select="$item/DESCRIPTIONS"/>
	<xsl:param name="module" select="/RESPONSE/URL/module"/>
	<xsl:param name="categories" select="/RESPONSE/RESULTS/CATEGORY"/>
	
    <!-- IDs -->
    <xsl:param name="tinyClass">
		<xsl:text>mceEditor-</xsl:text>
		<xsl:value-of select="$panelID" />
    </xsl:param>
	
   	<xsl:template match="/RESPONSE">
		<xsl:call-template name="panel">
		</xsl:call-template>
	</xsl:template>
    
    <xsl:template name="panel-body">
    	<div class="wiki-header" id="wiki-header">
	    	<xsl:apply-templates select="$item" mode="element-title" />
			<p class="details">
				<xsl:apply-templates select="$item/INFO/MODIFIER/*[1]" mode="element-label" />
				<xsl:text>, </xsl:text>
				<xsl:apply-templates select="$item/INFO/MODIFICATIONDATE" mode="datetime" />
			</p>
			<a class="edit-action" href="#" title="Edit page" />
		</div>
		<div class="wiki-header" id="wiki-header-edit">
			<table width="100%">
				<tr>
					<td align="left" valign="top">
						<xsl:apply-templates select="$item" mode="element-title" />
					</td>
					<td align="right" valign="top">						
						<input id="cancel-button" class="input-submit-cancel" value="Cancel" type="button" />			
						<input id="save-button" class="button input-submit-save" value="Save" type="button" />
					</td>
				</tr>
			</table>
		</div>
    	<div class="wiki-body" id="wiki-body">
			<xsl:apply-templates select="$item" mode="element-wiki-body" />			
		</div>
		<div class="wiki-body-edit" id="wiki-body-edit">
			<xsl:call-template name="element-tabform-create">
				<xsl:with-param name="denom" select="'pageform'"/>
				<xsl:with-param name="element" select="$item" />
				<xsl:with-param name="content">
   					<xsl:call-template name="form-empty-line" />
					
					<xsl:apply-templates select="$item/DESCRIPTIONS/DESCRIPTION[@languageID=/RESPONSE/NECTIL/language]/TITLE" mode="form-desc-line">
						<xsl:with-param name="type" select="'text'" />
					</xsl:apply-templates>
					<xsl:apply-templates select="$item/INFO/DOCUMENTTYPE" mode="form-info-line" />
					<xsl:apply-templates select="$item/INFO/PATH" mode="form-info-line" />
 					
 					<xsl:call-template name="form-empty-line" />
 					
 					<xsl:apply-templates select="$item/DESCRIPTIONS/DESCRIPTION[@languageID=/RESPONSE/NECTIL/language]/BODY" mode="form-desc-line">
						<xsl:with-param name="type" select="'styled'" />
						<xsl:with-param name="cssclass" select="$tinyClass" />
						<xsl:with-param name="fullWidth" select="true()" />
 					</xsl:apply-templates>
 					
 					<xsl:call-template name="form-empty-line" />
 					
 					<xsl:call-template name="form-line">
 						<xsl:with-param name="content">
 							<input id="delete-button" class="input-submit-remove" value="Delete" type="button" />
 						</xsl:with-param>
 						<xsl:with-param name="center" select="true()" />
 					</xsl:call-template>
				</xsl:with-param>
			</xsl:call-template>
		</div>
    </xsl:template>
    
    <xsl:template match="OFFICITY:LIBITEM[INFO/TYPE='page' and INFO/KIND!='image']" mode="element-wiki-body">
		<xsl:apply-templates select="$item" mode="element-body" />
		<xsl:apply-templates select="$item" mode="element-file" />
    </xsl:template>
    
    <xsl:template match="OFFICITY:LIBITEM[INFO/TYPE='page' and INFO/KIND='image']" mode="element-wiki-body">
		<xsl:apply-templates select="$item" mode="element-file" />
		<xsl:apply-templates select="$item" mode="element-body" />	
    </xsl:template>
    
    <!-- embedded file -->
    <xsl:template match="OFFICITY:LIBITEM[INFO/TYPE='page']" mode="element-file">
    	<div class="file-container">
    		<a class="officity__libitem-file {INFO/KIND}" href="#" title="Download file" onclick="window.location.replace('{$systemToolsURL}file_download.php?target={INFO/PATH}');">
    			<xsl:value-of select="INFO/FILENAME" />
    		</a>
    	</div>
    </xsl:template>

    <!-- embedded image file -->
    <xsl:template match="OFFICITY:LIBITEM[INFO/TYPE='page' and INFO/KIND='image']" mode="element-file">
    	<div class="img-container">
	    	<a href="#" title="Download original image" onclick="window.location.replace('{$systemToolsURL}file_download.php?target={INFO/PATH}');">
		    	<img>
	    			<xsl:attribute name="src">
						<xsl:value-of select="$filesURL" />
						<xsl:value-of select="substring-before(INFO/PATH,INFO/FILENAME)"/>
			        	<xsl:text>resources/preview.jpg</xsl:text>
		    		</xsl:attribute>
		    	</img><br />
	    		<xsl:text>download</xsl:text>
	    	</a>
    	</div>
    </xsl:template>
        
    <!-- embedded sound/video file -->
    <xsl:template match="OFFICITY:LIBITEM[INFO/TYPE='page' and INFO/KIND='audio']" mode="element-file">
    	<div class="file-container" style="text-align:center;">
    		<div id="mediaplayer-{$panelID}" />
    	</div>
    	<script type="text/javascript">
	 		<xsl:call-template name="js-embed-mediaplayer">
	    		<xsl:with-param name="file" select="INFO/PATH" />
	    		<xsl:with-param name="containerID" select="concat('mediaplayer-', $panelID)" />
		    	<xsl:with-param name="width" select="320" />
	    		<xsl:with-param name="height" select="20" />
	    	</xsl:call-template>
    	</script>
    </xsl:template>
    
    <xsl:template match="OFFICITY:LIBITEM[INFO/TYPE='page' and INFO/KIND='video']" mode="element-file">
    	<div class="file-container" style="text-align:center;">
    		<div id="mediaplayer-{$panelID}" />
    	</div>
    	<script type="text/javascript">
	 		<xsl:call-template name="js-embed-mediaplayer">
	    		<xsl:with-param name="file" select="INFO/PATH" />
	    		<xsl:with-param name="containerID" select="concat('mediaplayer-', $panelID)" />
		    	<xsl:with-param name="width" select="320" />
	    		<xsl:with-param name="height" select="200" />
	    	</xsl:call-template>
    	</script>
    </xsl:template>
    
	<xsl:template name="panel-add-js">
		$('#<xsl:value-of select="$panelID" />.panel').find('#wiki-header').find('.edit-action').click(function(){
			<xsl:call-template name="js-init-tinyMCE">	
				<xsl:with-param name="textareaClass" select="$tinyClass" />
			</xsl:call-template>
			
			var wikiHeader = $(this).closest('#wiki-header');
			wikiHeader.hide().next('#wiki-header-edit').show();
			var wikiBody = wikiHeader.nextAll('#wiki-body').hide();
			var wikiBodyEdit = wikiBody.next('#wiki-body-edit').show();	
		});
		
		$('#<xsl:value-of select="$panelID" />.panel').find('#wiki-header-edit').find('#cancel-button').click(function(){
			var wikiHeaderEdit = $(this).closest('#wiki-header-edit');
			wikiHeaderEdit.hide().prev('#wiki-header').show();
			var wikiBodyEdit = wikiHeaderEdit.nextAll('#wiki-body-edit').hide();
			var wikiBody = wikiBodyEdit.prev('#wiki-body').show();		
		});
		
		$('#<xsl:value-of select="$panelID" />.panel').find('#<xsl:call-template name="gen-tabID"><xsl:with-param name="denom" select="'pageform'" /></xsl:call-template>').submit(function(){
          	fm = new FormManager(<xsl:value-of select="$panelID"/>, AppController);

			fm.onSuccess(function(response){
               <xsl:text>$(AppController).panelslider('reloadPanel', </xsl:text>
                   <xsl:value-of select="$panelID"/>
               <xsl:text>, 1);</xsl:text>
			});						
			fm.setScript('<xsl:apply-templates select="$item" mode="element-script-update"/>');

			fm.displayProcess('Saving page...');		  
			
            // makes a cleanup and moves the content from the editor to the form field
            tinyMCE.triggerSave();  

			fm.parseAndSend(this);					
			return false;
		});
		
		$('#<xsl:value-of select="$panelID" />.panel').find('#wiki-header-edit').find('#save-button').click(function(){
			$('#<xsl:value-of select="$panelID" />.panel').find('#<xsl:call-template name="gen-tabID"><xsl:with-param name="denom" select="'pageform'" /></xsl:call-template>').submit();
		});
		
		$('#<xsl:value-of select="$panelID" />.panel').find('#wiki-body-edit').find('#delete-button').click(function(){
	        var deleteRequest = new AjaxRequest(
	            <xsl:value-of select="$panelID"/>,
	            AppController,
	            '<xsl:apply-templates select="$item" mode="element-script-delete"/>',
	            'POST',
	            'json'
	        );
	
	        deleteRequest.addData('ID', <xsl:value-of select="$item/@ID" />);
	
	        // error dialog and return errors in long msgs format
	        deleteRequest.errorDialog(true, false);
	        deleteRequest.internalErrorDialog(true, false); 
	
	        deleteRequest.onSuccess(function(response){
	           $(AppController).panelslider('removePanel', <xsl:value-of select="$panelID"/>, 1);
	        }).send();
	        	
	        return false;
		});
	</xsl:template>
</xsl:stylesheet>