<?xml version="1.0"?>
<!--

Officity - Web application platform - Version 6.0 - 2011-07-05

François Dispaux, Boris Verdeyen, Thomas Hermant,
Jérémie Roy, Grégory Meurice, Abdelila Harbi, 
Marc Mignonsin, Jonathan Sanchez, Julien Gonzalez, Pierre Fouchez

Sushee and Officity is © Copyright 2011 Nectil SA.

`/var/www/installer/public_html/officity-source/apps/officity/lib/documents/VersionDetails.xsl` is part of Officity.

Sushee is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

Officity and Sushee are distributed in the hope that they will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Sushee. If not, see <http://www.gnu.org/licenses/>.

-->
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0" xmlns:OFFICITY="http://officity.com">
	<xsl:import href="include.xsl"/>	
	<xsl:output encoding="UTF-8" method="xml" indent="no"/>
	<xsl:strip-space elements="*"/>
	
	<!-- parameters -->
	<xsl:param name="fields" select="/RESPONSE/RESULTS[@name='fields']/FIELD"/>
	<xsl:param name="depentities" select="/RESPONSE/RESULTS[@name='dependencies']/DEPENDENCYENTITY"/>
  	<!--xsl:param name="descriptions" select="/RESPONSE/RESULTS[@name='descriptions']/DESCRIPTIONCONFIG"/-->
	<xsl:param name="item" select="/RESPONSE/RESULTS[@name='item']/*[1]"/>
	<xsl:param name="itemInfo" select="$item/INFO"/>
	<xsl:param name="itemDeps" select="$item/DEPENDENCIES"/>
	<xsl:param name="itemDescs" select="$item/DESCRIPTIONS"/>
	<xsl:param name="module" select="/RESPONSE/URL/module"/>
	<xsl:param name="categories" select="/RESPONSE/RESULTS/CATEGORY"/>
	
	<xsl:param name="file" select="/RESPONSE/RESULTS[@name='file']/OFFICITY:LIBITEM" />
	
   	<xsl:template match="/RESPONSE">
		<xsl:call-template name="panel-elementdetails">
			<xsl:with-param name="element" select= "$item" />
			<xsl:with-param name="tabsList">
			</xsl:with-param>
			 <xsl:with-param name="displayOverviewTab" select="true()" />
			 <xsl:with-param name="displayAdminTab" select="true()" />
			 <xsl:with-param name="deleteRight" select="false()" />
		</xsl:call-template>
	</xsl:template>

    <!-- no preview -->
    <xsl:template name="panel-block-details-preview-element">
    </xsl:template>

	<!-- custom : tabs content -->
	<xsl:template name="panel-body-element-tabs-content">
		<xsl:param name="element" />
		<xsl:param name="newElement" />
	</xsl:template>
	
	<!-- custom : overview -->
	<xsl:template name="element-tab-overview">
		<xsl:param name="element" />  
		<xsl:param name="legend" />  
		
		<xsl:apply-templates select="$element" mode="overview-details" />
		
		<div class="libitem-actions">
			<a href="{$systemToolsURL}file_download.php?target={$element/INFO/PATH}" title="Download" class="action download">
				<xsltext>Download</xsltext>
	   		</a>
			<a href="{$systemToolsURL}file_download.php?target={$element/INFO/PATH}&amp;zip=true" title="Compress" class="action compress">
				<xsltext>Compress &amp; download</xsltext>
	   		</a>
			<!--a href="#" title="Copy link" class="action copylink">
				<xsl:attribute name="onclick">
				</xsl:attribute>
				<xsltext>Copy link</xsltext>
	   		</a-->
       		<form>
       			<input type="hidden" name="versionID" value="{$element/@ID}" />
       			<input type="hidden" name="fileID" value="{$file/@ID}" />
       			<input type="hidden" name="version-number" value="{number($file/DEPENDENCIES/DEPENDENCY[@type='officity:versions']/@hits)+1}" />
       			
	        	<a href="#" title="Restore version" class="action restoreversion">
	        		<xsl:attribute name="onclick">
				        fm = new FormManager(<xsl:value-of select="$panelID"/>, AppController);
				
				        fm.onSuccess(delegate(this, function(response){
				            $('#slider').find('<xsl:apply-templates select="$file" mode="element-panel-details-selector"/>').trigger('panel-refresh');
				        }));
				
				        fm.displayProcess('Restoring version...');
				        fm.setScript('<xsl:apply-templates select="$file" mode="element-script-restoreversion" />');
				        fm.parseAndSend(this.parentNode);
				
				        return false;
	        		</xsl:attribute>
	        		<xsl:text>Restore version</xsl:text>
	       		</a>
       		</form>
	   		<xsl:call-template name="breaker" />
		</div>
 	</xsl:template>   	

	<xsl:template match="OFFICITY:LIBVERSION" mode="overview-details">
		<table class="fields">			
			<xsl:apply-templates select="INFO/FILENAME" mode="overview-line" />
			<xsl:apply-templates select="INFO/SIZE" mode="overview-line">
				<xsl:with-param name="value">
					<xsl:value-of select="INFO/SIZEHUMAN" />
					<xsl:text> (</xsl:text>
					<xsl:value-of select="INFO/SIZE" />
					<xsl:text> bytes)</xsl:text>
				</xsl:with-param>
			</xsl:apply-templates>
			<xsl:apply-templates select="INFO/VERSIONNUMBER" mode="overview-line" />
			<xsl:apply-templates select="INFO/CREATIONDATE" mode="overview-line" />
			<xsl:call-template name="overview-line">
				<xsl:with-param name="label" select="'Created by:'" />
				<xsl:with-param name="value">
					<xsl:apply-templates select="INFO/CREATOR/CONTACT" mode="element-label"/>
				</xsl:with-param>
			</xsl:call-template>
			<xsl:apply-templates select="INFO/MODIFICATIONDATE" mode="overview-line" />
			<xsl:call-template name="overview-line">
				<xsl:with-param name="label" select="'Modified by:'" />
				<xsl:with-param name="value">
					<xsl:apply-templates select="INFO/MODIFIER/CONTACT" mode="element-label"/>
				</xsl:with-param>
			</xsl:call-template>
			<xsl:apply-templates select="INFO/KIND" mode="overview-line" />
			<xsl:apply-templates select="INFO/VERSIONNOTES" mode="overview-line">
				<xsl:with-param name="topLabel" select="true()" />
			</xsl:apply-templates>
			<xsl:call-template name="form-empty-line" />
		</table>
	 </xsl:template>
		 
  	<!-- custom : navigation details -->
	<xsl:template name="panel-block-details-nav-element">
		<xsl:param name="element" select="$element" />

		<xsl:call-template name="navigationdetailsitem">
			<xsl:with-param name="title">
				<xsl:text>File</xsl:text>
			</xsl:with-param>
			<xsl:with-param name="panelURI">
				<xsl:apply-templates select="$file" mode="element-script-detail" />
			</xsl:with-param>
			<xsl:with-param name="params">
				<xsl:text>ID:</xsl:text>
				<xsl:value-of select="$file/@ID" />
			</xsl:with-param>
			<xsl:with-param name="icon">
			</xsl:with-param> 
			<xsl:with-param name="cssclass">first</xsl:with-param>
		</xsl:call-template>
		
		<xsl:call-template name="new-followup">
			<xsl:with-param name="title" select="'Notes'"/>
			<xsl:with-param name="element" select="$element" />		  
		</xsl:call-template>
		<xsl:call-template name="history-list">
			<xsl:with-param name="title">History</xsl:with-param>
			<xsl:with-param name="element" select="$element" />
			<xsl:with-param name="cssclass">last</xsl:with-param>
		</xsl:call-template>
	</xsl:template>
	
	<!-- custom : additional js -->
	<xsl:template name="panel-add-js">

	</xsl:template>
</xsl:stylesheet>