<?php
/*
Officity - Web application platform - Version 6.0 - 2011-07-05

François Dispaux, Boris Verdeyen, Thomas Hermant,
Jérémie Roy, Grégory Meurice, Abdelila Harbi, 
Marc Mignonsin, Jonathan Sanchez, Julien Gonzalez, Pierre Fouchez

Sushee and Officity is © Copyright 2011 Nectil SA.

`/var/www/installer/public_html/officity-source/apps/officity/lib/documents/VirtualServerContent.php` is part of Officity.

Sushee is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

Officity and Sushee are distributed in the hope that they will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Sushee. If not, see <http://www.gnu.org/licenses/>.
*/
    require_once(dirname(__FILE__).'/include.php');
    
    function addVirtualServer(&$nql)
    {
        $server_nql = new Sushee_Shell(false);
	    $server_nql->addCommand('
	    	<SEARCH name="servers">
	    		<OFFICITY:LIBITEM>
	    			<INFO>
	    				<TYPE operator="=">server</TYPE>
	    			</INFO>
	    		</OFFICITY:LIBITEM>
	    		<RETURN>
	    			<NOTHING />
	    		</RETURN>
	    	</SEARCH>
	    ');
	    $server_nql->execute();
	    $servers = $server_nql->getElements('/RESPONSE/RESULTS/OFFICITY:LIBITEM');
	       
	    if (count($servers) == 0)
	    {
	    	throw new OfficityAppException('Virtual server not found!');
	    }
	    else if (count($servers) > 1)
	    {
	    	throw new OfficityAppException('Multiple virtual servers found!');
	    }
	    
	    $nql->addStatic($servers[0]->toString(), 'server');
	    
	    return $servers[0];
    }
    
    /* *** */
   
    $nql = new Officity_Shell();
    
    
    $nql->addCommand('
    	<GETCHILDREN name="list" type="officity:content">
            <OFFICITY:LIBITEM ID="'.URLParam::fetch('serverID').'" />
            <RETURN>
                <INFO>
					<TITLE />
					<TYPE />
					<TRASHED />
                </INFO>
            </RETURN>
    	</GETCHILDREN>
    ');    
    
    addVirtualServer($nql);
	
	die ($nql->transform(dirname(__FILE__).'/VirtualServerContent.xsl'));
      
?>