<?xml version="1.0"?>
<!--

Officity - Web application platform - Version 6.0 - 2011-07-05

François Dispaux, Boris Verdeyen, Thomas Hermant,
Jérémie Roy, Grégory Meurice, Abdelila Harbi, 
Marc Mignonsin, Jonathan Sanchez, Julien Gonzalez, Pierre Fouchez

Sushee and Officity is © Copyright 2011 Nectil SA.

`/var/www/installer/public_html/officity-source/apps/officity/shared/followup/List.xsl` is part of Officity.

Sushee is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

Officity and Sushee are distributed in the hope that they will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Sushee. If not, see <http://www.gnu.org/licenses/>.

-->
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0" xmlns:OFFICITY="http://officity.com" xmlns:IPA="http://www.ipa.org.uk/">
	<xsl:import href="../shared.include.xsl"/>	
	<xsl:output encoding="UTF-8" method="xml" indent="no"/>
	<xsl:strip-space elements="*"/>
	
	<xsl:param name="element-template" select="/RESPONSE/RESULTS[@name='element-template']/*[1]"/>
	
   	<xsl:template match="/RESPONSE">
    	<xsl:call-template name="panel">
    	</xsl:call-template>
    </xsl:template>
    
   	<xsl:template name="panel-header">
		<div class="block block-details block-details-followups">
			<a id="write-note" class="write" href="#">
				<xsl:text>Leave a note...</xsl:text>
			</a>
			<form id="form-followup" style="display:none;">
				<input type="hidden" name="elementID" value="{/RESPONSE/URL/elementID}"/>
				<input type="hidden" name="moduleID" value="{/RESPONSE/URL/moduleID}"/>
	
				<table class="fields">
					<xsl:apply-templates select="$element-template/INFO/TYPE" mode="form-info-line">
					</xsl:apply-templates>
					<xsl:apply-templates select="$element-template/INFO/FILE" mode="form-info-line">
					</xsl:apply-templates>
					<xsl:apply-templates select="$element-template/INFO/BODY" mode="form-info-line">
						<xsl:with-param name="type" select="'textarea'" />
						<!--xsl:with-param name="required" select="true()" /-->
					</xsl:apply-templates>
					<xsl:call-template name="form-empty-line" />
					
			        <tr>
			            <td class="field-name">
			            	&#160;
			            </td>
			            <td class="field-value" align="right">
			                <input type="submit" name="create-update-button" class="input-submit-save" value="Add" />
			                <input type="button" id="cancel-button" class="input-submit-cancel" value="Cancel" style="margin-left:20px;"/>
			            </td>
			        </tr>
				</table>
			</form>
		</div>
    </xsl:template>
    
    <xsl:template name="panel-body">
		<div class="block block-details block-details-followups">
			<xsl:choose>
				<xsl:when test="count(/RESPONSE/RESULTS[@name='followups']/*) > 0">
					<ul>
						<xsl:for-each select="/RESPONSE/RESULTS[@name='followups']/*">
							<xsl:apply-templates select="." mode="element-detail" />
						</xsl:for-each>
					</ul>			
            	</xsl:when>
		            <xsl:otherwise>
		                <div class="no-result">No notes</div>
		            </xsl:otherwise>
	        </xsl:choose>
		</div>
    </xsl:template>
    
	<xsl:template match="OFFICITY:FOLLOWUP" mode="element-detail">
		<li class="{INFO/TYPE}">
			<xsl:attribute name="id">
				<xsl:apply-templates select="." mode="element-id" />
			</xsl:attribute>
			<h2>
				<xsl:apply-templates select="." mode="element-label"/>
				<xsl:if test="INFO/FILE/text()">
					<xsl:text> - </xsl:text>
					<a href="{$filesURL}{INFO/FILE}" target="_blank" title="View/Download" style="cursor:pointer !important;">
						<xsl:call-template name="basename">
							<xsl:with-param name="path" select="INFO/FILE" />
						</xsl:call-template>
					</a>
				</xsl:if>
			</h2>
			<h3>
				<xsl:value-of select="INFO/TITLE"/>
			</h3>
			<p>
				<xsl:copy-of select="INFO/BODY/node()"/>
			</p>
		</li>
	</xsl:template>
    
    <xsl:template name="panel-js">
    	<xsl:call-template name="js-init-autoresize" />
    	
    	//var inputsValidator<xsl:value-of select="$panelID"/> = new InputsValidator(<xsl:value-of select="$panelID"/>, '#form-followup');
    	
    	$panel.find('#write-note').click(function(){
			$(this).hide();
			$panel.find('#form-followup').slideToggle('fast', function(){
				$panel.trigger('panel-layout');
			});
			return false;
    	});
    	$panel.find('#cancel-button').click(function(){
			$(this).closest('#form-followup').hide();
			$panel.find('#write-note').show();
			$panel.trigger('panel-layout');
			return false;
    	});
    	
		$panel.find('#form-followup').submit(function(){
		    fm = new FormManager(<xsl:value-of select="$panelID"/>, AppController);
		
			fm.onSuccess(function(response){
		        $('#<xsl:value-of select="$panelID"/>.panel').trigger('panel-reload');
			});
		
		    fm.displayProcess('Adding note...');
		    fm.setScript('<xsl:apply-templates select="$element-template" mode="element-script-create" />');
			fm.parse(this);
			fm.send();

			return false;
		});
    </xsl:template>
</xsl:stylesheet>
