<?php
/*
Officity - Web application platform - Version 6.0 - 2011-07-05

François Dispaux, Boris Verdeyen, Thomas Hermant,
Jérémie Roy, Grégory Meurice, Abdelila Harbi, 
Marc Mignonsin, Jonathan Sanchez, Julien Gonzalez, Pierre Fouchez

Sushee and Officity is © Copyright 2011 Nectil SA.

`/var/www/installer/public_html/officity-source/apps/officity/shared/libitem/libitem.class.php` is part of Officity.

Sushee is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

Officity and Sushee are distributed in the hope that they will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Sushee. If not, see <http://www.gnu.org/licenses/>.
*/    
	class Officity_LibitemElement extends Element
	{
		function __construct($ID=0)
		{
			parent::__construct('OFFICITY:LIBITEM', $ID);
			$this->setInfo('TRASHED', 'no');	
		}

		function __destruct()
		{
			parent::__destruct();
		}

		public function setDisplayProfile()
		{
			$this->addXMLReturn('
				<INFO>
					<TITLE />
					<SUMMARY />
					<TYPE />
					<EXT />
					<KIND />
					<SIZEHUMAN />
					<ITEMS />
					<TRASHED />
					<VERSIONNUMBER />
				</INFO>
			');
			$this->addXMLReturn('
				<DESCRIPTIONS>
					<DESCRIPTION>
						<TITLE />
						<SUMMARY />
					</DESCRIPTION>
				</DESCRIPTIONS>
			');
		}
		
		public function addSharedResourcesCommands(&$nql)
		{
			$nql->addMonths(); // versions			
		}
		
	    /* *** */
		
		public function isWiki()
		{
			return in_array($this->getInfo('TYPE'), array('book', 'chapter', 'page'));
		}
		
		/* *** */
	
		public function destroy()
		{
			if (($ID = $this->getID()) == 0) return false;
	
            $nql = new Officity_Shell();
	
			// 1st : kill all direct elements in dependencies
			/*$kill_command = '
				<KILL name="kill-element">
					<DUMMY>
						<WHERE>
							<DEPENDENCY type="editor:dummyDependency" mode="reverse">
								<DUMMYTARGET ID="'.$ID.'" />
							</DEPENDENCY>
						</WHERE>
					</DUMMY>
				</KILL>';
			$nql->addCommand($kill_command);
	
			$nql->execute();*/
	
			// 2nd : kill kill
			if (parent::destroy() == true)
			{
				return true;
			}
	
			return false;
		}
	}
?>
